/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6025;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.CommonProxy;

public enum AnimalOwnerProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        String name;
        if (accessor.getServerData().method_10545("OwnerName")) {
            name = accessor.getServerData().method_10558("OwnerName");
        } else {
            UUID ownerUUID = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
            if (ownerUUID == null) {
                return;
            }
            name = CommonProxy.getLastKnownUsername(ownerUUID);
            if (name == null) {
                name = "???";
            }
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"jade.owner", (Object[])new Object[]{name}));
    }

    @Override
    public void appendServerData(class_2487 data, EntityAccessor accessor) {
        String name;
        UUID ownerUUID = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
        if (ownerUUID != null && (name = CommonProxy.getLastKnownUsername(ownerUUID)) != null) {
            data.method_10582("OwnerName", name);
        }
    }

    public static UUID getOwnerUUID(class_1297 entity) {
        if (entity instanceof class_6025) {
            class_6025 ownableEntity = (class_6025)entity;
            return ownableEntity.method_6139();
        }
        return null;
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        class_1297 entity = accessor.getEntity();
        return entity instanceof class_6025 && AnimalOwnerProvider.getOwnerUUID(entity) == null;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_ANIMAL_OWNER;
    }
}

