/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1263;
import net.minecraft.class_1273;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7265;
import net.minecraft.class_8934;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public abstract class ItemStorageProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.getServerData().method_10545("JadeItemStorage")) {
            if (accessor.getServerData().method_10577("Loot")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"jade.loot_not_generated"));
            } else if (accessor.getServerData().method_10577("Locked")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"jade.locked"));
            }
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeItemStorageUid"))).map(WailaClientRegistration.instance().itemStorageProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeItemStorage", itemTag -> {
                class_1799 item = class_1799.method_57359((class_7225.class_7874)accessor.getLevel().method_30349(), (class_2487)itemTag);
                if (!item.method_7960() && itemTag.method_10545("NewCount")) {
                    item.method_7939(itemTag.method_10550("NewCount"));
                }
                return item;
            }));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip, provider.getUid().method_12836());
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        MutableBoolean showName = new MutableBoolean(true);
        MutableInt amountWidth = new MutableInt();
        int showNameAmount = PluginConfig.INSTANCE.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_SHOW_NAME_AMOUNT);
        int totalSize = 0;
        for (ClientViewGroup clientViewGroup : groups) {
            for (ItemView view : clientViewGroup.views) {
                if (view.amountText != null) {
                    showName.setFalse();
                }
                if (!view.item.method_7960() && ++totalSize == showNameAmount) {
                    showName.setFalse();
                }
                if (!showName.isTrue()) continue;
                String s = IDisplayHelper.get().humanReadableNumber(view.item.method_7947(), "", false, null);
                amountWidth.setValue(Math.max(amountWidth.intValue(), class_310.method_1551().field_1772.method_1727(s)));
            }
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            float progress;
            class_2487 data;
            if (renderGroup) {
                theTooltip.add(new HorizontalLineElement());
                if (group.title != null) {
                    theTooltip.append(helper.text(group.title).scale(0.5f));
                    theTooltip.append(new HorizontalLineElement());
                }
            }
            if (group.views.isEmpty() && (data = group.extraData) != null && data.method_10573("Collecting", 99) && (progress = data.method_10583("Collecting")) < 1.0f) {
                class_5250 component = class_2561.method_43471((String)"jade.collectingItems");
                if (progress > 0.0f) {
                    component.method_27693(" %s%%".formatted((int)(progress * 100.0f)));
                }
                theTooltip.add((class_2561)component);
            }
            int drawnCount = 0;
            int realSize = PluginConfig.INSTANCE.getInt(accessor.showDetails() ? JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT : JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
            realSize = Math.min(group.views.size(), realSize);
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < realSize; ++i) {
                ItemView itemView = (ItemView)group.views.get(i);
                class_1799 stack = itemView.item;
                if (stack.method_7960()) continue;
                if (i > 0 && (showName.isTrue() || drawnCount >= PluginConfig.INSTANCE.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_ITEMS_PER_LINE))) {
                    theTooltip.add(elements);
                    theTooltip.setLineMargin(-1, ScreenDirection.DOWN, 0);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName.isTrue()) {
                    if (itemView.description != null) {
                        elements.add(helper.smallItem(stack));
                        elements.addAll(itemView.description);
                    } else {
                        elements.add(helper.smallItem(stack).clearCachedMessage());
                        String s = IDisplayHelper.get().humanReadableNumber(stack.method_7947(), "", false, null);
                        int width = class_310.method_1551().field_1772.method_1727(s);
                        if (width < amountWidth.intValue()) {
                            elements.add(helper.spacer(amountWidth.intValue() - width, 0));
                        }
                        elements.add(helper.text((class_2561)class_2561.method_43470((String)s).method_27693("\u00d7 ").method_10852((class_2561)IDisplayHelper.get().stripColor(stack.method_7964()))).message(null));
                    }
                } else if (itemView.amountText != null) {
                    elements.add(helper.item(stack, 1.0f, itemView.amountText));
                } else {
                    elements.add(helper.item(stack));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                theTooltip.add(elements);
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        class_8934 containerEntity;
        class_2487 tag = accessor.getServerData();
        Object target = accessor.getTarget();
        class_1657 player = accessor.getPlayer();
        for (IServerExtensionProvider<class_1799> provider : WailaCommonRegistration.instance().itemStorageProviders.get(accessor)) {
            List groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null, provider.getUid().method_12836());
                continue;
            }
            if (groups == null) continue;
            if (!ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                int count = item.method_7947();
                if (count > item.method_7914()) {
                    item.method_7939(1);
                }
                class_2487 itemTag = (class_2487)item.method_57358((class_7225.class_7874)accessor.getLevel().method_30349());
                if (count > item.method_7914()) {
                    itemTag.method_10569("NewCount", count);
                    item.method_7939(count);
                }
                return itemTag;
            })) break;
            tag.method_10582("JadeItemStorageUid", provider.getUid().toString());
            return;
        }
        if (target instanceof class_8934 && (containerEntity = (class_8934)target).method_54869() != null) {
            tag.method_10556("Loot", true);
        } else if (!player.method_7337() && !player.method_7325() && target instanceof class_2624) {
            class_2624 te = (class_2624)target;
            if (te.field_12045 != class_1273.field_5817) {
                tag.method_10556("Locked", true);
            }
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        if (accessor.getTarget() instanceof class_2609) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 tag, T accessor) {
        if (accessor.getTarget() instanceof class_2609) {
            return;
        }
        ItemStorageProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (accessor.getTarget() instanceof class_2609) {
            return false;
        }
        int amount = accessor.showDetails() ? IWailaConfig.get().getPlugin().getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT) : IWailaConfig.get().getPlugin().getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
        if (amount == 0) {
            return false;
        }
        for (IServerExtensionProvider<class_1799> provider : WailaCommonRegistration.instance().itemStorageProviders.get((Accessor<?>)accessor)) {
            if (!provider.shouldRequestData((Accessor<?>)accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    public static class ForBlock
    extends ItemStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends ItemStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<class_1799>,
    IClientExtensionProvider<class_1799, ItemView>
    {
        INSTANCE;


        @Override
        public class_2960 getUid() {
            return JadeIds.UNIVERSAL_ITEM_STORAGE_DEFAULT;
        }

        @Override
        @Nullable
        public List<ViewGroup<class_1799>> getGroups(Accessor<?> accessor) {
            ItemCollector itemCollector;
            class_7265 containerEntity;
            class_8934 te;
            Object target = accessor.getTarget();
            if (target == null) {
                return CommonProxy.createItemCollector(accessor, containerCache).update(accessor);
            }
            if (target instanceof class_8934 && (te = (class_8934)target).method_54869() != null) {
                return null;
            }
            if (target instanceof class_7265 && (containerEntity = (class_7265)target).method_42276() != null) {
                return null;
            }
            class_1657 player = accessor.getPlayer();
            if (!player.method_7337() && !player.method_7325() && target instanceof class_2624) {
                class_2624 te2 = (class_2624)target;
                if (te2.field_12045 != class_1273.field_5817) {
                    return null;
                }
            }
            if (target instanceof class_2611) {
                class_1730 inventory = player.method_7274();
                return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator($ -> inventory, 0)).update(accessor);
            }
            try {
                itemCollector = (ItemCollector)targetCache.get(target, () -> CommonProxy.createItemCollector(accessor, containerCache));
            }
            catch (ExecutionException e) {
                WailaExceptionHandler.handleErr(e, null, null, null);
                return null;
            }
            return itemCollector.update(accessor);
        }

        @Override
        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_1799>> groups) {
            return ClientViewGroup.map(groups, ItemView::new, null);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            Object target = accessor.getTarget();
            if (target instanceof class_2611 || target instanceof class_1263) {
                return true;
            }
            return CommonProxy.hasDefaultItemStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

