/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.source;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import me.lucko.spark.proto.SparkProtos;

public class SourceMetadata {
    private final String name;
    private final String version;
    private final String author;

    public static <T> List<SourceMetadata> gather(Collection<T> sources, Function<? super T, String> nameFunction, Function<? super T, String> versionFunction, Function<? super T, String> authorFunction) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (T source : sources) {
            String name = nameFunction.apply(source);
            String version = versionFunction.apply(source);
            String author = authorFunction.apply(source);
            SourceMetadata metadata = new SourceMetadata(name, version, author);
            builder.add((Object)metadata);
        }
        return builder.build();
    }

    public SourceMetadata(String name, String version, String author) {
        this.name = name;
        this.version = version;
        this.author = author;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public SparkProtos.PluginOrModMetadata toProto() {
        SparkProtos.PluginOrModMetadata.Builder builder = SparkProtos.PluginOrModMetadata.newBuilder().setName(this.name);
        if (this.version != null) {
            builder.setVersion(this.version);
        }
        if (this.author != null) {
            builder.setAuthor(this.author);
        }
        return (SparkProtos.PluginOrModMetadata)builder.build();
    }
}

