/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil.response;

import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.yggdrasil.response.Response;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class KeyPairResponse
extends Response {
    private KeyPair keyPair;
    @Nullable
    @SerializedName(value="publicKeySignature")
    private ByteBuffer legacyPublicKeySignature;
    @SerializedName(value="publicKeySignatureV2")
    private ByteBuffer publicKeySignature;
    private String expiresAt;
    private String refreshedAfter;

    public KeyPairResponse(KeyPair keyPair, @Nullable ByteBuffer legacyPublicKeySignature, ByteBuffer publicKeySignature, String expiresAt, String refreshedAfter) {
        this.keyPair = keyPair;
        this.legacyPublicKeySignature = legacyPublicKeySignature;
        this.publicKeySignature = publicKeySignature;
        this.expiresAt = expiresAt;
        this.refreshedAfter = refreshedAfter;
    }

    public String getPrivateKey() {
        return this.keyPair.privateKey;
    }

    public String getPublicKey() {
        return this.keyPair.publicKey;
    }

    @Nullable
    public ByteBuffer getLegacyPublicKeySignature() {
        return this.legacyPublicKeySignature;
    }

    public ByteBuffer getPublicKeySignature() {
        return this.publicKeySignature;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public String getRefreshedAfter() {
        return this.refreshedAfter;
    }

    public static final class KeyPair {
        private String privateKey;
        private String publicKey;

        public KeyPair(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }
    }
}

