/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.TelemetrySession;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.minecraft.report.AbuseReportLimits;
import com.mojang.authlib.yggdrasil.YggdrasilSocialInteractionsService;
import com.mojang.authlib.yggdrasil.request.AbuseReportRequest;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.concurrent.Executor;

public class YggdrasilUserApiService
extends YggdrasilSocialInteractionsService
implements UserApiService {
    public YggdrasilUserApiService(String accessToken, Proxy proxy, Environment env) throws AuthenticationException {
    }

    @Override
    public UserApiService.UserProperties properties() {
        return OFFLINE_PROPERTIES;
    }

    @Override
    public void refreshBlockList() {
    }

    @Override
    public TelemetrySession newTelemetrySession(Executor executor) {
        return TelemetrySession.DISABLED;
    }

    @Override
    public KeyPairResponse getKeyPair() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        generator.initialize(2048);
        KeyPair keyPair = generator.generateKeyPair();
        Base64.Encoder base64 = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
        String publicKeyPEM = "-----BEGIN RSA PUBLIC KEY-----\n" + base64.encodeToString(keyPair.getPublic().getEncoded()) + "\n-----END RSA PUBLIC KEY-----\n";
        String privateKeyPEM = "-----BEGIN RSA PRIVATE KEY-----\n" + base64.encodeToString(keyPair.getPrivate().getEncoded()) + "\n-----END RSA PRIVATE KEY-----\n";
        Instant now = Instant.now();
        Instant expiresAt = now.plus(48L, ChronoUnit.HOURS);
        Instant refreshedAfter = now.plus(36L, ChronoUnit.HOURS);
        return new KeyPairResponse(new KeyPairResponse.KeyPair(privateKeyPEM, publicKeyPEM), StandardCharsets.UTF_8.encode("AA=="), StandardCharsets.UTF_8.encode("AA=="), DateTimeFormatter.ISO_INSTANT.format(expiresAt), DateTimeFormatter.ISO_INSTANT.format(refreshedAfter));
    }

    @Override
    public void reportAbuse(AbuseReportRequest request) {
    }

    @Override
    public boolean canSendReports() {
        return false;
    }

    @Override
    public AbuseReportLimits getAbuseReportLimits() {
        return AbuseReportLimits.DEFAULTS;
    }
}

