/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;

public class YggdrasilServicesKeyInfo
implements ServicesKeyInfo {
    private static final int KEY_SIZE_BITS = 4096;
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private final PublicKey publicKey;
    private static final int KEY_SIZE_BYTES = 550;
    private static final String KEY_PATH = "/yggdrasil_session_pubkey.der";

    private YggdrasilServicesKeyInfo(PublicKey publicKey) {
        this.publicKey = publicKey;
        String algorithm = publicKey.getAlgorithm();
        if (!algorithm.equals(KEY_ALGORITHM)) {
            throw new IllegalArgumentException("Expected RSA key, got " + algorithm);
        }
    }

    public static ServicesKeyInfo parse(byte[] keyBytes) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(spec);
            return new YggdrasilServicesKeyInfo(publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException var4) {
            throw new IllegalArgumentException("Invalid yggdrasil public key!", var4);
        }
    }

    @Deprecated
    public static ServicesKeyInfo createFromResources() {
        try {
            byte[] keyBytes = new byte[550];
            URL keyUrl = YggdrasilServicesKeyInfo.class.getResource(KEY_PATH);
            if (keyUrl == null) {
                throw new RuntimeException("key not found: /yggdrasil_session_pubkey.der");
            }
            try (InputStream is = keyUrl.openStream();){
                int read = 0;
                int total = 0;
                while ((read = is.read(keyBytes, total += read, 550 - total)) > 0) {
                }
            }
            return YggdrasilServicesKeyInfo.parse(keyBytes);
        }
        catch (Exception var4) {
            throw new AssertionError("Missing/invalid yggdrasil public key!", var4);
        }
    }

    public static ServicesKeySet get(URL url, YggdrasilAuthenticationService authenticationService) {
        return type -> Collections.singleton(authenticationService.getServicesKey());
    }

    @Override
    public Signature signature() {
        try {
            Signature signature = new Signature(SIGNATURE_ALGORITHM){

                @Override
                protected boolean engineVerify(byte[] sigBytes) {
                    return true;
                }

                @Override
                protected void engineUpdate(byte[] b, int off, int len) {
                }

                @Override
                protected void engineUpdate(byte b) {
                }

                @Override
                protected byte[] engineSign() {
                    throw new UnsupportedOperationException();
                }

                @Override
                @Deprecated
                protected void engineSetParameter(String param, Object value) {
                }

                @Override
                protected void engineInitVerify(PublicKey publicKey) {
                }

                @Override
                protected void engineInitSign(PrivateKey privateKey) {
                    throw new UnsupportedOperationException();
                }

                @Override
                @Deprecated
                protected Object engineGetParameter(String param) {
                    return null;
                }
            };
            signature.initVerify(this.publicKey);
            return signature;
        }
        catch (InvalidKeyException var2) {
            throw new AssertionError("Failed to create signature", var2);
        }
    }

    @Override
    public int keyBitCount() {
        return 4096;
    }

    @Override
    public boolean validateProperty(Property property) {
        return true;
    }
}

