/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import by.ely.authlib.ElyEnvironment;
import by.ely.authlib.ElyTextureService;
import by.ely.authlib.MojangEnvironment;
import by.ely.authlib.PreCAFixer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.SignatureState;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileActionType;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.request.JoinMinecraftServerRequest;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.ProfileAction;
import com.mojang.authlib.yggdrasil.response.Response;
import com.mojang.util.UUIDTypeAdapter;
import com.mojang.util.UndashedUuid;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilMinecraftSessionService
extends HttpMinecraftSessionService {
    private final MinecraftClient client;
    private static final Logger LOGGER = LogManager.getLogger();
    private final String baseUrl;
    private final URL joinUrl;
    @Deprecated
    private final LoadingCache<GameProfile, GameProfile> oldInsecureProfiles = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<GameProfile, GameProfile>(){

        public GameProfile load(@Nonnull GameProfile key) {
            return YggdrasilMinecraftSessionService.this.fillGameProfile(key, false);
        }
    });
    private final LoadingCache<UUID, Optional<ProfileResult>> insecureProfiles = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, Optional<ProfileResult>>(){

        public Optional<ProfileResult> load(UUID key) {
            return Optional.ofNullable(YggdrasilMinecraftSessionService.this.fetchProfileUncached(key, false));
        }
    });
    private final ElyTextureService elyTextureService;
    private final ExecutorService concurrentExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getClass().getSimpleName() + "-%d").build());
    static final boolean debug = Boolean.parseBoolean(System.getProperty("ely.authlib.debug", "false"));

    protected YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service) {
        this(service, ElyEnvironment.INSTANCE);
    }

    protected YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service, Environment env) {
        this(service, Proxy.NO_PROXY, env);
    }

    protected YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service, Proxy proxy, Environment env) {
        super(service);
        this.client = MinecraftClient.unauthenticated(proxy);
        this.baseUrl = env.getSessionHost() + "/";
        this.joinUrl = HttpAuthenticationService.constantURL(this.baseUrl + "join");
        this.elyTextureService = new ElyTextureService();
    }

    @Override
    @Deprecated
    public void joinServer(GameProfile profile, String authenticationToken, String serverId) {
        JoinMinecraftServerRequest request = new JoinMinecraftServerRequest();
        request.accessToken = authenticationToken;
        request.selectedProfile = profile.getId();
        request.serverId = serverId;
        try {
            this.getAuthenticationService().makeRequest(this.joinUrl, request, Response.class);
        }
        catch (AuthenticationException e) {
            LOGGER.warn("joinServer failed ({})", new Object[]{profile, e});
        }
    }

    @Override
    public void joinServer(UUID profileId, String authenticationToken, String serverId) throws AuthenticationException {
        JoinMinecraftServerRequest request = new JoinMinecraftServerRequest();
        request.accessToken = authenticationToken;
        request.selectedProfile = profileId;
        request.serverId = serverId;
        try {
            this.client.post(this.joinUrl, request, Response.class);
        }
        catch (MinecraftClientException e) {
            throw e.toAuthenticationException();
        }
    }

    @Override
    @Deprecated
    public GameProfile hasJoinedServer(GameProfile user, String serverId) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(user, serverId, null);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile user, String serverId, InetAddress address) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(user.getName(), serverId, address).profile();
    }

    @Override
    public ProfileResult hasJoinedServer(String profileName, String serverId, @Nullable InetAddress address) throws AuthenticationUnavailableException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("username", profileName);
        arguments.put("serverId", serverId);
        if (address != null) {
            arguments.put("ip", address.getHostAddress());
        }
        String query = HttpAuthenticationService.buildQuery(arguments);
        return new ProfileResult(this.makeConcurrentHasJoinedRequests(profileName, query));
    }

    private GameProfile makeConcurrentHasJoinedRequests(String username, String query) throws AuthenticationUnavailableException {
        Future<GameProfile> elyCheck = this.submitConcurrentHasJoinedRequest(this.baseUrl, username, query);
        Future<GameProfile> mojangCheck = this.submitConcurrentHasJoinedRequest(MojangEnvironment.INSTANCE.getSessionHost() + "/session/minecraft/", username, query);
        GameProfile result = this.getProfileResult(elyCheck);
        if (result != null) {
            YggdrasilMinecraftSessionService.debug("hasJoined: Ely OK: {} -> {}", username, result.getId());
            mojangCheck.cancel(true);
            return result;
        }
        result = this.getProfileResult(mojangCheck);
        if (result != null) {
            YggdrasilMinecraftSessionService.debug("hasJoined: Mojang OK: {} -> {}", username, result.getId());
            return result;
        }
        YggdrasilMinecraftSessionService.debug("hasJoined: Ely & Mojang didn't return anything for {}", username);
        return null;
    }

    private Future<GameProfile> submitConcurrentHasJoinedRequest(String baseUrl, String username, String query) {
        URL checkUrl = HttpAuthenticationService.constantURL(Objects.requireNonNull(baseUrl, "baseUrl") + "hasJoined");
        return this.concurrentExecutor.submit(() -> this.hasJoinedServerSpecificUrl(checkUrl, username, query));
    }

    private GameProfile hasJoinedServerSpecificUrl(URL checkUrl, String username, String query) throws AuthenticationUnavailableException {
        GameProfile result;
        URL url = HttpAuthenticationService.concatenateURL(checkUrl, query);
        try {
            HasJoinedMinecraftServerResponse response = this.getAuthenticationService().makeRequest(url, null, HasJoinedMinecraftServerResponse.class);
            if (response == null || response.getId() == null) {
                return null;
            }
            result = new GameProfile(response.getId(), username);
            if (response.getProperties() != null) {
                result.getProperties().putAll((Multimap)response.getProperties());
            }
        }
        catch (AuthenticationException e) {
            LOGGER.warn("Couldn't make hasJoined request to {}", new Object[]{checkUrl, e});
            if (e instanceof AuthenticationUnavailableException) {
                throw (AuthenticationUnavailableException)e;
            }
            return null;
        }
        return result;
    }

    private GameProfile getProfileResult(Future<GameProfile> check) throws AuthenticationUnavailableException {
        try {
            return check.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AuthenticationUnavailableException) {
                throw (AuthenticationUnavailableException)e.getCause();
            }
            throw new RuntimeException("unexpected exception", e);
        }
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile profile, boolean requireSecure) {
        return this.elyTextureService.getTextures(profile);
    }

    @Override
    public MinecraftProfileTextures getTextures(GameProfile profile) {
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = this.elyTextureService.getTextures(profile);
        return new MinecraftProfileTextures(textures.get((Object)MinecraftProfileTexture.Type.SKIN), textures.get((Object)MinecraftProfileTexture.Type.CAPE), textures.get((Object)MinecraftProfileTexture.Type.ELYTRA), SignatureState.SIGNED);
    }

    @Override
    @Nullable
    public Property getPackedTextures(GameProfile profile) {
        return (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null);
    }

    @Override
    public MinecraftProfileTextures unpackTextures(Property packedTextures) {
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = ElyTextureService.ofPayload(this.elyTextureService.decodePayload(packedTextures));
        return new MinecraftProfileTextures(textures.get((Object)MinecraftProfileTexture.Type.SKIN), textures.get((Object)MinecraftProfileTexture.Type.CAPE), textures.get((Object)MinecraftProfileTexture.Type.ELYTRA), SignatureState.SIGNED);
    }

    @Override
    @Deprecated
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) {
        if (profile.getId() == null) {
            return profile;
        }
        return !requireSecure ? (GameProfile)this.oldInsecureProfiles.getUnchecked((Object)profile) : this.fillGameProfile(profile, true);
    }

    @Override
    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        return property.getValue();
    }

    @Override
    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        if (!requireSecure) {
            return ((Optional)this.insecureProfiles.getUnchecked((Object)profileId)).orElse(null);
        }
        return this.fetchProfileUncached(profileId, true);
    }

    protected GameProfile fillGameProfile(GameProfile profile, boolean requireSecure) {
        try {
            URL url = HttpAuthenticationService.constantURL(this.baseUrl + "profile/" + UUIDTypeAdapter.fromUUID(profile.getId()));
            url = HttpAuthenticationService.concatenateURL(url, "unsigned=" + !requireSecure);
            MinecraftProfilePropertiesResponse response = this.getAuthenticationService().makeRequest(url, null, MinecraftProfilePropertiesResponse.class);
            if (response == null) {
                LOGGER.debug("Couldn't fetch profile properties for " + profile + " as the profile does not exist");
                return profile;
            }
            GameProfile result = new GameProfile(response.getId(), response.getName());
            result.getProperties().putAll((Multimap)response.getProperties());
            profile.getProperties().putAll((Multimap)response.getProperties());
            LOGGER.debug("Successfully fetched profile properties for " + profile);
            return result;
        }
        catch (AuthenticationException var6) {
            LOGGER.warn("Couldn't look up profile properties for " + profile, (Throwable)var6);
            return profile;
        }
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }

    private static boolean isAllowedTextureDomain(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException var3) {
            throw new IllegalArgumentException("Invalid URL '" + url + "'");
        }
        String domain = uri.getHost();
        return true;
    }

    private static void debug(String s, Object ... o) {
        if (debug) {
            LOGGER.info(s, o);
        }
    }

    @Nullable
    private ProfileResult fetchProfileUncached(UUID profileId, boolean requireSecure) {
        try {
            URL url = HttpAuthenticationService.constantURL(this.baseUrl + "profile/" + UndashedUuid.toString(profileId));
            url = HttpAuthenticationService.concatenateURL(url, "unsigned=" + !requireSecure);
            MinecraftProfilePropertiesResponse response = this.client.get(url, MinecraftProfilePropertiesResponse.class);
            if (response == null) {
                LOGGER.debug("Couldn't fetch profile properties for {} as the profile does not exist", new Object[]{profileId});
                return null;
            }
            GameProfile profile = response.toProfile();
            Set<ProfileActionType> profileActions = response.profileActions().stream().map(ProfileAction::type).collect(Collectors.toSet());
            LOGGER.debug("Successfully fetched profile properties for {}", new Object[]{profile});
            return new ProfileResult(profile, profileActions);
        }
        catch (MinecraftClientException | IllegalArgumentException e) {
            LOGGER.warn("Couldn't look up profile properties for {}", new Object[]{profileId, e});
            return null;
        }
    }

    static {
        try {
            PreCAFixer.init(LOGGER);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info("CAFixer is not available: {}", new Object[]{e.toString()});
        }
        catch (Throwable t) {
            LOGGER.warn("Error calling CAFixer", t);
        }
    }
}

