/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import by.ely.authlib.ElyEnvironment;
import com.google.common.collect.Iterables;
import com.mojang.authlib.Agent;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.response.ProfileSearchResultsResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilGameProfileRepository
implements GameProfileRepository {
    private static final int ENTRIES_PER_PAGE = 100;
    private static final int DELAY_BETWEEN_PAGES = 100;
    private static final int DELAY_BETWEEN_FAILURES = 750;
    private static final Logger LOGGER = LogManager.getLogger();
    private final YggdrasilAuthenticationService authenticationService;
    private final String searchPageUrl;
    static final boolean debug = Boolean.parseBoolean(System.getProperty("ely.authlib.debug", "false"));

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService authenticationService) {
        this(authenticationService, ElyEnvironment.INSTANCE);
    }

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService authenticationService, Environment environment) {
        this.authenticationService = authenticationService;
        this.searchPageUrl = environment.getAccountsHost() + "/profiles";
    }

    @Override
    public void findProfilesByNames(String[] names, Agent agent, ProfileLookupCallback callback) {
        if (debug) {
            YggdrasilGameProfileRepository.debug("Looking up profiles: {}", names);
        }
        block2: for (List namesPage : Iterables.partition(YggdrasilGameProfileRepository.toLowercaseArray(names), (int)100)) {
            int attempt = 1;
            while (true) {
                block7: {
                    ProfileSearchResultsResponse response;
                    if (debug) {
                        YggdrasilGameProfileRepository.debug("Requesing: {}, names: {}, attempt: {}", this.searchPageUrl, namesPage, attempt);
                    }
                    try {
                        response = this.authenticationService.makeRequest(HttpAuthenticationService.constantURL(this.searchPageUrl), namesPage, ProfileSearchResultsResponse.class);
                    }
                    catch (AuthenticationException e) {
                        if (attempt == 3) {
                            this.lookupFailCallback(namesPage, callback, e);
                            continue block2;
                        }
                        YggdrasilGameProfileRepository.sleep(750L);
                        break block7;
                    }
                    this.lookupSuccessCallback(namesPage, response, callback);
                    YggdrasilGameProfileRepository.sleep(100L);
                    continue block2;
                }
                ++attempt;
            }
        }
    }

    private void lookupSuccessCallback(List<String> namesPage, ProfileSearchResultsResponse response, ProfileLookupCallback callback) {
        if (debug) {
            YggdrasilGameProfileRepository.debug("Profiles looked up: {}", Arrays.asList(response.getProfiles()));
        }
        HashSet<String> unknownNames = new HashSet<String>(namesPage);
        for (GameProfile profile : response.getProfiles()) {
            callback.onProfileLookupSucceeded(profile);
            unknownNames.remove(YggdrasilGameProfileRepository.toLowercase(profile.getName()));
        }
        if (!unknownNames.isEmpty()) {
            YggdrasilGameProfileRepository.debug("Couldn't find profiles for names: {}", unknownNames);
            for (String name : unknownNames) {
                callback.onProfileLookupFailed(YggdrasilGameProfileRepository.ofUnknown(name), new ProfileNotFoundException(name));
            }
        }
    }

    private void lookupFailCallback(List<String> namesPage, ProfileLookupCallback callback, Exception e) {
        if (debug) {
            YggdrasilGameProfileRepository.error("Couldn't look up profiles due to error: {}", namesPage, e);
        }
        for (String name : namesPage) {
            callback.onProfileLookupFailed(YggdrasilGameProfileRepository.ofUnknown(name), e);
        }
    }

    private static void debug(String s, Object ... o) {
        if (debug) {
            LOGGER.info(s, o);
        }
    }

    private static void error(String s, Object ... o) {
        LOGGER.error(s, o);
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interrupt) {
            YggdrasilGameProfileRepository.error("Interrupted", new Object[0]);
            throw new RuntimeException(interrupt);
        }
    }

    private static List<String> toLowercaseArray(String[] names) {
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (String name : names) {
            list.add(YggdrasilGameProfileRepository.toLowercase(name));
        }
        return list;
    }

    private static String toLowercase(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    private static GameProfile ofUnknown(String name) {
        return new GameProfile(null, name);
    }
}

