/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class TextureUrlChecker {
    private static final Set ALLOWED_SCHEMES = new LinkedHashSet<String>(Arrays.asList("http", "https"));
    private static final List ALLOWED_DOMAINS = Arrays.asList(".minecraft.net", ".mojang.com", ".ely.by");
    private static final List BLOCKED_DOMAINS = Arrays.asList("bugs.mojang.com", "education.minecraft.net", "feedback.minecraft.net");

    public static boolean isAllowedTextureDomain(String url) {
        URI uri;
        try {
            uri = new URI(url).normalize();
        }
        catch (URISyntaxException var6) {
            throw new IllegalArgumentException("Invalid URL '" + url + "'");
        }
        String scheme = uri.getScheme();
        if (scheme != null && ALLOWED_SCHEMES.contains(scheme)) {
            String domain = uri.getHost();
            if (domain == null) {
                return false;
            }
            String decodedDomain = IDN.toUnicode(domain);
            String lowerCaseDomain = decodedDomain.toLowerCase(Locale.ROOT);
            if (!lowerCaseDomain.equals(decodedDomain)) {
                return false;
            }
            return TextureUrlChecker.isDomainOnList(decodedDomain, ALLOWED_DOMAINS) && !TextureUrlChecker.isDomainOnList(decodedDomain, BLOCKED_DOMAINS);
        }
        return false;
    }

    private static boolean isDomainOnList(String domain, List list) {
        String entry;
        Iterator var2 = list.iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!domain.endsWith(entry = (String)var2.next()));
        return true;
    }
}

