/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.properties;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Type;
import java.util.Map;

public class PropertyMap
extends ForwardingMultimap<String, Property> {
    private final Multimap<String, Property> properties = LinkedHashMultimap.create();

    protected Multimap<String, Property> delegate() {
        return this.properties;
    }

    public static class Serializer
    implements JsonSerializer<PropertyMap>,
    JsonDeserializer<PropertyMap> {
        /*
         * Unable to fully structure code
         */
        public PropertyMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            result = new PropertyMap();
            if (json instanceof JsonObject) {
                i$ = (JsonObject)json;
                element = i$.entrySet().iterator();
                block0: while (true) {
                    if (!element.hasNext()) {
                        return result;
                    }
                    object = (Map.Entry)element.next();
                    if (!(object.getValue() instanceof JsonArray)) continue;
                    name = ((JsonArray)object.getValue()).iterator();
                    while (true) {
                        if (name.hasNext()) ** break;
                        continue block0;
                        value = (JsonElement)name.next();
                        result.put((String)object.getKey(), new Property((String)object.getKey(), value.getAsString()));
                    }
                    break;
                }
            }
            if (json instanceof JsonArray) {
                for (JsonElement element1 : (JsonArray)json) {
                    if (!(element1 instanceof JsonObject)) continue;
                    object1 = (JsonObject)element1;
                    name1 = object1.getAsJsonPrimitive("name").getAsString();
                    value1 = object1.getAsJsonPrimitive("value").getAsString();
                    if (object1.has("signature")) {
                        result.put(name1, new Property(name1, value1, object1.getAsJsonPrimitive("signature").getAsString()));
                        continue;
                    }
                    result.put(name1, new Property(name1, value1));
                }
            }
            return result;
        }

        public JsonElement serialize(PropertyMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            for (Property property : src.values()) {
                JsonObject object = new JsonObject();
                object.addProperty("name", property.getName());
                object.addProperty("value", property.getValue());
                if (property.hasSignature()) {
                    object.addProperty("signature", property.getSignature());
                }
                result.add((JsonElement)object);
            }
            return result;
        }
    }
}

