/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.properties;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Property {
    private final String name;
    private final String value;
    private final String signature;
    private static final Logger LOGGER = LogManager.getLogger();

    public Property(String value, String name) {
        this(value, name, null);
    }

    public Property(String name, String value, String signature) {
        this.name = name;
        this.value = value;
        this.signature = signature;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getSignature() {
        return this.signature == null ? "" : this.signature;
    }

    public String name() {
        return this.getName();
    }

    public String value() {
        return this.getValue();
    }

    public String signature() {
        return this.getSignature();
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    @Deprecated
    public boolean isSignatureValid(PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(publicKey);
            signature.update(this.value.getBytes(StandardCharsets.US_ASCII));
            return signature.verify(Base64.getDecoder().decode(this.signature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException var3) {
            LOGGER.warn("Property signature validation failed", (Throwable)var3);
            return false;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

