/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.minecraft;

import com.mojang.authlib.minecraft.SocialInteractionsService;
import com.mojang.authlib.minecraft.TelemetrySession;
import com.mojang.authlib.minecraft.report.AbuseReportLimits;
import com.mojang.authlib.yggdrasil.request.AbuseReportRequest;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public interface UserApiService
extends SocialInteractionsService {
    public static final UserProperties OFFLINE_PROPERTIES = new UserProperties(Collections.unmodifiableSet(new LinkedHashSet<UserFlag>(Arrays.asList(UserFlag.CHAT_ALLOWED, UserFlag.REALMS_ALLOWED, UserFlag.SERVERS_ALLOWED))));
    public static final UserApiService OFFLINE = new UserApiService(){

        @Override
        @Deprecated
        public boolean serversAllowed() {
            return true;
        }

        @Override
        @Deprecated
        public boolean realmsAllowed() {
            return true;
        }

        @Override
        @Deprecated
        public boolean chatAllowed() {
            return true;
        }

        @Override
        @Deprecated
        public boolean telemetryAllowed() {
            return false;
        }

        @Override
        public UserProperties properties() {
            return OFFLINE_PROPERTIES;
        }

        @Override
        public boolean isBlockedPlayer(UUID playerID) {
            return false;
        }

        @Override
        public void refreshBlockList() {
        }

        @Override
        public TelemetrySession newTelemetrySession(Executor executor) {
            return TelemetrySession.DISABLED;
        }

        @Override
        @Nullable
        public KeyPairResponse getKeyPair() {
            return null;
        }

        @Override
        public void reportAbuse(AbuseReportRequest request) {
        }

        @Override
        public boolean canSendReports() {
            return false;
        }

        @Override
        public AbuseReportLimits getAbuseReportLimits() {
            return AbuseReportLimits.DEFAULTS;
        }
    };

    @Override
    @Deprecated
    public boolean serversAllowed();

    @Override
    @Deprecated
    public boolean realmsAllowed();

    @Override
    @Deprecated
    public boolean chatAllowed();

    @Override
    @Deprecated
    public boolean telemetryAllowed();

    public UserProperties properties();

    @Override
    public boolean isBlockedPlayer(UUID var1);

    public void refreshBlockList();

    public TelemetrySession newTelemetrySession(Executor var1);

    @Nullable
    public KeyPairResponse getKeyPair();

    public void reportAbuse(AbuseReportRequest var1);

    public boolean canSendReports();

    public AbuseReportLimits getAbuseReportLimits();

    public static enum UserFlag {
        SERVERS_ALLOWED,
        REALMS_ALLOWED,
        CHAT_ALLOWED,
        TELEMETRY_ENABLED,
        PROFANITY_FILTER_ENABLED,
        OPTIONAL_TELEMETRY_AVAILABLE;

    }

    public static class UserProperties {
        private final Set<UserFlag> flags;
        private final Map<?, ?> bannedScopes;

        public UserProperties(Set<UserFlag> flags, Map<?, ?> bannedScopes) {
            this.flags = flags;
            this.bannedScopes = bannedScopes;
        }

        public UserProperties(Set<UserFlag> flags) {
            this(flags, Collections.emptyMap());
        }

        public boolean flag(UserFlag flag) {
            return this.flags.contains((Object)flag);
        }

        public Set<UserFlag> flags() {
            return this.flags;
        }

        public Map<?, ?> bannedScopes() {
            return this.bannedScopes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserProperties that = (UserProperties)o;
            return Objects.equals(this.flags, that.flags) && Objects.equals(this.bannedScopes, that.bannedScopes);
        }

        public int hashCode() {
            return Objects.hash(this.flags, this.bannedScopes);
        }

        public String toString() {
            return "UserProperties{flags=" + this.flags + ", bannedScopes=" + this.bannedScopes + '}';
        }
    }
}

