/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.minecraft;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public interface MinecraftSessionService {
    public void joinServer(GameProfile var1, String var2, String var3) throws AuthenticationException;

    public void joinServer(UUID var1, String var2, String var3) throws AuthenticationException;

    public GameProfile hasJoinedServer(GameProfile var1, String var2) throws AuthenticationUnavailableException;

    public GameProfile hasJoinedServer(GameProfile var1, String var2, InetAddress var3) throws AuthenticationUnavailableException;

    public ProfileResult hasJoinedServer(String var1, String var2, @Nullable InetAddress var3) throws AuthenticationUnavailableException;

    @Deprecated
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile var1, boolean var2) throws InsecurePublicKeyException;

    @Nullable
    public Property getPackedTextures(GameProfile var1);

    public MinecraftProfileTextures unpackTextures(Property var1);

    default public MinecraftProfileTextures getTextures(GameProfile profile) {
        Property packed = this.getPackedTextures(profile);
        return packed != null ? this.unpackTextures(packed) : MinecraftProfileTextures.EMPTY;
    }

    @Deprecated
    public GameProfile fillProfileProperties(GameProfile var1, boolean var2);

    public String getSecurePropertyValue(Property var1) throws InsecurePublicKeyException;

    @Nullable
    public ProfileResult fetchProfile(UUID var1, boolean var2);
}

