/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.minecraft;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MinecraftProfileTexture {
    public static final int PROFILE_TEXTURE_COUNT = Type.values().length;
    private final String url;
    private final String hash;
    private final Map<String, String> metadata;

    public MinecraftProfileTexture(String url, String hash, Map<String, String> metadata) {
        this.url = url;
        this.hash = hash;
        this.metadata = metadata;
    }

    public MinecraftProfileTexture(String url, Map<String, String> metadata) {
        this(url, null, metadata);
    }

    public MinecraftProfileTexture(String url) {
        this(url, new HashMap<String, String>());
    }

    public MinecraftProfileTexture(String url, String hash) {
        this(url, hash, new HashMap<String, String>());
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getMetadata(String key) {
        return this.metadata == null ? null : this.metadata.get(key);
    }

    public String getHash() {
        return this.hash == null ? MinecraftProfileTexture.getHash(this.url) : this.hash;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("url", (Object)this.url).append("hash", (Object)this.getHash()).toString();
    }

    private static String getHash(String url) {
        return FilenameUtils.getBaseName((String)url);
    }

    public static enum Type {
        SKIN,
        CAPE,
        ELYTRA;

    }
}

