/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.legacy;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.legacy.LegacyAuthenticationService;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class LegacyMinecraftSessionService
extends HttpMinecraftSessionService {
    private static final String BASE_URL = "http://session.minecraft.net/game/";
    private static final URL JOIN_URL = HttpAuthenticationService.constantURL("http://session.minecraft.net/game/joinserver.jsp");
    private static final URL CHECK_URL = HttpAuthenticationService.constantURL("http://session.minecraft.net/game/checkserver.jsp");

    protected LegacyMinecraftSessionService(LegacyAuthenticationService authenticationService) {
        super(authenticationService);
    }

    @Override
    public void joinServer(GameProfile profile, String authenticationToken, String serverId) throws AuthenticationException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("user", profile.getName());
        arguments.put("sessionId", authenticationToken);
        arguments.put("serverId", serverId);
        URL url = HttpAuthenticationService.concatenateURL(JOIN_URL, HttpAuthenticationService.buildQuery(arguments));
        try {
            String e = this.getAuthenticationService().performGetRequest(url);
            if (!"OK".equals(e)) {
                throw new AuthenticationException(e);
            }
        }
        catch (IOException var7) {
            throw new AuthenticationUnavailableException(var7);
        }
    }

    @Override
    public void joinServer(UUID profileId, String authenticationToken, String serverId) throws AuthenticationException {
        throw new AuthenticationException("Called new method on legacy session service");
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile user, String serverId) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(user, serverId, null);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile user, String serverId, InetAddress address) throws AuthenticationUnavailableException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("user", user.getName());
        arguments.put("serverId", serverId);
        URL url = HttpAuthenticationService.concatenateURL(CHECK_URL, HttpAuthenticationService.buildQuery(arguments));
        try {
            String e = this.getAuthenticationService().performGetRequest(url);
            return "YES".equals(e) ? user : null;
        }
        catch (IOException var7) {
            throw new AuthenticationUnavailableException(var7);
        }
    }

    @Override
    public ProfileResult hasJoinedServer(String profileName, String serverId, @Nullable InetAddress address) throws AuthenticationUnavailableException {
        throw new AuthenticationUnavailableException("Called new method on legacy session service");
    }

    public Map getTextures(GameProfile profile, boolean requireSecure) {
        return new HashMap();
    }

    @Override
    @Nullable
    public Property getPackedTextures(GameProfile profile) {
        throw new RuntimeException("Called new method on legacy session service");
    }

    @Override
    public MinecraftProfileTextures unpackTextures(Property packedTextures) {
        throw new RuntimeException("Called new method on legacy session service");
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) {
        return profile;
    }

    @Override
    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        return property.getValue();
    }

    @Override
    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        throw new RuntimeException("Called new method on legacy session service");
    }

    @Override
    public LegacyAuthenticationService getAuthenticationService() {
        return (LegacyAuthenticationService)super.getAuthenticationService();
    }
}

