/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib;

import com.mojang.authlib.BaseAuthenticationService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HttpAuthenticationService
extends BaseAuthenticationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Proxy proxy;

    protected HttpAuthenticationService(Proxy proxy) {
        Validate.notNull((Object)proxy);
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    protected HttpURLConnection createUrlConnection(URL url) throws IOException {
        Validate.notNull((Object)url);
        LOGGER.debug("Opening connection to " + url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performPostRequest(URL url, String post, String contentType) throws IOException {
        String var10;
        Validate.notNull((Object)url);
        Validate.notNull((Object)post);
        Validate.notNull((Object)contentType);
        HttpURLConnection connection = this.createUrlConnection(url);
        byte[] postAsBytes = post.getBytes(Charsets.UTF_8);
        connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
        connection.setDoOutput(true);
        LOGGER.debug("Writing POST data to " + url + ": " + post);
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            IOUtils.write((byte[])postAsBytes, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        LOGGER.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getInputStream();
            String e = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + connection.getResponseCode());
            LOGGER.debug("Response: " + e);
            String string = result = e;
            return string;
        }
        catch (IOException var19) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                LOGGER.debug("Request failed", (Throwable)var19);
                throw var19;
            }
            LOGGER.debug("Reading error page from " + url);
            String result = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + connection.getResponseCode());
            LOGGER.debug("Response: " + result);
            var10 = result;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return var10;
    }

    public String performGetRequest(URL url) throws IOException {
        return this.performGetRequest(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performGetRequest(URL url, @Nullable String authentication) throws IOException {
        String var7;
        Validate.notNull((Object)url);
        HttpURLConnection connection = this.createUrlConnection(url);
        if (authentication != null) {
            connection.setRequestProperty("Authorization", authentication);
        }
        LOGGER.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getInputStream();
            String e = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + connection.getResponseCode());
            LOGGER.debug("Response: " + e);
            String string = result = e;
            return string;
        }
        catch (IOException var11) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                LOGGER.debug("Request failed", (Throwable)var11);
                throw var11;
            }
            LOGGER.debug("Reading error page from " + url);
            String result = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + connection.getResponseCode());
            LOGGER.debug("Response: " + result);
            var7 = result;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return var7;
    }

    public static URL constantURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException var2) {
            throw new Error("Couldn't create constant for " + url, var2);
        }
    }

    public static String buildQuery(Map query) {
        if (query == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : query.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            try {
                builder.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var6) {
                LOGGER.error("Unexpected exception building query", (Throwable)var6);
            }
            if (entry.getValue() == null) continue;
            builder.append('=');
            try {
                builder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var5) {
                LOGGER.error("Unexpected exception building query", (Throwable)var5);
            }
        }
        return builder.toString();
    }

    public static URL concatenateURL(URL url, String query) {
        try {
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                String var10002 = url.getProtocol();
                String var10003 = url.getHost();
                int var10004 = url.getPort();
                String var10005 = url.getFile();
                return new URL(var10002, var10003, var10004, var10005 + "&" + query);
            }
            String var10002 = url.getProtocol();
            String var10003 = url.getHost();
            int var10004 = url.getPort();
            String var10005 = url.getFile();
            return new URL(var10002, var10003, var10004, var10005 + "?" + query);
        }
        catch (MalformedURLException var3) {
            throw new IllegalArgumentException("Could not concatenate given URL with GET arguments!", var3);
        }
    }
}

