/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib;

import com.google.common.collect.Multimap;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseUserAuthentication
implements UserAuthentication {
    protected static final String STORAGE_KEY_PROFILE_NAME = "displayName";
    protected static final String STORAGE_KEY_PROFILE_ID = "uuid";
    protected static final String STORAGE_KEY_PROFILE_PROPERTIES = "profileProperties";
    protected static final String STORAGE_KEY_USER_NAME = "username";
    protected static final String STORAGE_KEY_USER_ID = "userid";
    protected static final String STORAGE_KEY_USER_PROPERTIES = "userProperties";
    private static final Logger LOGGER = LogManager.getLogger();
    private final AuthenticationService authenticationService;
    private final PropertyMap userProperties = new PropertyMap();
    private String userid;
    private String username;
    private String password;
    private GameProfile selectedProfile;
    private UserType userType;

    protected BaseUserAuthentication(AuthenticationService authenticationService) {
        Validate.notNull((Object)authenticationService);
        this.authenticationService = authenticationService;
    }

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank((CharSequence)this.getUsername()) && StringUtils.isNotBlank((CharSequence)this.getPassword());
    }

    @Override
    public void logOut() {
        this.password = null;
        this.userid = null;
        this.setSelectedProfile(null);
        this.getModifiableUserProperties().clear();
        this.setUserType(null);
    }

    @Override
    public boolean isLoggedIn() {
        return this.getSelectedProfile() != null;
    }

    protected String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        if (this.isLoggedIn() && this.canPlayOnline()) {
            throw new IllegalStateException("Cannot change username whilst logged in & online");
        }
        this.username = username;
    }

    protected String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        if (this.isLoggedIn() && this.canPlayOnline() && StringUtils.isNotBlank((CharSequence)password)) {
            throw new IllegalStateException("Cannot set password whilst logged in & online");
        }
        this.password = password;
    }

    @Override
    public void loadFromStorage(Map credentials) {
        String value;
        String name;
        this.logOut();
        this.setUsername(String.valueOf(credentials.get(STORAGE_KEY_USER_NAME)));
        this.userid = credentials.containsKey(STORAGE_KEY_USER_ID) ? String.valueOf(credentials.get(STORAGE_KEY_USER_ID)) : this.username;
        if (credentials.containsKey(STORAGE_KEY_USER_PROPERTIES)) {
            try {
                List profile = (List)credentials.get(STORAGE_KEY_USER_PROPERTIES);
                for (Map i$ : profile) {
                    String propertyMap = (String)i$.get("name");
                    name = (String)i$.get("value");
                    value = (String)i$.get("signature");
                    if (value == null) {
                        this.getModifiableUserProperties().put(propertyMap, new Property(propertyMap, name));
                        continue;
                    }
                    this.getModifiableUserProperties().put(propertyMap, new Property(propertyMap, name, value));
                }
            }
            catch (Throwable var10) {
                LOGGER.warn("Couldn't deserialize user properties", var10);
            }
        }
        if (credentials.containsKey(STORAGE_KEY_PROFILE_NAME) && credentials.containsKey(STORAGE_KEY_PROFILE_ID)) {
            GameProfile profile1 = new GameProfile(UUIDTypeAdapter.fromString(String.valueOf(credentials.get(STORAGE_KEY_PROFILE_ID))), String.valueOf(credentials.get(STORAGE_KEY_PROFILE_NAME)));
            if (credentials.containsKey(STORAGE_KEY_PROFILE_PROPERTIES)) {
                try {
                    List t1 = (List)credentials.get(STORAGE_KEY_PROFILE_PROPERTIES);
                    for (Map propertyMap1 : t1) {
                        name = (String)propertyMap1.get("name");
                        value = (String)propertyMap1.get("value");
                        String signature = (String)propertyMap1.get("signature");
                        if (signature == null) {
                            profile1.getProperties().put(name, new Property(name, value));
                            continue;
                        }
                        profile1.getProperties().put(name, new Property(name, value, signature));
                    }
                }
                catch (Throwable var9) {
                    LOGGER.warn("Couldn't deserialize profile properties", var9);
                }
            }
            this.setSelectedProfile(profile1);
        }
    }

    @Override
    public Map saveForStorage() {
        GameProfile selectedProfile1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getUsername() != null) {
            result.put(STORAGE_KEY_USER_NAME, this.getUsername());
        }
        if (this.getUserID() != null) {
            result.put(STORAGE_KEY_USER_ID, this.getUserID());
        } else if (this.getUsername() != null) {
            result.put(STORAGE_KEY_USER_NAME, this.getUsername());
        }
        if (!this.getUserProperties().isEmpty()) {
            ArrayList selectedProfile = new ArrayList();
            for (Property i$ : this.getUserProperties().values()) {
                HashMap<String, String> profileProperty = new HashMap<String, String>();
                profileProperty.put("name", i$.getName());
                profileProperty.put("value", i$.getValue());
                profileProperty.put("signature", i$.getSignature());
                selectedProfile.add(profileProperty);
            }
            result.put(STORAGE_KEY_USER_PROPERTIES, selectedProfile);
        }
        if ((selectedProfile1 = this.getSelectedProfile()) != null) {
            result.put(STORAGE_KEY_PROFILE_NAME, selectedProfile1.getName());
            result.put(STORAGE_KEY_PROFILE_ID, selectedProfile1.getId());
            ArrayList properties1 = new ArrayList();
            for (Property profileProperty1 : selectedProfile1.getProperties().values()) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put("name", profileProperty1.getName());
                property.put("value", profileProperty1.getValue());
                property.put("signature", profileProperty1.getSignature());
                properties1.add(property);
            }
            if (!properties1.isEmpty()) {
                result.put(STORAGE_KEY_PROFILE_PROPERTIES, properties1);
            }
        }
        return result;
    }

    @Override
    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    protected void setSelectedProfile(GameProfile selectedProfile) {
        this.selectedProfile = selectedProfile;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append("{");
        if (this.isLoggedIn()) {
            result.append("Logged in as ");
            result.append(this.getUsername());
            if (this.getSelectedProfile() != null) {
                result.append(" / ");
                result.append(this.getSelectedProfile());
                result.append(" - ");
                if (this.canPlayOnline()) {
                    result.append("Online");
                } else {
                    result.append("Offline");
                }
            }
        } else {
            result.append("Not logged in");
        }
        result.append("}");
        return result.toString();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    @Override
    public String getUserID() {
        return this.userid;
    }

    @Override
    public PropertyMap getUserProperties() {
        if (this.isLoggedIn()) {
            PropertyMap result = new PropertyMap();
            result.putAll((Multimap)this.getModifiableUserProperties());
            return result;
        }
        return new PropertyMap();
    }

    protected PropertyMap getModifiableUserProperties() {
        return this.userProperties;
    }

    @Override
    public UserType getUserType() {
        return this.isLoggedIn() ? (this.userType == null ? UserType.LEGACY : this.userType) : null;
    }

    protected void setUserType(UserType userType) {
        this.userType = userType;
    }

    protected void setUserid(String userid) {
        this.userid = userid;
    }
}

