/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<class_1799> create(StackHelper stackHelper) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        boolean showHidden = clientConfig.isShowHiddenItemsEnabled();
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        HashSet<Object> itemUidSet = new HashSet<Object>();
        class_310 minecraft = class_310.method_1551();
        class_7699 features = Optional.ofNullable(minecraft.field_1724).map(p -> p.field_3944).map(class_634::method_45735).orElse(class_7699.method_45397());
        boolean hasOperatorItemsTabPermissions = showHidden || (Boolean)minecraft.field_1690.method_47395().method_41753() != false || Optional.of(minecraft).map(m -> m.field_1724).map(class_1657::method_7338).orElse(false) != false;
        class_638 level = minecraft.field_1687;
        if (level == null) {
            throw new NullPointerException("minecraft.level must be set before JEI fetches ingredients");
        }
        class_5455 registryAccess = level.method_30349();
        class_1761.class_8128 displayParameters = new class_1761.class_8128(features, hasOperatorItemsTabPermissions, (class_7225.class_7874)registryAccess);
        for (class_1761 tab : class_7706.method_47341()) {
            Collection searchTabDisplayItems;
            Collection displayItems;
            if (tab.method_47312() != class_1761.class_7916.field_41052) {
                LOGGER.debug("Skipping creative tab: '{}' because it is type: {}", (Object)tab.method_7737().getString(), (Object)tab.method_47312());
                continue;
            }
            try {
                tab.method_47306(displayParameters);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while building contents.Items from this group will be missing from the JEI ingredient list: {}", (Object)tab.method_7737().getString(), (Object)e);
                continue;
            }
            try {
                displayItems = tab.method_47313();
                searchTabDisplayItems = tab.method_45414();
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting search tab display items.Some items from this group will be missing from the JEI ingredient list: {}", (Object)tab.method_7737().getString(), (Object)e);
                continue;
            }
            if (displayItems.isEmpty() && searchTabDisplayItems.isEmpty()) {
                LOGGER.warn("Item Group has no display items and no search tab display items. Items from this group will be missing from the JEI ingredient list. {}", (Object)tab.method_7737().getString());
                continue;
            }
            ItemStackListFactory.addFromTab(displayItems, "displayItems", tab, stackHelper, itemList, itemUidSet);
            if (displayItems.equals(searchTabDisplayItems)) continue;
            ItemStackListFactory.addFromTab(searchTabDisplayItems, "searchTabDisplayItems", tab, stackHelper, itemList, itemUidSet);
        }
        if (showHidden) {
            ItemStackListFactory.addItemsFromRegistries(stackHelper, itemList, itemUidSet, features);
        }
        return itemList;
    }

    private static void addFromTab(Collection<class_1799> tabDisplayItems, String displayType, class_1761 tab, StackHelper stackHelper, List<class_1799> itemList, Set<Object> itemUidSet) {
        HashSet<Object> tabUidSet = new HashSet<Object>();
        int added = 0;
        HashSet<Object> duplicateInTab = new HashSet<Object>();
        int duplicateInTabCount = 0;
        for (class_1799 itemStack : tabDisplayItems) {
            if (itemStack.method_7960()) {
                LOGGER.error("Found an empty itemStack in '{}' creative tab's {}", (Object)tab, (Object)displayType);
                continue;
            }
            Object itemKey = ItemStackListFactory.safeGetUid(stackHelper, itemStack);
            if (itemKey == null) continue;
            if (tabUidSet.contains(itemKey)) {
                duplicateInTab.add(itemKey);
                ++duplicateInTabCount;
            }
            if (!itemUidSet.add(itemKey)) continue;
            tabUidSet.add(itemKey);
            itemList.add(itemStack);
            ++added;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added {}/{} new items from '{}' creative tab's {}", (Object)StringUtils.leftPad((String)Integer.toString(added), (int)4, (char)' '), (Object)StringUtils.leftPad((String)Integer.toString(tabDisplayItems.size()), (int)4, (char)' '), (Object)tab.method_7737().getString(), (Object)displayType);
        }
        if (duplicateInTabCount > 0) {
            LOGGER.warn("{} duplicate items were found in '{}' creative tab's: {}\nThis may indicate that these types of item need a subtype interpreter added to JEI:\n{}", (Object)duplicateInTabCount, (Object)tab.method_7737().getString(), (Object)displayType, (Object)duplicateInTab.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]")));
        }
    }

    private static void addItemsFromRegistries(StackHelper stackHelper, List<class_1799> itemList, Set<Object> itemUidSet, class_7699 features) {
        Object itemKey;
        List<class_1799> itemStacks = RegistryUtil.getRegistry(class_7924.field_41197).method_46771().method_45919(features).method_42017().map(class_1799::new).filter(i -> !i.method_7960()).toList();
        int added = 0;
        for (class_1799 itemStack : itemStacks) {
            itemKey = ItemStackListFactory.safeGetUid(stackHelper, itemStack);
            if (itemKey == null || !itemUidSet.add(itemKey)) continue;
            itemList.add(itemStack);
            ++added;
        }
        LOGGER.debug("Added {}/{} new items from the item registry (this is run because ShowHiddenItems is set to true in JEI's config)", (Object)added, (Object)itemStacks.size());
        itemStacks = RegistryUtil.getRegistry(class_7924.field_41254).method_46771().method_45919(features).method_42017().map(class_6880.class_6883::comp_349).map(class_1799::new).filter(i -> !i.method_7960()).toList();
        added = 0;
        for (class_1799 itemStack : itemStacks) {
            itemKey = ItemStackListFactory.safeGetUid(stackHelper, itemStack);
            if (itemKey == null || !itemUidSet.add(itemKey)) continue;
            itemList.add(itemStack);
            ++added;
        }
        LOGGER.debug("Added {}/{} new items from the block registry (this is run because ShowHiddenItems is set to true in JEI's config)", (Object)added, (Object)itemStacks.size());
    }

    @Nullable
    private static Object safeGetUid(StackHelper stackHelper, class_1799 stack) {
        try {
            return stackHelper.getUidForStack(stack, UidContext.Ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return null;
        }
    }
}

