/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import com.mojang.serialization.Codec;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.IExtendableCraftingRecipeCategory;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableSize2i;
import mezz.jei.library.recipes.CraftingExtensionHelper;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3955;
import net.minecraft.class_8786;

public class CraftingRecipeCategory
implements IExtendableCraftingRecipeCategory,
IRecipeCategory<class_8786<class_3955>> {
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;
    private final class_2561 localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    private final CraftingExtensionHelper extendableHelper = new CraftingExtensionHelper();

    public CraftingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(116, 54);
        this.icon = guiHelper.createDrawableItemLike((class_1935)class_2246.field_9980);
        this.guiHelper = guiHelper;
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.craftingTable");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    @Override
    public RecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_3955> recipeHolder, IFocusGroup focuses) {
        ICraftingCategoryExtension<class_3955> recipeExtension = this.extendableHelper.getRecipeExtension(recipeHolder);
        recipeExtension.setRecipe(recipeHolder, builder, this.craftingGridHelper, focuses);
    }

    @Override
    public void onDisplayedIngredientsUpdate(class_8786<class_3955> recipeHolder, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
        ICraftingCategoryExtension<class_3955> recipeExtension = this.extendableHelper.getRecipeExtension(recipeHolder);
        recipeExtension.onDisplayedIngredientsUpdate(recipeHolder, recipeSlots, focuses);
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, class_8786<class_3955> recipeHolder, IFocusGroup focuses) {
        ICraftingCategoryExtension<class_3955> recipeExtension = this.extendableHelper.getRecipeExtension(recipeHolder);
        recipeExtension.createRecipeExtras(recipeHolder, acceptor, this.craftingGridHelper, focuses);
    }

    @Override
    public void draw(class_8786<class_3955> recipeHolder, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        ICraftingCategoryExtension<class_3955> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        int recipeWidth = this.getWidth();
        int recipeHeight = this.getHeight();
        extension.drawInfo(recipeHolder, recipeWidth, recipeHeight, guiGraphics, mouseX, mouseY);
        IDrawableStatic recipeArrow = this.guiHelper.getRecipeArrow();
        recipeArrow.draw(guiGraphics, 61, (54 - recipeArrow.getHeight()) / 2);
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, class_8786<class_3955> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ICraftingCategoryExtension<class_3955> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        extension.getTooltip(tooltip, recipeHolder, mouseX, mouseY);
    }

    @Override
    public List<class_2561> getTooltipStrings(class_8786<class_3955> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ICraftingCategoryExtension<class_3955> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        return extension.getTooltipStrings(recipeHolder, mouseX, mouseY);
    }

    @Override
    public boolean handleInput(class_8786<class_3955> recipeHolder, double mouseX, double mouseY, class_3675.class_306 input) {
        ICraftingCategoryExtension<class_3955> extension = this.extendableHelper.getRecipeExtension(recipeHolder);
        return extension.handleInput(recipeHolder, mouseX, mouseY, input);
    }

    @Override
    public boolean isHandled(class_8786<class_3955> recipeHolder) {
        return this.extendableHelper.getOptionalRecipeExtension(recipeHolder).isPresent();
    }

    @Override
    public <R extends class_3955> void addExtension(Class<? extends R> recipeClass, ICraftingCategoryExtension<R> extension) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extension, "extension");
        this.extendableHelper.addRecipeExtension(recipeClass, extension);
    }

    @Override
    public class_2960 getRegistryName(class_8786<class_3955> recipeHolder) {
        ErrorUtil.checkNotNull(recipeHolder, "recipeHolder");
        return this.extendableHelper.getOptionalRecipeExtension(recipeHolder).flatMap(extension -> extension.getRegistryName(recipeHolder)).orElseGet(() -> recipeHolder.comp_1932());
    }

    @Override
    public Codec<class_8786<class_3955>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return codecHelper.getRecipeHolderCodec();
    }

    public ImmutableSize2i getRecipeSize(class_8786<class_3955> recipeHolder) {
        ErrorUtil.checkNotNull(recipeHolder, "recipeHolder");
        return this.extendableHelper.getOptionalRecipeExtension(recipeHolder).map(extension -> {
            int width = extension.getWidth(recipeHolder);
            int height = extension.getHeight(recipeHolder);
            return new ImmutableSize2i(width, height);
        }).orElse(ImmutableSize2i.EMPTY);
    }
}

