/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import com.mojang.serialization.Codec;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1856;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8786;

public abstract class AbstractCookingCategory<T extends class_1874>
implements IRecipeCategory<class_8786<T>> {
    private final IDrawable background;
    private final IDrawable icon;
    private final class_2561 localizedName;
    protected final IGuiHelper guiHelper;
    protected final int regularCookTime;
    protected final IDrawableAnimated animatedFlame;

    public AbstractCookingCategory(IGuiHelper guiHelper, class_2248 icon, String translationKey, int regularCookTime) {
        this(guiHelper, icon, translationKey, regularCookTime, 82, 54);
    }

    public AbstractCookingCategory(IGuiHelper guiHelper, class_2248 icon, String translationKey, int regularCookTime, int width, int height) {
        this.background = guiHelper.createBlankDrawable(width, height);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableItemLike((class_1935)icon);
        this.localizedName = class_2561.method_43471((String)translationKey);
        this.guiHelper = guiHelper;
        this.animatedFlame = guiHelper.createAnimatedRecipeFlame(300);
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void draw(class_8786<T> recipeHolder, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 1, 20);
        this.drawExperience(recipeHolder, guiGraphics, 0);
        this.drawCookTime(recipeHolder, guiGraphics, 45);
    }

    protected void drawExperience(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        float experience = recipe.method_8171();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)experienceString);
            guiGraphics.method_51439(fontRenderer, (class_2561)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        int cookTime = recipe.method_8167();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            class_5250 timeString = class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)timeString);
            guiGraphics.method_51439(fontRenderer, (class_2561)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setStandardSlotBackground().addIngredients((class_1856)recipe.method_8117().getFirst());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).setOutputSlotBackground().addItemStack(RecipeUtil.getResultItem(recipe));
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, class_8786<T> recipeHolder, IFocusGroup focuses) {
        acceptor.addWidget(this.createCookingArrowWidget(recipeHolder, 26, 17));
    }

    @Override
    public boolean isHandled(class_8786<T> recipeHolder) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        return !recipe.method_8118();
    }

    @Override
    public class_2960 getRegistryName(class_8786<T> recipe) {
        return recipe.comp_1932();
    }

    @Override
    public Codec<class_8786<T>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return codecHelper.getRecipeHolderCodec();
    }

    protected IRecipeWidget createCookingArrowWidget(class_8786<T> recipeHolder, int x, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        int cookTime = recipe.method_8167();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        IDrawableAnimated recipeArrow = this.guiHelper.createAnimatedRecipeArrow(cookTime);
        return this.guiHelper.createWidgetFromDrawable(recipeArrow, x, y);
    }
}

