/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class BrewingRecipeCategory
implements IRecipeCategory<IJeiBrewingRecipe> {
    private final IDrawable backgroundArea;
    private final IDrawable backgroundImage;
    private final IDrawable icon;
    private final class_2561 localizedName;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;
    private final IDrawableStatic blazeHeat;

    public BrewingRecipeCategory(IGuiHelper guiHelper) {
        this.backgroundArea = guiHelper.createBlankDrawable(114, 61);
        Textures textures = Internal.getTextures();
        this.backgroundImage = textures.getBrewingStandBackground();
        this.icon = guiHelper.createDrawableItemLike((class_1935)class_2246.field_10333);
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.brewing");
        this.arrow = guiHelper.createAnimatedDrawable(textures.getBrewingStandArrow(), 400, IDrawableAnimated.StartDirection.TOP, false);
        BrewingBubblesTickTimer bubblesTickTimer = new BrewingBubblesTickTimer(guiHelper);
        this.bubbles = guiHelper.createAnimatedDrawable(textures.getBrewingStandBubbles(), bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = textures.getBrewingStandBlazeHeat();
    }

    @Override
    public RecipeType<IJeiBrewingRecipe> getRecipeType() {
        return RecipeTypes.BREWING;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.backgroundArea;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void draw(IJeiBrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.backgroundImage.draw(guiGraphics, 0, 1);
        this.blazeHeat.draw(guiGraphics, 5, 30);
        this.bubbles.draw(guiGraphics, 9, 1);
        this.arrow.draw(guiGraphics, 43, 3);
        int brewingSteps = recipe.getBrewingSteps();
        String brewingStepsString = brewingSteps < Integer.MAX_VALUE ? Integer.toString(brewingSteps) : "?";
        class_5250 steps = class_2561.method_43469((String)"gui.jei.category.brewing.steps", (Object[])new Object[]{brewingStepsString});
        class_310 minecraft = class_310.method_1551();
        guiGraphics.method_51439(minecraft.field_1772, (class_2561)steps, 70, 28, -8355712, false);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiBrewingRecipe recipe, IFocusGroup focuses) {
        List<class_1799> potionInputs = recipe.getPotionInputs();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 37).addItemStacks((List)potionInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 44).addItemStacks((List)potionInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 37).addItemStacks((List)potionInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 3).addItemStacks((List)recipe.getIngredients());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 3).addItemStack(recipe.getPotionOutput())).setStandardSlotBackground();
    }

    @Override
    @Nullable
    public class_2960 getRegistryName(IJeiBrewingRecipe recipe) {
        return recipe.getUid();
    }

    private static class BrewingBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{29, 23, 18, 13, 9, 5, 0};
        private final ITickTimer internalTimer;

        public BrewingBubblesTickTimer(IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        @Override
        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }

        @Override
        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }
    }
}

