/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.info;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IJeiIngredientInfoRecipe> {
    private static final int recipeWidth = 170;
    private static final int recipeHeight = 125;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final class_2561 localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures) {
        this.background = guiHelper.createBlankDrawable(170, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.itemInformation");
    }

    @Override
    public RecipeType<IJeiIngredientInfoRecipe> getRecipeType() {
        return RecipeTypes.INFORMATION;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, IJeiIngredientInfoRecipe recipe, IFocusGroup focuses) {
        int yPos = this.slotBackground.getHeight() + 4;
        int height = 125 - yPos;
        builder.addScrollBoxWidget(170, height, 0, yPos).setContents(recipe.getDescription());
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiIngredientInfoRecipe recipe, IFocusGroup focuses) {
        int xPos = 77;
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, xPos, 1).setStandardSlotBackground();
        IIngredientAcceptor<?> outputSlotBuilder = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
        for (ITypedIngredient<?> typedIngredient : recipe.getIngredients()) {
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, inputSlotBuilder);
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, outputSlotBuilder);
        }
    }

    @Override
    @Nullable
    public class_2960 getRegistryName(IJeiIngredientInfoRecipe recipe) {
        return null;
    }

    private static <T> void addIngredient(ITypedIngredient<T> typedIngredient, IIngredientAcceptor<?> slotBuilder) {
        slotBuilder.addIngredient(typedIngredient.getType(), typedIngredient.getIngredient());
    }
}

