/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes.layout.builder;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.gui.widgets.ISlottedWidgetFactory;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.HighResolutionDrawable;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.core.util.Pair;
import mezz.jei.library.gui.ingredients.CycleTicker;
import mezz.jei.library.gui.ingredients.ICycler;
import mezz.jei.library.gui.recipes.OutputSlotTooltipCallback;
import mezz.jei.library.gui.recipes.RecipeLayout;
import mezz.jei.library.gui.recipes.ShapelessIcon;
import mezz.jei.library.gui.recipes.layout.builder.IngredientAcceptorVoid;
import mezz.jei.library.gui.recipes.layout.builder.RecipeSlotBuilder;
import mezz.jei.library.gui.widgets.ScrollBoxRecipeWidget;
import mezz.jei.library.ingredients.DisplayIngredientAcceptor;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class RecipeLayoutBuilder<T>
implements IRecipeLayoutBuilder,
IRecipeExtrasBuilder {
    private final List<RecipeSlotBuilder> slots = new ArrayList<RecipeSlotBuilder>();
    private final List<List<RecipeSlotBuilder>> focusLinkedSlots = new ArrayList<List<RecipeSlotBuilder>>();
    private final List<IRecipeWidget> widgets = new ArrayList<IRecipeWidget>();
    private final List<IJeiInputHandler> inputHandlers = new ArrayList<IJeiInputHandler>();
    private final List<IJeiGuiEventListener> guiEventListeners = new ArrayList<IJeiGuiEventListener>();
    private final IIngredientManager ingredientManager;
    private final IRecipeCategory<T> recipeCategory;
    private final T recipe;
    private boolean shapeless = false;
    private int shapelessX = -1;
    private int shapelessY = -1;
    private int recipeTransferX = -1;
    private int recipeTransferY = -1;
    private int nextSlotIndex = 0;

    public RecipeLayoutBuilder(IRecipeCategory<T> recipeCategory, T recipe, IIngredientManager ingredientManager) {
        this.recipeCategory = recipeCategory;
        this.recipe = recipe;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public IRecipeSlotBuilder addSlot(RecipeIngredientRole role, int x, int y) {
        RecipeSlotBuilder slot = new RecipeSlotBuilder(this.ingredientManager, this.nextSlotIndex++, role, x, y);
        if (role == RecipeIngredientRole.OUTPUT) {
            this.addOutputSlotTooltipCallback(slot);
        }
        this.slots.add(slot);
        return slot;
    }

    @Override
    public IRecipeSlotBuilder addSlotToWidget(RecipeIngredientRole role, ISlottedWidgetFactory<?> widgetFactory) {
        RecipeSlotBuilder slot = new RecipeSlotBuilder(this.ingredientManager, this.nextSlotIndex++, role, 0, 0).assignToWidgetFactory(widgetFactory);
        if (role == RecipeIngredientRole.OUTPUT) {
            this.addOutputSlotTooltipCallback(slot);
        }
        this.slots.add(slot);
        return slot;
    }

    private void addOutputSlotTooltipCallback(RecipeSlotBuilder slot) {
        class_2960 recipeName = this.recipeCategory.getRegistryName(this.recipe);
        if (recipeName != null) {
            RecipeType<T> recipeType = this.recipeCategory.getRecipeType();
            OutputSlotTooltipCallback callback = new OutputSlotTooltipCallback(recipeName, recipeType);
            slot.addRichTooltipCallback(callback);
        }
    }

    @Override
    public IIngredientAcceptor<?> addInvisibleIngredients(RecipeIngredientRole role) {
        return IngredientAcceptorVoid.INSTANCE;
    }

    @Override
    public void addWidget(IRecipeWidget widget) {
        ErrorUtil.checkNotNull(widget, "widget");
        this.widgets.add(widget);
    }

    @Override
    public void addInputHandler(IJeiInputHandler inputHandler) {
        ErrorUtil.checkNotNull(inputHandler, "inputHandler");
        this.inputHandlers.add(inputHandler);
    }

    @Override
    public void addGuiEventListener(IJeiGuiEventListener guiEventListener) {
        ErrorUtil.checkNotNull(guiEventListener, "guiEventListener");
        this.guiEventListeners.add(guiEventListener);
    }

    @Override
    public IScrollBoxWidget addScrollBoxWidget(int width, int height, int xPos, int yPos) {
        ScrollBoxRecipeWidget widget = new ScrollBoxRecipeWidget(width, height, xPos, yPos);
        this.addWidget(widget);
        this.addInputHandler(widget);
        return widget;
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        this.recipeTransferX = posX;
        this.recipeTransferY = posY;
    }

    @Override
    public void setShapeless() {
        this.shapeless = true;
    }

    @Override
    public void setShapeless(int posX, int posY) {
        this.shapeless = true;
        this.shapelessX = posX;
        this.shapelessY = posY;
    }

    @Override
    public void createFocusLink(IIngredientAcceptor<?> ... slots) {
        ArrayList<RecipeSlotBuilder> builders = new ArrayList<RecipeSlotBuilder>();
        int count = -1;
        for (IIngredientAcceptor<?> slot : slots) {
            RecipeSlotBuilder builder = (RecipeSlotBuilder)slot;
            builders.add(builder);
            DisplayIngredientAcceptor displayIngredientAcceptor = builder.getIngredientAcceptor();
            List<Optional<ITypedIngredient<?>>> allIngredients = displayIngredientAcceptor.getAllIngredients();
            int ingredientCount = allIngredients.size();
            if (count == -1) {
                count = ingredientCount;
                continue;
            }
            if (count == ingredientCount) continue;
            IntSummaryStatistics stats = Arrays.stream(slots).map(RecipeSlotBuilder.class::cast).map(RecipeSlotBuilder::getIngredientAcceptor).map(DisplayIngredientAcceptor::getAllIngredients).mapToInt(Collection::size).summaryStatistics();
            throw new IllegalArgumentException("All slots must have the same number of ingredients in order to create a focus link. " + String.format("slot stats: %s", stats));
        }
        this.focusLinkedSlots.add(builders);
    }

    public RecipeLayout<T> buildRecipeLayout(IFocusGroup focuses, Collection<IRecipeCategoryDecorator<T>> decorators, IScalableDrawable recipeBackground, int recipeBorderPadding) {
        ShapelessIcon shapelessIcon = this.createShapelessIcon(this.recipeCategory);
        ImmutablePoint2i recipeTransferButtonPosition = this.getRecipeTransferButtonPosition(this.recipeCategory, recipeBorderPadding);
        ArrayList<Pair<Integer, IRecipeSlotDrawable>> recipeCategorySlots = new ArrayList<Pair<Integer, IRecipeSlotDrawable>>();
        ArrayList<Pair<Integer, IRecipeSlotDrawable>> allSlots = new ArrayList<Pair<Integer, IRecipeSlotDrawable>>();
        ListMultiMap widgetSlots = new ListMultiMap();
        CycleTicker cycleTicker = CycleTicker.createWithRandomOffset();
        HashSet<RecipeSlotBuilder> focusLinkedSlots = new HashSet<RecipeSlotBuilder>();
        for (List<RecipeSlotBuilder> list : this.focusLinkedSlots) {
            IntArraySet focusMatches = new IntArraySet();
            for (RecipeSlotBuilder slot : list) {
                focusMatches.addAll((IntCollection)slot.getMatches(focuses));
            }
            for (RecipeSlotBuilder slotBuilder : list) {
                ISlottedWidgetFactory<?> assignedWidget = slotBuilder.getAssignedWidget();
                Pair<Integer, IRecipeSlotDrawable> slotDrawable = slotBuilder.build((Set<Integer>)focusMatches, (ICycler)cycleTicker);
                if (assignedWidget == null) {
                    recipeCategorySlots.add(slotDrawable);
                } else {
                    widgetSlots.put(assignedWidget, slotDrawable);
                }
                allSlots.add(slotDrawable);
            }
            focusLinkedSlots.addAll(list);
        }
        for (RecipeSlotBuilder recipeSlotBuilder : this.slots) {
            if (focusLinkedSlots.contains(recipeSlotBuilder)) continue;
            ISlottedWidgetFactory<?> assignedWidget = recipeSlotBuilder.getAssignedWidget();
            Pair<Integer, IRecipeSlotDrawable> slotDrawable = recipeSlotBuilder.build(focuses, (ICycler)cycleTicker);
            if (assignedWidget == null) {
                recipeCategorySlots.add(slotDrawable);
            } else {
                widgetSlots.put(assignedWidget, slotDrawable);
            }
            allSlots.add(slotDrawable);
        }
        for (Map.Entry entry : widgetSlots.entrySet()) {
            ISlottedWidgetFactory factory = (ISlottedWidgetFactory)entry.getKey();
            List<IRecipeSlotDrawable> slots = RecipeLayoutBuilder.sortSlots((List)entry.getValue());
            factory.createWidgetForSlots(this, this.recipe, slots);
        }
        ArrayList<ISlottedRecipeWidget> slottedWidgets = new ArrayList<ISlottedRecipeWidget>();
        for (IRecipeWidget widget : this.widgets) {
            if (!(widget instanceof ISlottedRecipeWidget)) continue;
            ISlottedRecipeWidget slottedWidget = (ISlottedRecipeWidget)widget;
            slottedWidgets.add(slottedWidget);
        }
        return new RecipeLayout<T>(this.recipeCategory, decorators, this.recipe, recipeBackground, recipeBorderPadding, shapelessIcon, recipeTransferButtonPosition, RecipeLayoutBuilder.sortSlots(recipeCategorySlots), RecipeLayoutBuilder.sortSlots(allSlots), slottedWidgets, this.widgets, this.inputHandlers, this.guiEventListeners, cycleTicker, focuses);
    }

    private static List<IRecipeSlotDrawable> sortSlots(List<Pair<Integer, IRecipeSlotDrawable>> indexedSlots) {
        return indexedSlots.stream().sorted(Comparator.comparingInt(Pair::first)).map(Pair::second).toList();
    }

    @Nullable
    private ShapelessIcon createShapelessIcon(IRecipeCategory<?> recipeCategory) {
        int y;
        int x;
        if (!this.shapeless) {
            return null;
        }
        HighResolutionDrawable icon = Internal.getTextures().getShapelessIcon();
        if (this.shapelessX >= 0 && this.shapelessY >= 0) {
            x = this.shapelessX;
            y = this.shapelessY;
        } else {
            x = recipeCategory.getWidth() - icon.getWidth();
            y = 0;
        }
        return new ShapelessIcon(icon, x, y);
    }

    private ImmutablePoint2i getRecipeTransferButtonPosition(IRecipeCategory<?> recipeCategory, int recipeBorderPadding) {
        if (this.recipeTransferX >= 0 && this.recipeTransferY >= 0) {
            return new ImmutablePoint2i(this.recipeTransferX, this.recipeTransferY);
        }
        return new ImmutablePoint2i(recipeCategory.getWidth() + recipeBorderPadding + 2, recipeCategory.getHeight() + recipeBorderPadding - 13);
    }
}

