/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientConsumer;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.library.gui.ingredients.ICycler;
import mezz.jei.library.gui.ingredients.RendererOverrides;
import mezz.jei.library.gui.ingredients.TagContentTooltipComponent;
import mezz.jei.library.gui.recipes.layout.builder.LegacyTooltipCallbackAdapter;
import mezz.jei.library.ingredients.DisplayIngredientAcceptor;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeSlot
implements IRecipeSlotView,
IRecipeSlotDrawable {
    private static final int MAX_DISPLAYED_INGREDIENTS = 100;
    private final RecipeIngredientRole role;
    private final ICycler cycler;
    private final List<IRecipeSlotRichTooltipCallback> tooltipCallbacks;
    @Nullable
    private final RendererOverrides rendererOverrides;
    @Nullable
    private final IDrawable background;
    @Nullable
    private final IDrawable overlay;
    @Nullable
    private final String slotName;
    private ImmutableRect2i rect;
    private final @Unmodifiable List<Optional<ITypedIngredient<?>>> allIngredients;
    private @Unmodifiable @Nullable List<Optional<ITypedIngredient<?>>> displayIngredients;
    @Nullable
    private DisplayIngredientAcceptor displayOverrides;

    public RecipeSlot(RecipeIngredientRole role, ImmutableRect2i rect, ICycler cycler, List<IRecipeSlotRichTooltipCallback> tooltipCallbacks, List<Optional<ITypedIngredient<?>>> allIngredients, @Nullable List<Optional<ITypedIngredient<?>>> focusedIngredients, @Nullable IDrawable background, @Nullable IDrawable overlay, @Nullable String slotName, @Nullable RendererOverrides rendererOverrides) {
        this.allIngredients = List.copyOf(allIngredients);
        this.background = background;
        this.overlay = overlay;
        this.slotName = slotName;
        this.rendererOverrides = rendererOverrides;
        this.role = role;
        this.rect = rect;
        this.cycler = cycler;
        this.displayIngredients = focusedIngredients;
        this.tooltipCallbacks = tooltipCallbacks;
    }

    @Override
    public Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.allIngredients.stream().flatMap(Optional::stream);
    }

    @Override
    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        if (this.displayOverrides != null) {
            List overrides = this.displayOverrides.getAllIngredients();
            return this.cycler.getCycled(overrides);
        }
        if (this.displayIngredients == null) {
            this.displayIngredients = RecipeSlot.calculateDisplayIngredients(this.allIngredients);
        }
        return this.cycler.getCycled(this.displayIngredients);
    }

    private static List<Optional<ITypedIngredient<?>>> calculateDisplayIngredients(List<Optional<ITypedIngredient<?>>> allIngredients) {
        if (allIngredients.isEmpty()) {
            return List.of();
        }
        List<Optional<ITypedIngredient<?>>> visibleIngredients = List.of();
        boolean hasInvisibleIngredients = false;
        IIngredientVisibility ingredientVisibility = Internal.getJeiRuntime().getJeiHelpers().getIngredientVisibility();
        for (int i = 0; i < allIngredients.size() && visibleIngredients.size() < 100; ++i) {
            boolean visible;
            Optional<ITypedIngredient<?>> ingredient = allIngredients.get(i);
            boolean bl = visible = ingredient.isEmpty() || ingredientVisibility.isIngredientVisible(ingredient.get());
            if (visible) {
                if (!hasInvisibleIngredients) continue;
                visibleIngredients.add(ingredient);
                continue;
            }
            if (hasInvisibleIngredients) continue;
            hasInvisibleIngredients = true;
            visibleIngredients = new ArrayList(allIngredients.subList(0, i));
        }
        if (!visibleIngredients.isEmpty()) {
            return visibleIngredients;
        }
        if (allIngredients.size() < 100) {
            return allIngredients;
        }
        return allIngredients.subList(0, 100);
    }

    @Override
    public Optional<String> getSlotName() {
        return Optional.ofNullable(this.slotName);
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    public void drawHighlight(class_332 guiGraphics, int color) {
        int x = this.rect.getX();
        int y = this.rect.getY();
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        guiGraphics.method_51740(class_1921.method_51785(), x, y, x + width, y + height, color, color, 0);
    }

    private <T> void getTooltip(ITooltipBuilder tooltip, ITypedIngredient<T> typedIngredient) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, typedIngredient);
        this.addTagNameTooltip(tooltip, ingredientManager, typedIngredient);
        this.addIngredientsToTooltip(tooltip, typedIngredient);
        for (IRecipeSlotRichTooltipCallback tooltipCallback : this.tooltipCallbacks) {
            tooltipCallback.onRichTooltip(this, tooltip);
        }
    }

    private <T> List<class_2561> legacyGetTooltip(ITypedIngredient<T> typedIngredient) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        JeiTooltip tooltip = new JeiTooltip();
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, typedIngredient);
        this.addTagNameTooltip(tooltip, ingredientManager, typedIngredient);
        for (IRecipeSlotRichTooltipCallback tooltipCallback : this.tooltipCallbacks) {
            tooltipCallback.onRichTooltip(this, tooltip);
        }
        return tooltip.toLegacyToComponents();
    }

    private <T> void addTagNameTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, ITypedIngredient<T> ingredient) {
        IIngredientType<T> ingredientType = ingredient.getType();
        List<T> ingredients = this.getIngredients(ingredientType).toList();
        if (ingredients.isEmpty()) {
            return;
        }
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        if (clientConfig.isHideSingleIngredientTagsEnabled() && ingredients.size() == 1) {
            return;
        }
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        ingredientHelper.getTagKeyEquivalent(ingredients).ifPresent(tagKeyEquivalent -> {
            tooltip.add((class_5348)class_2561.method_43469((String)"jei.tooltip.recipe.tag", (Object[])new Object[]{""}).method_27692(class_124.field_1080));
            IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
            class_2561 tagName = renderHelper.getName((class_6862<?>)tagKeyEquivalent);
            tooltip.add((class_5348)tagName.method_27661().method_27692(class_124.field_1080));
        });
    }

    private <T> void addIngredientsToTooltip(ITooltipBuilder tooltip, ITypedIngredient<T> displayed) {
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        if (clientConfig.isTagContentTooltipEnabled()) {
            IIngredientType<T> type = displayed.getType();
            IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            IIngredientRenderer<T> renderer = ingredientManager.getIngredientRenderer(type);
            List<T> ingredients = this.getIngredients(type).toList();
            if (ingredients.size() > 1) {
                tooltip.add(new TagContentTooltipComponent<T>(renderer, ingredients));
            }
        }
    }

    @Override
    public void addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        this.tooltipCallbacks.add(new LegacyTooltipCallbackAdapter(tooltipCallback));
    }

    private <T> IIngredientRenderer<T> getIngredientRenderer(IIngredientType<T> ingredientType) {
        return Optional.ofNullable(this.rendererOverrides).flatMap(r -> r.getIngredientRenderer(ingredientType)).orElseGet(() -> {
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            return ingredientManager.getIngredientRenderer(ingredientType);
        });
    }

    @Override
    public void draw(class_332 guiGraphics) {
        int x = this.rect.getX();
        int y = this.rect.getY();
        if (this.background != null) {
            this.background.draw(guiGraphics, x, y);
        }
        RenderSystem.enableBlend();
        this.getDisplayedIngredient().ifPresent(ingredient -> this.drawIngredient(guiGraphics, (ITypedIngredient)ingredient, x, y));
        if (this.overlay != null) {
            RenderSystem.enableBlend();
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 200.0f);
            this.overlay.draw(guiGraphics, x, y);
            poseStack.method_22909();
        }
        RenderSystem.disableBlend();
    }

    private <T> void drawIngredient(class_332 guiGraphics, ITypedIngredient<T> typedIngredient, int xPos, int yPos) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        SafeIngredientUtil.render(guiGraphics, ingredientRenderer, typedIngredient, xPos, yPos);
    }

    @Override
    public void drawHoverOverlays(class_332 guiGraphics) {
        this.drawHighlight(guiGraphics, -2130706433);
    }

    @Override
    public List<class_2561> getTooltip() {
        return this.getDisplayedIngredient().map(this::legacyGetTooltip).orElseGet(List::of);
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltipBuilder) {
        this.getDisplayedIngredient().ifPresent(ingredient -> this.getTooltip(tooltipBuilder, (ITypedIngredient)ingredient));
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.rect.contains(mouseX, mouseY);
    }

    @Override
    public void setPosition(int x, int y) {
        this.rect = this.rect.setPosition(x, y);
    }

    @Override
    public void clearDisplayOverrides() {
        this.displayOverrides = null;
    }

    @Override
    public IIngredientConsumer createDisplayOverrides() {
        if (this.displayOverrides == null) {
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            this.displayOverrides = new DisplayIngredientAcceptor(ingredientManager);
        }
        return this.displayOverrides;
    }

    @Override
    public class_768 getRect() {
        return this.rect.toMutable();
    }

    public String toString() {
        return "RecipeSlot{rect=" + String.valueOf(this.rect) + "}";
    }
}

