/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class StackHelper
implements IStackHelper {
    private final ISubtypeManager subtypeManager;

    public StackHelper(ISubtypeManager subtypeManager) {
        this.subtypeManager = subtypeManager;
    }

    @Override
    public boolean isEquivalent(@Nullable class_1799 lhs, @Nullable class_1799 rhs, UidContext context) {
        ErrorUtil.checkNotNull(context, "context");
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.method_7909() != rhs.method_7909()) {
            return false;
        }
        Object keyLhs = this.subtypeManager.getSubtypeData(lhs, context);
        Object keyRhs = this.subtypeManager.getSubtypeData(rhs, context);
        return Objects.equals(keyLhs, keyRhs);
    }

    @Override
    public Object getUidForStack(class_1799 stack, UidContext context) {
        class_1792 item = stack.method_7909();
        Object subtypeData = this.subtypeManager.getSubtypeData(stack, context);
        if (subtypeData != null) {
            return List.of(item, subtypeData);
        }
        return item;
    }

    @Override
    public String getUniqueIdentifierForStack(class_1799 stack, UidContext context) {
        Object result = StackHelper.getRegistryNameForStack(stack);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(stack, context);
        if (!subtypeInfo.isEmpty()) {
            result = (String)result + ":" + subtypeInfo;
        }
        return result;
    }

    public boolean hasSubtypes(class_1799 stack) {
        return this.subtypeManager.hasSubtypes(VanillaTypes.ITEM_STACK, stack);
    }

    public static String getRegistryNameForStack(class_1799 stack) {
        ErrorUtil.checkNotEmpty(stack, "stack");
        class_1792 item = stack.method_7909();
        class_2960 key = RegistryUtil.getRegistry(class_7924.field_41197).method_10221((Object)item);
        if (key == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            throw new IllegalStateException("Item has no registry key: " + stackInfo);
        }
        return key.toString();
    }
}

