/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.AlignableNormal;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalPlanes;
import net.minecraft.class_4076;
import org.joml.Vector3fc;

public class GeometryPlanes {
    private NormalPlanes[] alignedPlanes;
    private Object2ReferenceOpenHashMap<Vector3fc, NormalPlanes> unalignedPlanes;

    public NormalPlanes[] getAligned() {
        return this.alignedPlanes;
    }

    public NormalPlanes[] getAlignedOrCreate() {
        if (this.alignedPlanes == null) {
            this.alignedPlanes = new NormalPlanes[ModelQuadFacing.DIRECTIONS];
        }
        return this.alignedPlanes;
    }

    public Collection<NormalPlanes> getUnaligned() {
        if (this.unalignedPlanes == null) {
            return null;
        }
        return this.unalignedPlanes.values();
    }

    public Object2ReferenceOpenHashMap<Vector3fc, NormalPlanes> getUnalignedOrCreate() {
        if (this.unalignedPlanes == null) {
            this.unalignedPlanes = new Object2ReferenceOpenHashMap();
        }
        return this.unalignedPlanes;
    }

    public Collection<Vector3fc> getUnalignedNormals() {
        if (this.unalignedPlanes == null) {
            return null;
        }
        return this.unalignedPlanes.keySet();
    }

    NormalPlanes getPlanesForNormal(NormalList normalList) {
        AlignableNormal normal = normalList.getNormal();
        if (normal.isAligned()) {
            if (this.alignedPlanes == null) {
                return null;
            }
            return this.alignedPlanes[normal.getAlignedDirection()];
        }
        if (this.unalignedPlanes == null) {
            return null;
        }
        return (NormalPlanes)this.unalignedPlanes.get((Object)normal);
    }

    public void addAlignedPlane(class_4076 sectionPos, int direction, float distance) {
        NormalPlanes[] alignedDistances = this.getAlignedOrCreate();
        NormalPlanes normalPlanes = alignedDistances[direction];
        if (normalPlanes == null) {
            alignedDistances[direction] = normalPlanes = new NormalPlanes(sectionPos, direction);
        }
        normalPlanes.addPlaneMember(distance);
    }

    public void addDoubleSidedPlane(class_4076 sectionPos, int axis, float distance) {
        this.addAlignedPlane(sectionPos, axis, distance);
        this.addAlignedPlane(sectionPos, axis + 3, -distance);
    }

    public void addUnalignedPlane(class_4076 sectionPos, Vector3fc normal, float distance) {
        Object2ReferenceOpenHashMap<Vector3fc, NormalPlanes> unalignedDistances = this.getUnalignedOrCreate();
        NormalPlanes normalPlanes = (NormalPlanes)unalignedDistances.get((Object)normal);
        if (normalPlanes == null) {
            normalPlanes = new NormalPlanes(sectionPos, normal);
            unalignedDistances.put((Object)normal, (Object)normalPlanes);
        }
        normalPlanes.addPlaneMember(distance);
    }

    public void addQuadPlane(class_4076 sectionPos, TQuad quad) {
        ModelQuadFacing facing = quad.useQuantizedFacing();
        if (facing.isAligned()) {
            this.addAlignedPlane(sectionPos, facing.ordinal(), quad.getDotProduct());
        } else {
            this.addUnalignedPlane(sectionPos, quad.getQuantizedNormal(), quad.getDotProduct());
        }
    }

    private void prepareAndInsert(Object2ReferenceOpenHashMap<Vector3fc, float[]> distancesByNormal) {
        if (this.alignedPlanes != null) {
            for (ObjectIterator normalPlanes : this.alignedPlanes) {
                if (normalPlanes == null) continue;
                normalPlanes.prepareAndInsert(distancesByNormal);
            }
        }
        if (this.unalignedPlanes != null) {
            for (NormalPlanes normalPlanes : this.unalignedPlanes.values()) {
                normalPlanes.prepareAndInsert(distancesByNormal);
            }
        }
    }

    public void prepareIntegration() {
        this.prepareAndInsert(null);
    }

    public Object2ReferenceOpenHashMap<Vector3fc, float[]> prepareAndGetDistances() {
        Object2ReferenceOpenHashMap distancesByNormal = new Object2ReferenceOpenHashMap(10);
        this.prepareAndInsert((Object2ReferenceOpenHashMap<Vector3fc, float[]>)distancesByNormal);
        return distancesByNormal;
    }

    public static GeometryPlanes fromQuadLists(class_4076 sectionPos, TQuad[] quads) {
        GeometryPlanes geometryPlanes = new GeometryPlanes();
        for (TQuad quad : quads) {
            geometryPlanes.addQuadPlane(sectionPos, quad);
        }
        return geometryPlanes;
    }
}

