/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPResult;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPSortState;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPWorkspace;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.InnerPartitionBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.LeafDoubleBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.LeafSingleBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TopoGraphSorting;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.class_4076;
import org.joml.Vector3fc;

public abstract class BSPNode {
    abstract void collectSortedQuads(BSPSortState var1, Vector3fc var2);

    public void collectSortedQuads(NativeBuffer nativeBuffer, Vector3fc cameraPos) {
        this.collectSortedQuads(new BSPSortState(nativeBuffer), cameraPos);
    }

    public static BSPResult buildBSP(TQuad[] quads, class_4076 sectionPos, BSPNode oldRoot, boolean prepareNodeReuse) {
        InnerPartitionBSPNode.validateQuadCount(quads.length);
        BSPWorkspace workspace = new BSPWorkspace(quads, sectionPos, prepareNodeReuse);
        int[] initialIndexes = new int[quads.length];
        for (int i = 0; i < quads.length; ++i) {
            initialIndexes[i] = i;
        }
        IntArrayList allIndexes = new IntArrayList(initialIndexes);
        BSPNode rootNode = BSPNode.build(workspace, allIndexes, -1, oldRoot);
        BSPResult result = workspace.result;
        result.setRootNode(rootNode);
        return result;
    }

    private static boolean doubleLeafPossible(TQuad quadA, TQuad quadB) {
        ModelQuadFacing facingA = quadA.getFacing();
        ModelQuadFacing facingB = quadB.getFacing();
        if (!facingA.isAligned() || !facingB.isAligned()) {
            int packedNormalB;
            int packedNormalA = quadA.getPackedNormal();
            return NormI8.isOpposite(packedNormalA, packedNormalB = quadB.getPackedNormal()) || packedNormalA == packedNormalB && quadA.getDotProduct() == quadB.getDotProduct();
        }
        if (quadA.getExtents()[facingA.ordinal()] == quadB.getExtents()[facingB.ordinal()]) {
            return true;
        }
        if (facingA == facingB.getOpposite()) {
            return true;
        }
        return !TopoGraphSorting.orthogonalQuadVisibleThrough(quadA, quadB) && !TopoGraphSorting.orthogonalQuadVisibleThrough(quadB, quadA);
    }

    static BSPNode build(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode) {
        int quadIndexB;
        TQuad quadB;
        int quadIndexA;
        TQuad quadA;
        ++depth;
        if (indexes.isEmpty()) {
            return null;
        }
        if (indexes.size() == 1) {
            return new LeafSingleBSPNode(indexes.getInt(0));
        }
        if (indexes.size() == 2 && BSPNode.doubleLeafPossible(quadA = workspace.quads[quadIndexA = indexes.getInt(0)], quadB = workspace.quads[quadIndexB = indexes.getInt(1)])) {
            return new LeafDoubleBSPNode(quadIndexA, quadIndexB);
        }
        return InnerPartitionBSPNode.build(workspace, indexes, depth, oldNode);
    }
}

