/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import java.util.Iterator;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.DrawCommandList;
import net.caffeinemc.mods.sodium.client.gl.device.MultiDrawBatch;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.gl.tessellation.GlIndexType;
import net.caffeinemc.mods.sodium.client.gl.tessellation.GlPrimitiveType;
import net.caffeinemc.mods.sodium.client.gl.tessellation.GlTessellation;
import net.caffeinemc.mods.sodium.client.gl.tessellation.TessellationBinding;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.LocalSectionIndex;
import net.caffeinemc.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.SharedQuadIndexBuffer;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderListIterable;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.util.BitwiseMath;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import org.lwjgl.system.MemoryUtil;

public class DefaultChunkRenderer
extends ShaderChunkRenderer {
    private final MultiDrawBatch batch = new MultiDrawBatch(ModelQuadFacing.COUNT * 256 + 1);
    private final SharedQuadIndexBuffer sharedIndexBuffer;
    private static final int MODEL_UNASSIGNED = ModelQuadFacing.UNASSIGNED.ordinal();
    private static final int MODEL_POS_X = ModelQuadFacing.POS_X.ordinal();
    private static final int MODEL_POS_Y = ModelQuadFacing.POS_Y.ordinal();
    private static final int MODEL_POS_Z = ModelQuadFacing.POS_Z.ordinal();
    private static final int MODEL_NEG_X = ModelQuadFacing.NEG_X.ordinal();
    private static final int MODEL_NEG_Y = ModelQuadFacing.NEG_Y.ordinal();
    private static final int MODEL_NEG_Z = ModelQuadFacing.NEG_Z.ordinal();

    public DefaultChunkRenderer(RenderDevice device, ChunkVertexType vertexType) {
        super(device, vertexType);
        this.sharedIndexBuffer = new SharedQuadIndexBuffer(device.createCommandList(), SharedQuadIndexBuffer.IndexType.INTEGER);
    }

    @Override
    public void render(ChunkRenderMatrices matrices, CommandList commandList, ChunkRenderListIterable renderLists, TerrainRenderPass renderPass, CameraTransform camera) {
        super.begin(renderPass);
        boolean useBlockFaceCulling = SodiumClientMod.options().performance.useBlockFaceCulling;
        boolean useIndexedTessellation = DefaultChunkRenderer.isTranslucentRenderPass(renderPass);
        ChunkShaderInterface shader = (ChunkShaderInterface)this.activeProgram.getInterface();
        shader.setProjectionMatrix(matrices.projection());
        shader.setModelViewMatrix(matrices.modelView());
        Iterator<ChunkRenderList> iterator = renderLists.iterator(renderPass.isTranslucent());
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            RenderRegion region = renderList.getRegion();
            SectionRenderDataStorage storage = region.getStorage(renderPass);
            if (storage == null) continue;
            DefaultChunkRenderer.fillCommandBuffer(this.batch, region, storage, renderList, camera, renderPass, useBlockFaceCulling);
            if (this.batch.isEmpty()) continue;
            if (!useIndexedTessellation) {
                this.sharedIndexBuffer.ensureCapacity(commandList, this.batch.getIndexBufferSize());
            }
            GlTessellation tessellation = useIndexedTessellation ? this.prepareIndexedTessellation(commandList, region) : this.prepareTessellation(commandList, region);
            DefaultChunkRenderer.setModelMatrixUniforms(shader, region, camera);
            DefaultChunkRenderer.executeDrawBatch(commandList, tessellation, this.batch);
        }
        super.end(renderPass);
    }

    private static boolean isTranslucentRenderPass(TerrainRenderPass renderPass) {
        return renderPass.isTranslucent() && SodiumClientMod.options().performance.getSortBehavior() != SortBehavior.OFF;
    }

    private static void fillCommandBuffer(MultiDrawBatch batch, RenderRegion renderRegion, SectionRenderDataStorage renderDataStorage, ChunkRenderList renderList, CameraTransform camera, TerrainRenderPass pass, boolean useBlockFaceCulling) {
        batch.clear();
        ByteIterator iterator = renderList.sectionsWithGeometryIterator(pass.isTranslucent());
        if (iterator == null) {
            return;
        }
        int originX = renderRegion.getChunkX();
        int originY = renderRegion.getChunkY();
        int originZ = renderRegion.getChunkZ();
        while (iterator.hasNext()) {
            int sectionIndex = iterator.nextByteAsInt();
            long pMeshData = renderDataStorage.getDataPointer(sectionIndex);
            int chunkX = originX + LocalSectionIndex.unpackX(sectionIndex);
            int chunkY = originY + LocalSectionIndex.unpackY(sectionIndex);
            int chunkZ = originZ + LocalSectionIndex.unpackZ(sectionIndex);
            int slices = useBlockFaceCulling ? DefaultChunkRenderer.getVisibleFaces(camera.intX, camera.intY, camera.intZ, chunkX, chunkY, chunkZ) : ModelQuadFacing.ALL;
            if ((slices &= SectionRenderDataUnsafe.getSliceMask(pMeshData)) == 0) continue;
            DefaultChunkRenderer.addDrawCommands(batch, pMeshData, slices);
        }
    }

    private static void addDrawCommands(MultiDrawBatch batch, long pMeshData, int mask) {
        int elementOffset = SectionRenderDataUnsafe.getBaseElement(pMeshData);
        if ((elementOffset & Integer.MIN_VALUE) != 0) {
            DefaultChunkRenderer.addIndexedDrawCommands(batch, pMeshData, mask);
        } else {
            DefaultChunkRenderer.addNonIndexedDrawCommands(batch, pMeshData, mask);
        }
    }

    private static void addNonIndexedDrawCommands(MultiDrawBatch batch, long pMeshData, int mask) {
        long pElementPointer = batch.pElementPointer;
        long pBaseVertex = batch.pBaseVertex;
        long pElementCount = batch.pElementCount;
        int size = batch.size;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            MemoryUtil.memPutInt((long)(pBaseVertex + (long)(size << 2)), (int)SectionRenderDataUnsafe.getVertexOffset(pMeshData, facing));
            MemoryUtil.memPutInt((long)(pElementCount + (long)(size << 2)), (int)SectionRenderDataUnsafe.getElementCount(pMeshData, facing));
            MemoryUtil.memPutAddress((long)(pElementPointer + (long)(size << 3)), (long)0L);
            size += mask >> facing & 1;
        }
        batch.size = size;
    }

    private static void addIndexedDrawCommands(MultiDrawBatch batch, long pMeshData, int mask) {
        long pElementPointer = batch.pElementPointer;
        long pBaseVertex = batch.pBaseVertex;
        long pElementCount = batch.pElementCount;
        int size = batch.size;
        int elementOffset = SectionRenderDataUnsafe.getBaseElement(pMeshData) & Integer.MAX_VALUE;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            int elementCount = SectionRenderDataUnsafe.getElementCount(pMeshData, facing);
            MemoryUtil.memPutInt((long)(pBaseVertex + (long)(size << 2)), (int)SectionRenderDataUnsafe.getVertexOffset(pMeshData, facing));
            MemoryUtil.memPutInt((long)(pElementCount + (long)(size << 2)), (int)elementCount);
            MemoryUtil.memPutAddress((long)(pElementPointer + (long)(size << 3)), (long)(elementOffset << 2));
            elementOffset += elementCount;
            size += mask >> facing & 1;
        }
        batch.size = size;
    }

    private static int getVisibleFaces(int originX, int originY, int originZ, int chunkX, int chunkY, int chunkZ) {
        int boundsMinX = chunkX << 4;
        int boundsMaxX = boundsMinX + 16;
        int boundsMinY = chunkY << 4;
        int boundsMaxY = boundsMinY + 16;
        int boundsMinZ = chunkZ << 4;
        int boundsMaxZ = boundsMinZ + 16;
        int planes = 1 << MODEL_UNASSIGNED;
        planes |= BitwiseMath.greaterThan(originX, boundsMinX - 3) << MODEL_POS_X;
        planes |= BitwiseMath.greaterThan(originY, boundsMinY - 3) << MODEL_POS_Y;
        planes |= BitwiseMath.greaterThan(originZ, boundsMinZ - 3) << MODEL_POS_Z;
        planes |= BitwiseMath.lessThan(originX, boundsMaxX + 3) << MODEL_NEG_X;
        planes |= BitwiseMath.lessThan(originY, boundsMaxY + 3) << MODEL_NEG_Y;
        return planes |= BitwiseMath.lessThan(originZ, boundsMaxZ + 3) << MODEL_NEG_Z;
    }

    private static void setModelMatrixUniforms(ChunkShaderInterface shader, RenderRegion region, CameraTransform camera) {
        float x = DefaultChunkRenderer.getCameraTranslation(region.getOriginX(), camera.intX, camera.fracX);
        float y = DefaultChunkRenderer.getCameraTranslation(region.getOriginY(), camera.intY, camera.fracY);
        float z = DefaultChunkRenderer.getCameraTranslation(region.getOriginZ(), camera.intZ, camera.fracZ);
        shader.setRegionOffset(x, y, z);
    }

    private static float getCameraTranslation(int chunkBlockPos, int cameraBlockPos, float cameraPos) {
        return (float)(chunkBlockPos - cameraBlockPos) - cameraPos;
    }

    private GlTessellation prepareTessellation(CommandList commandList, RenderRegion region) {
        RenderRegion.DeviceResources resources = region.getResources();
        GlTessellation tessellation = resources.getTessellation();
        if (tessellation == null) {
            tessellation = this.createRegionTessellation(commandList, resources, true);
            resources.updateTessellation(commandList, tessellation);
        }
        return tessellation;
    }

    private GlTessellation prepareIndexedTessellation(CommandList commandList, RenderRegion region) {
        RenderRegion.DeviceResources resources = region.getResources();
        GlTessellation tessellation = resources.getIndexedTessellation();
        if (tessellation == null) {
            tessellation = this.createRegionTessellation(commandList, resources, false);
            resources.updateIndexedTessellation(commandList, tessellation);
        }
        return tessellation;
    }

    private GlTessellation createRegionTessellation(CommandList commandList, RenderRegion.DeviceResources resources, boolean useSharedIndexBuffer) {
        return commandList.createTessellation(GlPrimitiveType.TRIANGLES, new TessellationBinding[]{TessellationBinding.forVertexBuffer(resources.getGeometryBuffer(), this.vertexFormat.getShaderBindings()), TessellationBinding.forElementBuffer(useSharedIndexBuffer ? this.sharedIndexBuffer.getBufferObject() : resources.getIndexBuffer())});
    }

    private static void executeDrawBatch(CommandList commandList, GlTessellation tessellation, MultiDrawBatch batch) {
        try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
            drawCommandList.multiDrawElementsBaseVertex(batch, GlIndexType.UNSIGNED_INT);
        }
    }

    @Override
    public void delete(CommandList commandList) {
        super.delete(commandList);
        this.sharedIndexBuffer.delete(commandList);
        this.batch.delete();
    }
}

