/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import org.figuramc.figura.utils.FiguraText;

public class TextUtils {
    public static final class_2561 TAB = FiguraText.of("tab");
    public static final class_2561 ELLIPSIS = FiguraText.of("ellipsis");
    public static final class_2561 UNKNOWN = class_2561.method_43470((String)"\ufffd").method_27696(class_2583.field_24360.method_27704(class_2583.field_24359));
    public static boolean allowScriptEvents;

    public static List<class_2561> splitText(class_5348 text, String regex) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        class_5250[] currentText = new class_5250[]{class_2561.method_43473()};
        text.method_27658((style, string) -> {
            String[] lines = string.split(regex, -1);
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    textList.add((class_2561)currentText[0].method_27661());
                    currentText[0] = class_2561.method_43473();
                }
                currentText[0].method_10852((class_2561)class_2561.method_43470((String)lines[i]).method_27696(style));
            }
            return Optional.empty();
        }, class_2583.field_24360);
        textList.add((class_2561)currentText[0]);
        return textList;
    }

    public static class_2561 removeClickableObjects(class_5348 text) {
        return TextUtils.removeClickableObjects(text, p -> true);
    }

    public static class_2561 removeClickableObjects(class_5348 text, Predicate<class_2558> pred) {
        class_5250 ret = class_2561.method_43473();
        text.method_27658((style, string) -> {
            ret.method_10852((class_2561)class_2561.method_43470((String)string).method_27696(style.method_10970() != null && pred.test(style.method_10970()) ? style.method_10958(null) : style));
            return Optional.empty();
        }, class_2583.field_24360);
        return ret;
    }

    public static class_2561 tryParseJson(String text) {
        class_5250 finalText;
        if (text == null) {
            return class_2561.method_43473();
        }
        try {
            JsonParser.parseString((String)text);
            finalText = class_2561.class_2562.method_10873((String)text, (class_7225.class_7874)class_5455.field_40585);
            if (finalText == null) {
                throw new Exception("Error parsing JSON string");
            }
        }
        catch (Exception ignored) {
            finalText = class_2561.method_43470((String)text);
        }
        return finalText;
    }

    public static class_2561 replaceInText(class_5348 text, String regex, Object replacement) {
        return TextUtils.replaceInText(text, regex, replacement, (s, style) -> true, Integer.MAX_VALUE);
    }

    public static class_2561 replaceInText(class_5348 text, String regex, Object replacement, BiPredicate<String, class_2583> predicate, int times) {
        return TextUtils.replaceInText(text, regex, replacement, predicate, 0, times);
    }

    public static class_2561 replaceInText(class_5348 text, String regex, Object replacement, BiPredicate<String, class_2583> predicate, int beginIndex, int times) {
        class_5250 class_52502;
        if (replacement instanceof class_2561) {
            class_2561 c = (class_2561)replacement;
            class_52502 = c;
        } else {
            class_52502 = class_2561.method_43470((String)replacement.toString());
        }
        class_5250 replace = class_52502;
        class_5250 ret = class_2561.method_43473();
        int[] ints = new int[]{beginIndex, times};
        text.method_27658((arg_0, arg_1) -> TextUtils.lambda$replaceInText$4(predicate, ret, regex, ints, (class_2561)replace, arg_0, arg_1), class_2583.field_24360);
        return ret;
    }

    public static class_2561 trimToWidthEllipsis(class_327 font, class_2561 text, int width, class_2561 ellipsis) {
        if (font.method_30880(text.method_30937()) <= width) {
            return text;
        }
        return TextUtils.addEllipsis(font, (class_5348)text, width, ellipsis);
    }

    public static class_2561 addEllipsis(class_327 font, class_5348 text, int width, class_2561 ellipsis) {
        class_5348 trimmed = font.method_1714(text, width - font.method_27525((class_5348)ellipsis));
        return TextUtils.formattedTextToText(trimmed).method_27661().method_10852(ellipsis);
    }

    public static class_2561 replaceTabs(class_5348 text) {
        return TextUtils.replaceInText(text, "\\t", TAB);
    }

    public static List<class_5481> wrapTooltip(class_5348 text, class_327 font, int mousePos, int screenWidth, int offset) {
        List<class_2561> splitText = TextUtils.splitText(text, "\n");
        int left = mousePos - offset;
        int right = screenWidth - mousePos - offset;
        int largest = TextUtils.getWidth(splitText, font);
        int side = largest <= right ? right : (largest <= left ? left : Math.max(left, right));
        return TextUtils.wrapText(text, side, font);
    }

    public static int getWidth(List<?> text, class_327 font) {
        int width = 0;
        for (Object object : text) {
            int w;
            if (object instanceof class_2561) {
                class_2561 component = (class_2561)object;
                w = font.method_27525((class_5348)component);
            } else if (object instanceof class_5481) {
                class_5481 charSequence = (class_5481)object;
                w = font.method_30880(charSequence);
            } else if (object instanceof String) {
                String s = (String)object;
                w = font.method_1727(s);
            } else {
                w = 0;
            }
            width = Math.max(width, w);
        }
        return width;
    }

    public static int getHeight(List<?> text, class_327 font, int lineSpaceing) {
        int lines = text.size();
        Objects.requireNonNull(font);
        return lines * 9 + Math.max((lines - 1) * lineSpaceing, 0);
    }

    public static int getHeight(List<?> text, class_327 font) {
        return TextUtils.getHeight(text, font, 1);
    }

    public static class_2561 replaceStyle(class_5348 text, class_2583 newStyle, Predicate<class_2583> predicate) {
        class_5250 ret = class_2561.method_43473();
        text.method_27658((style, string) -> {
            ret.method_10852((class_2561)class_2561.method_43470((String)string).method_27696(predicate.test(style) ? newStyle.method_27702(style) : style));
            return Optional.empty();
        }, class_2583.field_24360);
        return ret;
    }

    public static class_2561 setStyleAtWidth(class_5348 text, int width, class_327 font, class_2583 newStyle) {
        class_5250 ret = class_2561.method_43473();
        text.method_27658((style, string) -> {
            class_5250 current = class_2561.method_43470((String)string).method_27696(style);
            int prevWidth = font.method_27525((class_5348)ret);
            int currentWidth = font.method_27525((class_5348)current);
            if (prevWidth <= width && prevWidth + currentWidth > width) {
                current.method_27696(newStyle);
            }
            ret.method_10852((class_2561)current);
            return Optional.empty();
        }, class_2583.field_24360);
        return ret;
    }

    public static List<class_5481> wrapText(class_5348 text, int width, class_327 font) {
        ArrayList<class_5481> warp = new ArrayList<class_5481>();
        font.method_27527().method_29971(text, width, class_2583.field_24360, (formattedText, aBoolean) -> warp.add(class_2477.method_10517().method_30934(formattedText)));
        return warp;
    }

    public static class_2561 charSequenceToText(class_5481 charSequence) {
        class_5250 builder = class_2561.method_43473();
        StringBuilder buffer = new StringBuilder();
        class_2583[] lastStyle = new class_2583[1];
        charSequence.accept((index, style, codePoint) -> {
            if (!style.equals((Object)lastStyle[0])) {
                if (buffer.length() > 0) {
                    builder.method_10852((class_2561)class_2561.method_43470((String)buffer.toString()).method_27696(lastStyle[0]));
                    buffer.setLength(0);
                }
                lastStyle[0] = style;
            }
            buffer.append(Character.toChars(codePoint));
            return true;
        });
        if (buffer.length() > 0) {
            builder.method_10852((class_2561)class_2561.method_43470((String)buffer.toString()).method_27696(lastStyle[0]));
        }
        return builder;
    }

    public static class_2561 formattedTextToText(class_5348 formattedText) {
        if (formattedText instanceof class_2561) {
            class_2561 c = (class_2561)formattedText;
            return c;
        }
        class_5250 builder = class_2561.method_43473();
        formattedText.method_27658((style, string) -> {
            builder.method_10852((class_2561)class_2561.method_43470((String)string).method_27696(style));
            return Optional.empty();
        }, class_2583.field_24360);
        return builder;
    }

    public static class_2561 substring(class_5348 text, int beginIndex, int endIndex) {
        StringBuilder counter = new StringBuilder();
        class_5250 builder = class_2561.method_43473();
        text.method_27658((style, string) -> {
            int index = counter.length();
            int len = string.length();
            if (index <= endIndex && index + len >= beginIndex) {
                int sub = Math.max(beginIndex - index, 0);
                int top = Math.min(endIndex - index, len);
                builder.method_10852((class_2561)class_2561.method_43470((String)string.substring(sub, top)).method_27696(style));
            }
            counter.append(string);
            return counter.length() > endIndex ? class_5348.field_25309 : Optional.empty();
        }, class_2583.field_24360);
        return builder;
    }

    public static class_2561 parseLegacyFormatting(class_5348 text) {
        class_5250 builder = class_2561.method_43473();
        text.method_27658((style, string) -> {
            String[] split;
            if (string.contains("\u00a7") && (split = string.split("\u00a7")).length >= 2) {
                class_5250 newText = class_2561.method_43470((String)split[0]).method_27696(style);
                for (int i = 1; i < split.length; ++i) {
                    String s = split[i];
                    if (s.length() == 0) continue;
                    class_124 formatting = class_124.method_544((char)s.charAt(0));
                    if (formatting != null) {
                        style = style.method_27707(formatting);
                    }
                    newText.method_10852((class_2561)class_2561.method_43470((String)s.substring(1)).method_27696(style));
                }
                builder.method_10852((class_2561)newText);
                return Optional.empty();
            }
            builder.method_10852((class_2561)class_2561.method_43470((String)string).method_27696(style));
            return Optional.empty();
        }, class_2583.field_24360);
        return builder;
    }

    public static class_2561 reverse(class_5348 text) {
        class_5250[] builder = new class_5250[]{class_2561.method_43473()};
        text.method_27658((style, string) -> {
            StringBuilder str = new StringBuilder(string).reverse();
            builder[0] = class_2561.method_43470((String)str.toString()).method_27696(style).method_10852((class_2561)builder[0]);
            return Optional.empty();
        }, class_2583.field_24360);
        return builder[0];
    }

    public static class_2561 trim(class_5348 text) {
        int start;
        String string = text.getString();
        int end = string.length();
        for (start = 0; start < end && string.charAt(start) <= ' '; ++start) {
        }
        while (start < end && string.charAt(end - 1) <= ' ') {
            --end;
        }
        return TextUtils.substring(text, start, end);
    }

    public static List<class_2561> formatInBounds(class_5348 text, class_327 font, int maxWidth, boolean wrap) {
        if (maxWidth > 0) {
            if (wrap) {
                List<class_5481> warped = TextUtils.wrapText(text, maxWidth, font);
                ArrayList<class_2561> newList = new ArrayList<class_2561>();
                for (class_5481 charSequence : warped) {
                    newList.add(TextUtils.charSequenceToText(charSequence));
                }
                return newList;
            }
            List<class_2561> list = TextUtils.splitText(text, "\n");
            ArrayList<class_2561> newList = new ArrayList<class_2561>();
            for (class_2561 component : list) {
                newList.add(TextUtils.formattedTextToText(font.method_1714((class_5348)component, maxWidth)));
            }
            return newList;
        }
        return TextUtils.splitText(text, "\n");
    }

    private static /* synthetic */ Optional lambda$replaceInText$4(BiPredicate predicate, class_5250 ret, String regex, int[] ints, class_2561 replace, class_2583 style, String string) {
        String[] split;
        if (!predicate.test(string, style)) {
            ret.method_10852((class_2561)class_2561.method_43470((String)string).method_27696(style));
            return Optional.empty();
        }
        for (String s : split = string.split("((?<=" + regex + ")|(?=" + regex + "))")) {
            if (!s.matches(regex)) {
                ret.method_10852((class_2561)class_2561.method_43470((String)s).method_27696(style));
                continue;
            }
            if (ints[0] > 0 || ints[1] <= 0) {
                ret.method_10852((class_2561)class_2561.method_43470((String)s).method_27696(style));
            } else {
                ret.method_10852((class_2561)class_2561.method_43473().method_27696(style).method_10852(replace));
            }
            ints[0] = ints[0] - 1;
            ints[1] = ints[1] - 1;
        }
        return Optional.empty();
    }

    public static class FiguraClickEvent
    extends class_2558 {
        public final Runnable onClick;

        public FiguraClickEvent(Runnable onClick) {
            super(class_2558.class_2559.field_11745, "");
            this.onClick = onClick;
        }
    }

    public static enum Alignment {
        LEFT((font, component) -> 0, i -> 0),
        RIGHT((font, component) -> font.method_27525(component), i -> i),
        CENTER((font, component) -> font.method_27525(component) / 2, i -> i / 2);

        private final BiFunction<class_327, class_5348, Integer> textFunction;
        private final Function<Integer, Integer> integerFunction;

        private Alignment(BiFunction<class_327, class_5348, Integer> textFunction, Function<Integer, Integer> integerFunction) {
            this.textFunction = textFunction;
            this.integerFunction = integerFunction;
        }

        public int apply(class_327 font, class_5348 component) {
            return this.textFunction.apply(font, component);
        }

        public int apply(int width) {
            return this.integerFunction.apply(width);
        }
    }
}

