/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_572;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.fabric.RenderUtilsImpl;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderUtils {
    public static boolean vanillaModel(Avatar avatar) {
        return avatar != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static boolean vanillaModelAndScript(Avatar avatar) {
        return avatar != null && avatar.luaRuntime != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static class_1058 firstFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        class_2960 layer = avatar.luaRuntime.renderer.fireLayer1;
        return layer != null ? (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(layer) : null;
    }

    public static class_1058 secondFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        class_2960 layer1 = avatar.luaRuntime.renderer.fireLayer1;
        class_2960 layer2 = avatar.luaRuntime.renderer.fireLayer2;
        if (layer2 != null) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(layer2);
        }
        if (layer1 != null) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(layer1);
        }
        return null;
    }

    public static VanillaPart partFromSlot(Avatar avatar, class_1304 equipmentSlot) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (equipmentSlot) {
            case class_1304.field_6169 -> avatar.luaRuntime.vanilla_model.HELMET;
            case class_1304.field_6174 -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case class_1304.field_6172 -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case class_1304.field_6166 -> avatar.luaRuntime.vanilla_model.BOOTS;
            default -> null;
        };
    }

    public static VanillaPart pivotToPart(Avatar avatar, ParentType type) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (type) {
            case ParentType.HelmetPivot -> avatar.luaRuntime.vanilla_model.HELMET;
            case ParentType.ChestplatePivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case ParentType.LeftShoulderPivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE_LEFT_ARM;
            case ParentType.RightShoulderPivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE_RIGHT_ARM;
            case ParentType.LeggingsPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case ParentType.LeftLeggingPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS_LEFT_LEG;
            case ParentType.RightLeggingPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS_RIGHT_LEG;
            case ParentType.LeftBootPivot -> avatar.luaRuntime.vanilla_model.BOOTS_LEFT_LEG;
            case ParentType.RightBootPivot -> avatar.luaRuntime.vanilla_model.BOOTS_RIGHT_LEG;
            case ParentType.LeftElytraPivot -> avatar.luaRuntime.vanilla_model.LEFT_ELYTRA;
            case ParentType.RightElytraPivot -> avatar.luaRuntime.vanilla_model.RIGHT_ELYTRA;
            default -> null;
        };
    }

    public static class_1304 slotFromPart(ParentType type) {
        switch (type) {
            case HelmetPivot: 
            case Head: 
            case HelmetItemPivot: 
            case Skull: {
                return class_1304.field_6169;
            }
            case ChestplatePivot: 
            case LeftShoulderPivot: 
            case RightShoulderPivot: 
            case LeftElytraPivot: 
            case RightElytraPivot: 
            case Body: 
            case LeftElytra: 
            case RightElytra: {
                return class_1304.field_6174;
            }
            case LeftArm: 
            case LeftItemPivot: 
            case LeftSpyglassPivot: {
                return class_1304.field_6171;
            }
            case RightArm: 
            case RightItemPivot: 
            case RightSpyglassPivot: {
                return class_1304.field_6173;
            }
            case LeggingsPivot: 
            case LeftLeggingPivot: 
            case RightLeggingPivot: 
            case LeftLeg: 
            case RightLeg: {
                return class_1304.field_6172;
            }
            case LeftBootPivot: 
            case RightBootPivot: {
                return class_1304.field_6166;
            }
        }
        return null;
    }

    public static boolean renderArmItem(Avatar avatar, boolean lefty, CallbackInfo ci) {
        if (!RenderUtils.vanillaModel(avatar)) {
            return false;
        }
        if (avatar.luaRuntime != null && (lefty && !avatar.luaRuntime.vanilla_model.LEFT_ITEM.checkVisible() || !lefty && !avatar.luaRuntime.vanilla_model.RIGHT_ITEM.checkVisible())) {
            ci.cancel();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends class_1309, M extends class_572<T>, A extends class_572<T>> class_2960 getArmorResource(class_1297 entity, class_1799 stack, class_1738 item, class_1304 slot, boolean isInner, class_1741.class_9196 armormaterial$layer) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RenderUtilsImpl.getArmorResource(entity, (class_1799)var1_1, (class_1738)var2_2, (class_1304)var3_3, (boolean)var4_4, (class_1741.class_9196)var5_5);
    }
}

