/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2240;
import net.minecraft.class_2246;
import net.minecraft.class_2257;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_9267;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.json.FiguraJsonSerializer;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.math.vector.FiguraVector;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaUtils {
    public static Object[] parseVec(String methodName, int[] vectorSizes, double[] defaultValues, Class<?>[] expectedReturns, Object ... args) {
        ArrayList<Object> ret = new ArrayList<Object>(args.length);
        int i = 0;
        for (int size : vectorSizes) {
            Object object = args[i];
            if (object instanceof FiguraVector) {
                FiguraVector vec = (FiguraVector)object;
                if (vec.size() != size) {
                    throw new LuaError("Illegal argument at position " + (i + 1) + " to " + methodName + "(): Expected Vector" + size + ", recieved Vector" + vec.size());
                }
                ret.add(vec);
                ++i;
                continue;
            }
            if (args[i] == null || args[i] instanceof Number) {
                double[] vec = new double[size];
                for (int o = 0; o < size; ++o) {
                    Object object2 = args[i + o];
                    if (object2 instanceof Number) {
                        Number n = (Number)object2;
                        vec[o] = n.doubleValue();
                        continue;
                    }
                    if (args[i + o] == null) {
                        vec[o] = defaultValues[o];
                        continue;
                    }
                    throw new LuaError("Illegal argument at position " + (i + o + 1) + " to " + methodName + "(): Expected Number, recieved " + args[i + o].getClass().getSimpleName() + " (" + String.valueOf(args[i + o]) + ")");
                }
                ret.add(switch (size) {
                    case 2 -> FiguraVec2.of(vec[0], vec[1]);
                    case 3 -> FiguraVec3.of(vec[0], vec[1], vec[2]);
                    case 4 -> FiguraVec4.of(vec[0], vec[1], vec[2], vec[3]);
                    default -> throw new IllegalArgumentException("Illegal vector size: " + size);
                });
                i += size;
                continue;
            }
            if (args[i] == null) {
                ret.add(switch (size) {
                    case 2 -> FiguraVec2.of(defaultValues[0], defaultValues[1]);
                    case 3 -> FiguraVec3.of(defaultValues[0], defaultValues[1], defaultValues[2]);
                    case 4 -> FiguraVec4.of(defaultValues[0], defaultValues[1], defaultValues[2], defaultValues[3]);
                    default -> throw new IllegalArgumentException("Illegal vector size: " + size);
                });
                ++i;
                continue;
            }
            throw new LuaError("Illegal argument at position " + (i + 1) + " to " + methodName + "(): Expected Vector" + size + " or Number, recieved " + args[i].getClass().getSimpleName() + " (" + String.valueOf(args[i]) + ")");
        }
        for (int o = i; o < args.length; ++o) {
            if (args[o] != null && o - i < expectedReturns.length && !expectedReturns[o - i].isAssignableFrom(args[o].getClass())) {
                throw new LuaError("Illegal argument at position " + (o + 1) + " to " + methodName + "(): Expected " + expectedReturns[o - i].getSimpleName() + ", recieved " + args[o].getClass().getSimpleName() + " (" + String.valueOf(args[o]) + ")");
            }
            ret.add(args[o]);
        }
        return ret.toArray();
    }

    public static Object[] parseVec(String methodName, int[] vectorSizes, Class<?>[] expectedReturns, Object ... args) {
        return LuaUtils.parseVec(methodName, vectorSizes, new double[]{0.0, 0.0, 0.0, 0.0}, expectedReturns, args);
    }

    public static FiguraVec2 parseVec2(String methodName, Object x, Number y) {
        return LuaUtils.parseVec2(methodName, x, y, 0.0, 0.0);
    }

    public static FiguraVec2 parseVec2(String methodName, Object x, Number y, double defaultX, double defaultY) {
        if (x instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            return FiguraVec2.of(((Number)x).doubleValue(), y.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static FiguraVec3 parseVec3(String methodName, Object x, Number y, Number z) {
        return LuaUtils.parseVec3(methodName, x, y, z, 0.0, 0.0, 0.0);
    }

    public static FiguraVec3 parseVec3(String methodName, Object x, Number y, Number z, double defaultX, double defaultY, double defaultZ) {
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            if (z == null) {
                z = defaultZ;
            }
            return FiguraVec3.of(((Number)x).doubleValue(), y.doubleValue(), z.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static FiguraVec3 parseOneArgVec(String methodName, Object x, Number y, Number z, double defaultArg) {
        double d;
        if (x instanceof Number) {
            Number n = (Number)x;
            d = n.doubleValue();
        } else {
            d = defaultArg;
        }
        double d2 = d;
        return LuaUtils.parseVec3(methodName, x, y, z, d2, d2, d2);
    }

    public static FiguraVec3 nullableVec3(String methodName, Object x, Number y, Number z) {
        return x == null ? null : LuaUtils.parseVec3(methodName, x, y, z);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<FiguraVec3, FiguraVec3> parse2Vec3(String methodName, Object x, Object y, Number z, Object w, Number t, Number h, int xIndex) {
        FiguraVec3 b;
        FiguraVec3 a;
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec1 = (FiguraVec3)x;
            a = vec1.copy();
            if (y instanceof FiguraVec3) {
                FiguraVec3 vec2 = (FiguraVec3)y;
                b = vec2.copy();
                return Pair.of((Object)a, (Object)b);
            } else {
                if (y != null && !(y instanceof Number)) throw new LuaError("Illegal argument at position " + xIndex + "1 to " + methodName + "(): " + String.valueOf(y));
                if (w != null && !(w instanceof Number)) throw new LuaError("Illegal argument at position" + xIndex + "3to " + methodName + "(): " + String.valueOf(w));
                b = LuaUtils.parseVec3(methodName, y, z, (Number)w);
            }
            return Pair.of((Object)a, (Object)b);
        } else {
            if ((!(x instanceof Number) || y != null) && !(y instanceof Number)) throw new LuaError("Illegal argument at position " + xIndex + " to " + methodName + "(): " + String.valueOf(x));
            a = LuaUtils.parseVec3(methodName, x, (Number)y, z);
            if (w instanceof FiguraVec3) {
                FiguraVec3 vec1 = (FiguraVec3)w;
                b = vec1.copy();
                return Pair.of((Object)a, (Object)b);
            } else {
                if (w != null && !(w instanceof Number)) throw new LuaError("Illegal argument at position " + xIndex + "3 to " + methodName + "(): " + String.valueOf(w));
                b = LuaUtils.parseVec3(methodName, w, t, h);
            }
        }
        return Pair.of((Object)a, (Object)b);
    }

    public static Pair<FiguraVec3, Object[]> parseVec3(String methodName, Class<?>[] expectedReturns, Object ... args) {
        Object[] parsed = LuaUtils.parseVec(methodName, new int[]{3}, expectedReturns, args);
        return Pair.of((Object)((FiguraVec3)parsed[0]), (Object)Arrays.copyOfRange(parsed, 1, parsed.length));
    }

    public static Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> parse2Vec3(String methodName, Class<?>[] expectedReturns, Object ... args) {
        Object[] parsed = LuaUtils.parseVec(methodName, new int[]{3, 3}, expectedReturns, args);
        return Pair.of((Object)Pair.of((Object)((FiguraVec3)parsed[0]), (Object)((FiguraVec3)parsed[1])), (Object)Arrays.copyOfRange(parsed, 2, parsed.length));
    }

    public static FiguraVec4 parseVec4(String methodName, Object x, Number y, Number z, Number w, double defaultX, double defaultY, double defaultZ, double defaultW) {
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)x;
            return FiguraVec4.of(vec.x, vec.y, vec.z, defaultW);
        }
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            if (z == null) {
                z = defaultZ;
            }
            if (w == null) {
                w = defaultW;
            }
            return FiguraVec4.of(((Number)x).doubleValue(), y.doubleValue(), z.doubleValue(), w.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static ItemStackAPI parseItemStackMap(String methodName, Object item) {
        if (item == null) {
            return new ItemStackAPI(class_1799.field_8037);
        }
        if (item instanceof ItemStackAPI) {
            ItemStackAPI wrapper = (ItemStackAPI)item;
            return wrapper.copy();
        }
        if (item instanceof String) {
            String string = (String)item;
            try {
                boolean oldLogic;
                class_1937 level = WorldAPI.getCurrentWorld();
                boolean bl = string.contains("{") && string.contains("[") ? string.indexOf("{") < string.indexOf("[") && !string.contains("minecraft:attribute_modifiers") : (oldLogic = string.contains("{"));
                if (oldLogic) {
                    String tagStr = string.substring(string.indexOf("{"));
                    class_2487 nbtItem = new class_2522(new StringReader(tagStr)).method_10727();
                    class_2487 tag = new class_2487();
                    tag.method_10582("id", class_2960.method_12835((StringReader)new StringReader(string)).toString());
                    tag.method_10569("Count", 1);
                    tag.method_10566("tag", (class_2520)nbtItem);
                    Dynamic ops = new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag);
                    Optional optionalItemStackData = class_9267.class_9268.method_57257((Dynamic)ops);
                    if (optionalItemStackData.isPresent()) {
                        class_9267.class_9268 data = (class_9267.class_9268)optionalItemStackData.get();
                        class_9267.method_57211((class_9267.class_9268)data, (Dynamic)data.field_49204);
                        class_1799 stack = class_1799.method_57360((class_7225.class_7874)level.method_30349(), (class_2520)((class_2520)data.method_57256().cast((DynamicOps)class_2509.field_11560))).orElse(class_2287.method_9776((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9778(new StringReader(string)).method_9781(1, false));
                        LuaTable table = new LuaTable();
                        for (String key : nbtItem.method_10541()) {
                            table.set(key, NbtToLua.convert(nbtItem.method_10580(key)));
                        }
                        class_2487 itemTag = NbtToLua.convertToNbt(stack.method_57353());
                        for (String key : itemTag.method_10541()) {
                            table.set(key, NbtToLua.convert(itemTag.method_10580(key)));
                        }
                        table = new ReadOnlyLuaTable((LuaValue)table);
                        return new ItemStackAPI(stack, table);
                    }
                }
                return new ItemStackAPI(class_2287.method_9776((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9778(new StringReader(string)).method_9781(1, false));
            }
            catch (Exception e) {
                throw new LuaError("Could not parse item stack from string: " + string);
            }
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(item));
    }

    public static void addLegacyNbtNames(LuaTable source, LuaTable dest) {
        LuaTable tab;
        if (!source.get("minecraft:damage").equals((Object)LuaValue.NIL)) {
            dest.set("Damage", source.get("minecraft:damage"));
        }
        if (!source.get("minecraft:repair_cost").equals((Object)LuaValue.NIL)) {
            dest.set("RepairCost", source.get("minecraft:repair_cost"));
        }
        if (!source.get("minecraft:custom_model_data").equals((Object)LuaValue.NIL)) {
            dest.set("CustomModelData", source.get("minecraft:custom_model_data"));
        }
        if (!source.get("minecraft:block_state").equals((Object)LuaValue.NIL)) {
            dest.set("BlockStateTag", source.get("minecraft:block_state"));
        }
        if (!source.get("minecraft:entity_data").equals((Object)LuaValue.NIL)) {
            dest.set("EntityTag", source.get("minecraft:entity_data"));
        }
        if (!source.get("minecraft:block_entity_data").equals((Object)LuaValue.NIL)) {
            dest.set("BlockEntityTag", source.get("minecraft:block_entity_data"));
        }
        if (!source.get("minecraft:enchantments").equals((Object)LuaValue.NIL)) {
            dest.set("Enchantments", source.get("minecraft:enchantments"));
        }
        if (!source.get("minecraft:custom_name").equals((Object)LuaValue.NIL)) {
            tab = new LuaTable();
            if (!dest.get("display").equals((Object)LuaValue.NIL)) {
                tab = (LuaTable)dest.get("display");
            }
            tab.set("Name", source.get("minecraft:custom_name"));
            dest.set("display", (LuaValue)tab);
        }
        if (!source.get("minecraft:lore").equals((Object)LuaValue.NIL)) {
            tab = new LuaTable();
            if (!dest.get("display").equals((Object)LuaValue.NIL)) {
                tab = (LuaTable)dest.get("display");
            }
            tab.set("Lore", source.get("minecraft:lore"));
            dest.set("display", (LuaValue)tab);
        }
        if (!source.get("minecraft:dyed_color").equals((Object)LuaValue.NIL) && !source.get("minecraft:dyed_color").get("rgb").equals((Object)LuaValue.NIL)) {
            tab = new LuaTable();
            if (!dest.get("display").equals((Object)LuaValue.NIL)) {
                tab = (LuaTable)dest.get("display");
            }
            tab.set("color", source.get("minecraft:dyed_color").get("rgb"));
            dest.set("display", (LuaValue)tab);
        }
        if (!source.get("minecraft:map_color").equals((Object)LuaValue.NIL)) {
            tab = new LuaTable();
            if (!dest.get("display").equals((Object)LuaValue.NIL)) {
                tab = (LuaTable)dest.get("display");
            }
            tab.set("MapColor", source.get("minecraft:map_color"));
            dest.set("display", (LuaValue)tab);
        }
        if (!source.get("minecraft:stored_enchantments").equals((Object)LuaValue.NIL)) {
            dest.set("StoredEnchantments", source.get("minecraft:stored_enchantments"));
        }
        if (!source.get("minecraft:trim").equals((Object)LuaValue.NIL)) {
            dest.set("Trim", source.get("minecraft:trim"));
        }
        if (!source.get("minecraft:charged_projectiles").equals((Object)LuaValue.NIL)) {
            dest.set("ChargedProjectiles", source.get("minecraft:charged_projectiles"));
        }
        if (!source.get("minecraft:bundle_contents").equals((Object)LuaValue.NIL)) {
            dest.set("Items", source.get("minecraft:bundle_contents"));
        }
        if (!source.get("minecraft:map_id").equals((Object)LuaValue.NIL)) {
            dest.set("Map", source.get("minecraft:map_id"));
        }
        if (!source.get("minecraft:suspicious_stew_effects").equals((Object)LuaValue.NIL)) {
            dest.set("effects", source.get("minecraft:suspicious_stew_effects"));
        }
        if (!source.get("minecraft:debug_stick_state").equals((Object)LuaValue.NIL)) {
            dest.set("DebugProperty", source.get("minecraft:debug_stick_state"));
        }
        if (!source.get("minecraft:bucket_entity_data").equals((Object)LuaValue.NIL)) {
            for (LuaValue key : ((LuaTable)source.get("minecraft:bucket_entity_data")).keys()) {
                dest.set(key, source.get("minecraft:bucket_entity_data").get(key));
            }
        }
        if (!source.get("minecraft:instrument").equals((Object)LuaValue.NIL)) {
            dest.set("instrument", source.get("minecraft:instrument"));
        }
        if (!source.get("minecraft:recipes").equals((Object)LuaValue.NIL)) {
            dest.set("recipes", source.get("minecraft:recipes"));
        }
        if (!source.get("minecraft:profile").equals((Object)LuaValue.NIL)) {
            tab = new LuaTable();
            if (!source.get("minecraft:profile").get("id").equals((Object)LuaValue.NIL)) {
                tab.set("Id", source.get("minecraft:profile").get("id"));
            }
            if (!source.get("minecraft:profile").get("name").equals((Object)LuaValue.NIL)) {
                tab.set("Name", source.get("minecraft:profile").get("name"));
            }
            if (!source.get("minecraft:profile").get("properties").equals((Object)LuaValue.NIL)) {
                LuaTable properties = (LuaTable)source.get("minecraft:profile").get("properties");
                LuaTable property = new LuaTable();
                LuaTable textures = new LuaTable();
                for (LuaValue key : properties.keys()) {
                    LuaTable current = (LuaTable)properties.get(key);
                    LuaTable texture = new LuaTable();
                    if (!current.get("value").equals((Object)LuaValue.NIL)) {
                        texture.set("Value", current.get("value"));
                    }
                    if (!current.get("signature").equals((Object)LuaValue.NIL)) {
                        texture.set("Signature", current.get("signature"));
                    }
                    if (!current.get("name").equals((Object)LuaValue.NIL)) {
                        texture.set("Name", current.get("name"));
                    }
                    textures.set(key, (LuaValue)texture);
                }
                property.set("textures", (LuaValue)textures);
                tab.set("Properties", (LuaValue)property);
            }
            dest.set("SkullOwner", (LuaValue)tab);
        }
    }

    public static class_1799 parseItemStack(String methodName, Object item) {
        return LuaUtils.parseItemStackMap((String)methodName, (Object)item).itemStack;
    }

    public static class_2680 parseBlockState(String methodName, Object block) {
        if (block == null) {
            return class_2246.field_10124.method_9564();
        }
        if (block instanceof BlockStateAPI) {
            BlockStateAPI wrapper = (BlockStateAPI)block;
            return wrapper.blockState;
        }
        if (block instanceof String) {
            String string = (String)block;
            try {
                class_1937 level = WorldAPI.getCurrentWorld();
                return class_2257.method_9653((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9654(new StringReader(string)).method_9494();
            }
            catch (Exception e) {
                throw new LuaError("Could not parse block state from string: " + string);
            }
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(block));
    }

    public static class_2960 parsePath(String path) {
        DataResult res = class_2960.method_29186((String)path);
        return (class_2960)res.getOrThrow(s -> {
            throw new LuaError(s);
        });
    }

    public static Object[] parseBlockHitResult(class_239 hitResult) {
        if (hitResult instanceof class_3965) {
            class_3965 blockHit = (class_3965)hitResult;
            class_2338 pos = blockHit.method_17777();
            return new Object[]{new BlockStateAPI(WorldAPI.getCurrentWorld().method_8320(pos), pos), FiguraVec3.fromVec3(blockHit.method_17784()), blockHit.method_17780().method_10151()};
        }
        return null;
    }

    public static int parseSlot(Object slot, class_1661 inventory) {
        if (slot instanceof String) {
            String s = (String)slot;
            try {
                return class_2240.method_9473().method_9470(new StringReader(s));
            }
            catch (Exception e) {
                throw new LuaError("Unable to get slot \"" + String.valueOf(slot) + "\"");
            }
        }
        if (slot instanceof Integer) {
            Integer i = (Integer)slot;
            if (i == -1 && inventory != null) {
                return inventory.method_7376();
            }
            return i;
        }
        throw new LuaError("Invalid type for getSlot: " + slot.getClass().getSimpleName());
    }

    public static JsonElement asJsonValue(LuaValue value) {
        Object object;
        if (value.isnil()) {
            return JsonNull.INSTANCE;
        }
        if (value.isboolean()) {
            return new JsonPrimitive(Boolean.valueOf(value.checkboolean()));
        }
        if (value instanceof LuaString) {
            LuaString s = (LuaString)value;
            return new JsonPrimitive(s.checkjstring());
        }
        if (value.isint()) {
            return new JsonPrimitive((Number)value.checkint());
        }
        if (value.isnumber()) {
            return new JsonPrimitive((Number)value.checkdouble());
        }
        if (value.istable()) {
            LuaTable table = value.checktable();
            if (LuaUtils.checkTableArray(table) && table.length() > 0) {
                JsonArray arr = new JsonArray();
                LuaValue[] keys = table.keys();
                int arrayLength = keys[keys.length - 1].checkint();
                for (int i = 1; i <= arrayLength; ++i) {
                    arr.add(LuaUtils.asJsonValue(table.get(i)));
                }
                return arr;
            }
            JsonObject object2 = new JsonObject();
            for (LuaValue key : table.keys()) {
                object2.add(key.tojstring(), LuaUtils.asJsonValue(table.get(key)));
            }
            return object2;
        }
        if (value.isuserdata() && (object = value.checkuserdata()) instanceof FiguraJsonSerializer.JsonValue) {
            FiguraJsonSerializer.JsonValue val = (FiguraJsonSerializer.JsonValue)object;
            return val.getElement();
        }
        return null;
    }

    public static boolean checkTableArray(LuaTable table) {
        for (LuaValue key : table.keys()) {
            if (key.isnumber()) continue;
            return false;
        }
        return true;
    }
}

