/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_3259;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.utils.IOUtils;

public class FiguraRuntimeResources {
    private static String ASSETS_VERSION;
    public static final class_3259 PACK;
    private static CompletableFuture<Void> future;

    public static Path getRootDirectory() {
        return IOUtils.getOrCreateDir(FiguraMod.getCacheDirectory(), "resources");
    }

    public static Path getAssetsDirectory() {
        return IOUtils.getOrCreateDir(FiguraRuntimeResources.getRootDirectory(), "assets/figura");
    }

    public static String getAssetsVersion() {
        if (ASSETS_VERSION == null) {
            ASSETS_VERSION = FiguraMod.METADATA.getCustomValueAsString("assets_version");
        }
        return ASSETS_VERSION;
    }

    public static void clearCache() {
        IOUtils.deleteFile(FiguraRuntimeResources.getRootDirectory());
    }

    public static CompletableFuture<Void> init() {
        future = CompletableFuture.runAsync(() -> {
            JsonObject hashes;
            JsonObject oldHashes;
            FiguraMod.LOGGER.info("Fetching backend resources...");
            Path hashesPath = FiguraRuntimeResources.getRootDirectory().resolve("hashes.json");
            try (BufferedReader reader = Files.newBufferedReader(hashesPath);){
                oldHashes = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception ignored) {
                oldHashes = new JsonObject();
            }
            try (InputStream stream = NetworkStuff.getResourcesHashes(FiguraRuntimeResources.getAssetsVersion());){
                byte[] bytes = stream.readAllBytes();
                String s = new String(bytes);
                hashes = JsonParser.parseString((String)s).getAsJsonObject();
                try (OutputStream fs = Files.newOutputStream(hashesPath, new OpenOption[0]);){
                    fs.write(bytes);
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to save resource hashes", (Throwable)e);
                }
            }
            catch (Exception ignored) {
                FiguraMod.LOGGER.warn("Failed to fetch backend resources");
                return;
            }
            for (Map.Entry entry : hashes.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement oldHash = oldHashes.get(key);
                try {
                    if (oldHash != null && oldHash.getAsString().equals(((JsonElement)entry.getValue()).getAsString())) continue;
                    FiguraRuntimeResources.getAndSaveResource(key);
                }
                catch (Exception e) {
                    FiguraMod.debug("Failed to download resource \"" + key + "\"", e);
                }
            }
            File assetsDirectoryFile = FiguraRuntimeResources.getAssetsDirectory().toFile();
            JsonObject directoryJsonObject = FiguraRuntimeResources.constructAssetsDirectoryJsonObject(assetsDirectoryFile.listFiles());
            for (Map.Entry entry : directoryJsonObject.entrySet()) {
                if (hashes.has((String)entry.getKey()) || ((Boolean)Configs.LOCAL_ASSETS.value).booleanValue()) continue;
                IOUtils.deleteFile(FiguraRuntimeResources.getAssetsDirectory().resolve((String)entry.getKey()));
            }
        });
        return future;
    }

    public static JsonObject constructAssetsDirectoryJsonObject(File[] files) {
        JsonObject object = new JsonObject();
        for (File file : files) {
            if (file.isDirectory()) {
                for (Map.Entry entry : FiguraRuntimeResources.constructAssetsDirectoryJsonObject(file.listFiles()).entrySet()) {
                    object.addProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                continue;
            }
            if (file.isHidden()) continue;
            object.addProperty(FiguraRuntimeResources.getAssetsDirectory().toUri().relativize(file.toURI()).getPath(), "0");
        }
        return object;
    }

    private static void getAndSaveResource(String path) throws Exception {
        if (((Boolean)Configs.LOCAL_ASSETS.value).booleanValue()) {
            return;
        }
        Path target = FiguraRuntimeResources.getAssetsDirectory().resolve(path);
        IOUtils.createDirIfNeeded(target.getParent());
        try (InputStream resource = NetworkStuff.getResource(FiguraRuntimeResources.getAssetsVersion(), path);
             OutputStream fs = Files.newOutputStream(target, new OpenOption[0]);){
            fs.write(resource.readAllBytes());
            FiguraMod.debug("Downloaded resource \"" + path + "\"", new Object[0]);
        }
    }

    public static void joinFuture() {
        if (future != null && !future.isDone()) {
            future.join();
        }
    }

    static {
        PACK = new class_3259(new class_9224("Figura runtime resource pack", (class_2561)class_2561.method_43470((String)"Figura Runtime Resources"), class_5352.field_25348, Optional.empty()), FiguraRuntimeResources.getRootDirectory());
    }
}

