/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.permissions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5250;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.Permissions;

public abstract class PermissionPack {
    public String name;
    private boolean visible = true;
    private final Map<Permissions, Integer> permissions = new HashMap<Permissions, Integer>();
    private final Map<String, Map<Permissions, Integer>> customPermissions = new HashMap<String, Map<Permissions, Integer>>();

    public PermissionPack(String name) {
        this.name = name;
    }

    public abstract class_5250 getCategoryName();

    public abstract int getColor();

    public abstract Permissions.Category getCategory();

    public abstract void setCategory(CategoryPermissionPack var1);

    public void loadNbt(class_2487 nbt) {
        class_2487 perms = nbt.method_10562("permissions");
        for (Permissions setting : Permissions.DEFAULT) {
            if (!perms.method_10545(setting.name)) continue;
            this.permissions.put(setting, perms.method_10550(setting.name));
        }
        class_2487 custom = nbt.method_10562("custom");
        for (Map.Entry<String, Collection<Permissions>> entry : PermissionManager.CUSTOM_PERMISSIONS.entrySet()) {
            String key = entry.getKey();
            HashMap<Permissions, Integer> map = new HashMap<Permissions, Integer>();
            class_2487 customNbt = custom.method_10562(key);
            for (Permissions setting : entry.getValue()) {
                if (!customNbt.method_10545(setting.name)) continue;
                map.put(setting, customNbt.method_10550(setting.name));
            }
            this.customPermissions.put(key, map);
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10582("name", this.name);
        class_2487 perms = new class_2487();
        for (Map.Entry<Permissions, Integer> entry : this.permissions.entrySet()) {
            perms.method_10569(entry.getKey().name, entry.getValue().intValue());
        }
        nbt.method_10566("permissions", (class_2520)perms);
        class_2487 custom = new class_2487();
        for (Map.Entry<String, Map<Permissions, Integer>> entry : this.customPermissions.entrySet()) {
            class_2487 customNbt = new class_2487();
            for (Map.Entry<Permissions, Integer> entry2 : entry.getValue().entrySet()) {
                customNbt.method_10569(entry2.getKey().name, entry2.getValue().intValue());
            }
            custom.method_10566(entry.getKey(), (class_2520)customNbt);
        }
        nbt.method_10566("custom", (class_2520)custom);
    }

    public int get(Permissions permissions) {
        Integer setting = this.permissions.get(permissions);
        if (setting != null) {
            return setting;
        }
        for (Map<Permissions, Integer> value : this.customPermissions.values()) {
            setting = value.get(permissions);
            if (setting == null) continue;
            return setting;
        }
        return -1;
    }

    public void insert(Permissions permissions, Integer value, String id) {
        if (Permissions.DEFAULT.contains(permissions)) {
            this.permissions.put(permissions, value);
            return;
        }
        Map map = this.customPermissions.getOrDefault(id, new HashMap());
        map.put(permissions, value);
        this.customPermissions.put(id, map);
    }

    public boolean hasChanges() {
        boolean bool;
        boolean bl = bool = !this.permissions.isEmpty();
        if (!bool) {
            for (Map<Permissions, Integer> value : this.customPermissions.values()) {
                if (value.isEmpty()) continue;
                return true;
            }
        }
        return bool;
    }

    public boolean isChanged(Permissions permissions) {
        if (this.permissions.containsKey(permissions)) {
            return true;
        }
        for (Map<Permissions, Integer> map : this.customPermissions.values()) {
            if (!map.containsKey(permissions)) continue;
            return true;
        }
        return false;
    }

    public void reset(Permissions permissions) {
        this.permissions.remove(permissions);
        for (Map<Permissions, Integer> map : this.customPermissions.values()) {
            map.remove(permissions);
        }
    }

    public void clear() {
        this.permissions.clear();
        this.customPermissions.clear();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Map<Permissions, Integer> getPermissions() {
        return this.permissions;
    }

    public Map<String, Map<Permissions, Integer>> getCustomPermissions() {
        return this.customPermissions;
    }

    public static class PlayerPermissionPack
    extends PermissionPack {
        public CategoryPermissionPack category;

        public PlayerPermissionPack(CategoryPermissionPack category, String name) {
            super(name);
            this.category = category;
        }

        @Override
        public class_5250 getCategoryName() {
            return this.category.getCategoryName();
        }

        @Override
        public int getColor() {
            return this.category.getColor();
        }

        @Override
        public Permissions.Category getCategory() {
            return this.category.getCategory();
        }

        @Override
        public void setCategory(CategoryPermissionPack newParent) {
            this.category = newParent;
        }

        @Override
        public void writeNbt(class_2487 nbt) {
            if (this.getCategory() != Permissions.Category.BLOCKED) {
                super.writeNbt(nbt);
            } else {
                nbt.method_10582("name", this.name);
            }
            nbt.method_10582("category", this.category.name);
        }

        @Override
        public int get(Permissions permissions) {
            int result = super.get(permissions);
            return result != -1 ? result : this.category.get(permissions);
        }

        @Override
        public boolean isVisible() {
            return this.category.isVisible();
        }
    }

    public static class CategoryPermissionPack
    extends PermissionPack {
        public final Permissions.Category category;

        public CategoryPermissionPack(Permissions.Category category) {
            super(category.name());
            this.category = category;
        }

        @Override
        public class_5250 getCategoryName() {
            return this.category.text.method_27661();
        }

        @Override
        public int getColor() {
            return this.category.color;
        }

        @Override
        public Permissions.Category getCategory() {
            return this.category;
        }

        @Override
        public void setCategory(CategoryPermissionPack newParent) {
        }

        @Override
        public int get(Permissions permissions) {
            int result = super.get(permissions);
            return result != -1 ? result : permissions.getDefault(this.getCategory());
        }
    }
}

