/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendertasks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.ducks.LivingEntityRendererAccessor;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.mixin.LivingEntityAccessor;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.rendertasks.RenderTask;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="EntityTask", value="entity_task")
public class EntityTask
extends RenderTask {
    @Nullable
    class_1297 entity;
    long ticksSinceEntity;

    public EntityTask(String name, Avatar owner, FiguraModelPart parent) {
        super(name, owner, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(class_4587 stack, class_4597 buffer, int light, int overlay) {
        stack.method_22905(16.0f, 16.0f, 16.0f);
        if (this.entity != null) {
            assert (class_310.method_1551().field_1687 != null);
            this.entity.field_6012 = (int)(class_310.method_1551().field_1687.method_8510() - this.ticksSinceEntity);
            class_898 dispatcher = class_310.method_1551().method_1561();
            boolean h = dispatcher.method_3958();
            dispatcher.method_3955(false);
            OptionalInt prev = LivingEntityRendererAccessor.overrideOverlay;
            LivingEntityRendererAccessor.overrideOverlay = OptionalInt.of(this.customization.overlay != null ? this.customization.overlay : overlay);
            try {
                class_310.method_1551().method_1561().method_3954(this.entity, 0.0, 0.0, 0.0, 0.0f, class_310.method_1551().method_60646().method_60637(true), stack, buffer, this.customization.light != null ? this.customization.light : light);
            }
            finally {
                LivingEntityRendererAccessor.overrideOverlay = prev;
                dispatcher.method_3955(h);
            }
        }
    }

    @Override
    public int getComplexity() {
        return 20;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.entity != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity_task.as_entity")
    public EntityAPI<?> asEntity() {
        return this.entity == null ? null : new EntityAPI<class_1297>(this.entity);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"nbt"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"id", "nbt"})}, value="entity_task.set_nbt")
    @Contract(value="_,_->this")
    public EntityTask setNbt(String nbtOrId, String nullOrNbt) {
        try {
            class_2487 finalNbt;
            if (nullOrNbt == null) {
                finalNbt = new class_2522(new StringReader(nbtOrId)).method_10727();
                if (!finalNbt.method_10573("id", 8)) {
                    throw new LuaError("Nbt must contain id");
                }
            } else {
                finalNbt = new class_2522(new StringReader(nullOrNbt)).method_10727();
                finalNbt.method_10566("id", (class_2520)class_2519.method_23256((String)nbtOrId));
            }
            assert (class_310.method_1551().field_1687 != null);
            this.entity = class_1299.method_17842((class_2487)finalNbt, (class_1937)class_310.method_1551().field_1687, Function.identity());
            if (this.entity == null) {
                throw new LuaError("Could not create entity");
            }
            this.ticksSinceEntity = class_310.method_1551().field_1687.method_8510() - (long)this.entity.field_6012;
        }
        catch (CommandSyntaxException e) {
            throw new LuaError(e.getMessage());
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"distance"})}, value="entity_task.update_walking_distance")
    @Contract(value="_->this")
    public EntityTask updateWalkingDistance(float distance) {
        class_1297 class_12972;
        if (this.entity != null && (class_12972 = this.entity) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            ((LivingEntityAccessor)living).invokeUpdateWalkAnimation(distance);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"rotation"})}, value="entity_task.set_head_rotation")
    @Contract(value="_->this")
    public EntityTask setHeadRotation(FiguraVec2 vec2) {
        class_1297 class_12972;
        if (this.entity != null && (class_12972 = this.entity) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            living.field_6241 = (float)vec2.y;
            living.field_6259 = (float)vec2.y;
            living.method_36457((float)vec2.x);
            living.field_6004 = (float)vec2.x;
        }
        return this;
    }
}

