/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendering;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.VanillaModelData;
import org.figuramc.figura.model.rendering.PartFilterScheme;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AvatarRenderer {
    protected final Avatar avatar;
    public FiguraModelPart root;
    protected final Map<ParentType, List<FiguraModelPart>> separatedParts = new ConcurrentHashMap<ParentType, List<FiguraModelPart>>();
    protected boolean isRendering;
    protected boolean dirty;
    public class_1297 entity;
    public float yaw;
    public float tickDelta;
    public int light;
    public int overlay;
    public float alpha;
    public boolean translucent;
    public boolean glowing;
    public FiguraMat4 posMat = FiguraMat4.of();
    public FiguraMat3 normalMat = FiguraMat3.of();
    public class_4597 bufferSource;
    public VanillaModelData vanillaModelData = new VanillaModelData();
    public PartFilterScheme currentFilterScheme;
    public final HashMap<ParentType, ConcurrentLinkedQueue<Pair<FiguraMat4, FiguraMat3>>> pivotCustomizations = new HashMap(ParentType.values().length);
    protected final List<FiguraTextureSet> textureSets = new ArrayList<FiguraTextureSet>();
    public final HashMap<String, FiguraTexture> textures = new HashMap();
    public final HashMap<String, FiguraTexture> customTextures = new HashMap();
    protected static int shouldRenderPivots;
    public boolean allowMatrixUpdate = false;
    public boolean allowHiddenTransforms = true;
    public boolean interceptRendersIntoFigura = true;
    public boolean allowPivotParts = true;
    public boolean updateLight = false;
    public boolean doIrisEmissiveFix = false;
    public boolean offsetRenderLayers = false;
    public boolean ignoreVanillaVisibility = false;
    public FiguraModelPart itemToRender;

    public AvatarRenderer(Avatar avatar) {
        this.avatar = avatar;
        class_2487 nbt = avatar.nbt.method_10562("textures");
        class_2487 src = nbt.method_10562("src");
        for (String key : src.method_10541()) {
            byte[] bytes = src.method_10547(key);
            if (bytes.length > 0) {
                this.textures.put(key, new FiguraTexture(avatar, key, bytes));
                continue;
            }
            class_2499 size = src.method_10554(key, 3);
            this.textures.put(key, new FiguraTexture(avatar, key, size.method_10600(0), size.method_10600(1)));
        }
        class_2499 texturesList = nbt.method_10554("data", 10);
        for (class_2520 t : texturesList) {
            class_2487 tag = (class_2487)t;
            this.textureSets.add(new FiguraTextureSet(this.getTextureName(tag), this.textures.get(tag.method_10558("d")), this.textures.get(tag.method_10558("e")), this.textures.get(tag.method_10558("s")), this.textures.get(tag.method_10558("n"))));
        }
        avatar.hasTexture = !texturesList.isEmpty();
    }

    private String getTextureName(class_2487 tag) {
        String s = tag.method_10558("d");
        if (!s.isEmpty()) {
            return s;
        }
        s = tag.method_10558("e");
        if (!s.isEmpty()) {
            return s.substring(0, s.length() - 2);
        }
        s = tag.method_10558("s");
        if (!s.isEmpty()) {
            return s.substring(0, s.length() - 2);
        }
        s = tag.method_10558("n");
        if (!s.isEmpty()) {
            return s.substring(0, s.length() - 2);
        }
        return "";
    }

    public FiguraTexture getTexture(String name) {
        FiguraTexture texture = this.customTextures.get(name);
        if (texture != null) {
            return texture;
        }
        for (Map.Entry<String, FiguraTexture> entry : this.textures.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public abstract int render();

    public abstract int renderSpecialParts();

    public abstract void updateMatrices();

    protected void clean() {
        for (FiguraTextureSet set : this.textureSets) {
            set.clean();
        }
        for (FiguraTexture texture : this.customTextures.values()) {
            texture.close();
        }
    }

    public void invalidate() {
        this.dirty = true;
        if (!this.isRendering) {
            this.clean();
        }
    }

    public void sortParts() {
        this.separatedParts.clear();
        this._sortParts(this.root);
    }

    private void _sortParts(FiguraModelPart part) {
        if (part.parentType.isSeparate) {
            List list = this.separatedParts.computeIfAbsent(part.parentType, parentType -> new ArrayList());
            list.add(part);
        }
        for (FiguraModelPart child : part.children) {
            this._sortParts(child);
        }
    }

    public static FiguraMat4 entityToWorldMatrix(class_1297 e, float delta) {
        float f;
        if (e instanceof class_1309) {
            class_1309 le = (class_1309)e;
            f = class_3532.method_16439((float)delta, (float)le.field_6220, (float)le.field_6283);
        } else {
            f = e.method_5705(class_310.method_1551().method_60646().method_60637(true));
        }
        double yaw = f;
        FiguraMat4 result = FiguraMat4.of();
        result.rotateX(180.0 - yaw);
        result.translate(e.method_30950(delta));
        return result;
    }

    public static double getYawOffsetRot(class_1297 e, float delta) {
        float f;
        if (e instanceof class_1309) {
            class_1309 le = (class_1309)e;
            f = class_3532.method_16439((float)delta, (float)le.field_6220, (float)le.field_6283);
        } else {
            f = e.method_5705(class_310.method_1551().method_60646().method_60637(true));
        }
        double yaw = f;
        return 180.0 - yaw;
    }

    public static FiguraMat4 worldToViewMatrix() {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        Quaternionf rot = new Quaternionf((Quaternionfc)camera.method_23767());
        rot.x *= -1.0f;
        rot.z *= -1.0f;
        Matrix3f cameraMat3f = new Matrix3f().rotate((Quaternionfc)rot);
        FiguraMat4 result = FiguraMat4.of();
        FiguraMat3 cameraMat = FiguraMat3.of().set(cameraMat3f);
        result.multiply(cameraMat.augmented());
        result.scale(-1.0, 1.0, -1.0);
        return result;
    }

    public static FiguraMat4 worldToCameraPosMatrix() {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        FiguraMat4 result = FiguraMat4.of();
        class_243 cameraPos = camera.method_19326().method_1021(-1.0);
        result.translate(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
        return result;
    }

    public void setupRenderer(PartFilterScheme currentFilterScheme, class_4597 bufferSource, class_4587 matrices, float tickDelta, int light, float alpha, int overlay, boolean translucent, boolean glowing) {
        this.setupRenderer(currentFilterScheme, bufferSource, tickDelta, light, alpha, overlay, translucent, glowing);
        this.setMatrices(matrices);
    }

    public void setupRenderer(PartFilterScheme currentFilterScheme, class_4597 bufferSource, class_4587 matrices, float tickDelta, int light, float alpha, int overlay, boolean translucent, boolean glowing, double camX, double camY, double camZ) {
        this.setupRenderer(currentFilterScheme, bufferSource, tickDelta, light, alpha, overlay, translucent, glowing);
        this.setMatrices(camX, camY, camZ, matrices);
    }

    private void setupRenderer(PartFilterScheme currentFilterScheme, class_4597 bufferSource, float tickDelta, int light, float alpha, int overlay, boolean translucent, boolean glowing) {
        this.currentFilterScheme = currentFilterScheme;
        this.bufferSource = bufferSource;
        this.tickDelta = tickDelta;
        this.light = light;
        this.alpha = alpha;
        this.overlay = overlay;
        this.translucent = translucent;
        this.glowing = glowing;
    }

    public void setMatrices(class_4587 matrices) {
        class_4587.class_4665 pose = matrices.method_23760();
        this.posMat.set(pose.method_23761());
        this.normalMat.set(pose.method_23762());
    }

    public void setMatrices(double camX, double camY, double camZ, class_4587 matrices) {
        class_4587.class_4665 pose = matrices.method_23760();
        Matrix4d posMat = new Matrix4d((Matrix4fc)pose.method_23761());
        posMat.translate(-camX, -camY, -camZ);
        posMat.scale(-1.0, -1.0, 1.0);
        this.posMat.set(posMat);
        Matrix3f normalMat = new Matrix3f((Matrix3fc)pose.method_23762());
        normalMat.scale(-1.0f, -1.0f, 1.0f);
        this.normalMat.set(normalMat);
    }
}

