/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.renderers;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.regex.Pattern;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_8646;
import net.minecraft.class_922;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.EntityRendererAccessor;
import org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.TextUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public abstract class PlayerRendererMixin
extends class_922<class_742, class_591<class_742>>
implements EntityRendererAccessor {
    @Unique
    private Avatar avatar;
    @Unique
    boolean isNameRendering;
    @Unique
    boolean hasScore;

    public PlayerRendererMixin(class_5617.class_5618 context, class_591<class_742> entityModel, float shadowRadius) {
        super(context, entityModel, shadowRadius);
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V", ordinal=1)})
    private void enableModifyPlayerName(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, float delta, CallbackInfo ci) {
        FiguraMod.popPushProfiler("name");
        this.isNameRendering = true;
    }

    @Override
    public boolean figura$isRenderingName() {
        return this.isNameRendering;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at={@At(value="TAIL")})
    private void disableModifyPlayerName(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, float delta, CallbackInfo ci) {
        this.isNameRendering = false;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/scores/Scoreboard;getDisplayObjective(Lnet/minecraft/world/scores/DisplaySlot;)Lnet/minecraft/world/scores/Objective;")})
    private void setHasScore(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, float delta, CallbackInfo ci) {
        class_269 scoreboard = player.method_7327();
        class_266 objective = scoreboard.method_1189(class_8646.field_45158);
        this.hasScore = objective != null;
    }

    @Override
    public boolean figura$hasScore() {
        return this.hasScore;
    }

    @ModifyArg(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V", ordinal=1))
    private class_2561 modifyPlayerNameText(class_2561 text, @Local(argsOnly=true) class_742 player) {
        int config = (Integer)Configs.ENTITY_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic) {
            return text;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(player.method_5667());
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean hasCustom = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        class_5250 name = class_2561.method_43470((String)text.getString());
        FiguraMod.popPushProfiler("text");
        class_5250 replacement = hasCustom && custom.getJson() != null ? custom.getJson().method_27661() : name;
        replacement = TextUtils.replaceInText((class_5348)replacement, "\\$\\{name\\}", name);
        FiguraMod.popPushProfiler("badges");
        replacement = Badges.appendBadges((class_2561)replacement, player.method_5667(), config > 1);
        FiguraMod.popPushProfiler("applyName");
        text = TextUtils.replaceInText((class_5348)text, "\\b" + Pattern.quote(player.method_5477().getString()) + "\\b", replacement);
        return text;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V")})
    private void pushProfilerForRender(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, float delta, CallbackInfo ci) {
        FiguraMod.popPushProfiler("render");
        FiguraMod.pushProfiler("scoreboard");
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at={@At(value="TAIL")})
    private void popProfiler(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, float delta, CallbackInfo ci) {
        FiguraMod.popProfiler(5);
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderNameTag(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, float delta, CallbackInfo ci) {
        boolean hasCustom;
        int config = (Integer)Configs.ENTITY_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic || this.field_4676.method_23168((class_1297)player) > 4096.0) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(player.method_5667());
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean bl = hasCustom = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        if (custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 0) {
            avatar.noPermissions.add(Permissions.NAMEPLATE_EDIT);
        } else if (avatar != null) {
            avatar.noPermissions.remove(Permissions.NAMEPLATE_EDIT);
        }
        if (hasCustom && !custom.visible) {
            ci.cancel();
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(player.method_5477().getString());
        FiguraMod.pushProfiler("nameplate");
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V")}, method={"renderHand"})
    private void onRenderHand(class_4587 stack, class_4597 multiBufferSource, int light, class_742 player, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        this.avatar = AvatarManager.getAvatarForPlayer(player.method_5667());
        if (this.avatar != null && this.avatar.luaRuntime != null) {
            VanillaGroupPart part = this.avatar.luaRuntime.vanilla_model.PLAYER;
            class_591 model = (class_591)this.method_4038();
            ((VanillaPart)part).save((class_583<?>)model);
            if (this.avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform((class_583<?>)model);
                ((VanillaPart)part).posTransform((class_583<?>)model);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderHand"})
    private void postRenderHand(class_4587 stack, class_4597 multiBufferSource, int light, class_742 player, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        float delta = class_310.method_1551().method_60646().method_60637(true);
        this.avatar.firstPersonRender(stack, multiBufferSource, (class_1657)player, (class_1007)this, arm, light, delta);
        if (this.avatar.luaRuntime != null) {
            this.avatar.luaRuntime.vanilla_model.PLAYER.restore(this.method_4038());
        }
        this.avatar = null;
    }

    @Inject(method={"setupRotations"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupRotations(class_742 entity, class_4587 poseStack, float f, float f2, float f3, float f4, CallbackInfo cir) {
        Avatar avatar = AvatarManager.getAvatar((class_1297)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && !avatar.luaRuntime.renderer.getRootRotationAllowed().booleanValue()) {
            cir.cancel();
        }
    }
}

