/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.renderers;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5348;
import net.minecraft.class_897;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.EntityRendererAccessor;
import org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.TextUtils;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_897.class})
public abstract class EntityRendererMixin<T extends class_1297>
implements EntityRendererAccessor {
    @Unique
    Avatar figura$avatar;
    @Unique
    boolean figura$hasCustomNameplate;
    @Unique
    boolean figura$enabled;
    @Unique
    EntityNameplateCustomization figura$custom;
    @Unique
    List<class_2561> figura$textList;

    @Inject(at={@At(value="HEAD")}, method={"shouldRender"}, cancellable=true)
    private void shouldRender(T entity, class_4604 frustum, double d, double e, double f, CallbackInfoReturnable<Boolean> cir) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar != null && avatar.permissions.get(Permissions.OFFSCREEN_RENDERING) == 1) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderNameTag"})
    private void setupAvatar(T entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, float delta, CallbackInfo ci) {
        this.figura$avatar = AvatarManager.getAvatar(entity);
        this.figura$custom = this.figura$avatar == null || this.figura$avatar.luaRuntime == null ? null : this.figura$avatar.luaRuntime.nameplate.ENTITY;
        this.figura$hasCustomNameplate = this.figura$custom != null && this.figura$avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        this.figura$enabled = (Integer)Configs.ENTITY_NAMEPLATE.value > 0 && !AvatarManager.panic;
        this.figura$textList = TextUtils.splitText((class_5348)text, "\n");
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V")}, method={"renderNameTag"})
    private void modifyPivot(class_4587 instance, double x, double y, double z, Operation<Void> original) {
        FiguraVec3 pivot = FiguraVec3.of(x, y, z);
        if (this.figura$enabled && this.figura$avatar != null) {
            FiguraMod.pushProfiler("pivot");
            if (this.figura$hasCustomNameplate && this.figura$custom.getPivot() != null) {
                pivot = this.figura$custom.getPivot();
            }
        }
        original.call(new Object[]{instance, pivot.x, pivot.y, pivot.z});
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", shift=At.Shift.AFTER)}, method={"renderNameTag"})
    private void modifyPos(T entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, float delta, CallbackInfo ci) {
        if (this.figura$enabled && this.figura$avatar != null) {
            FiguraMod.popPushProfiler("position");
            if (this.figura$hasCustomNameplate && this.figura$custom.getPos() != null) {
                FiguraVec3 pos = this.figura$custom.getPos();
                matrices.method_22904(pos.x, pos.y, pos.z);
            }
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V")}, method={"renderNameTag"})
    private void modifyScale(class_4587 instance, float x, float y, float z, Operation<Void> original) {
        FiguraVec3 scaleVec = FiguraVec3.of(x, y, z);
        if (this.figura$enabled && this.figura$avatar != null) {
            FiguraMod.popPushProfiler("scale");
            if (this.figura$hasCustomNameplate && this.figura$custom.getScale() != null) {
                scaleVec.multiply(this.figura$custom.getScale());
            }
        }
        original.call(new Object[]{instance, Float.valueOf((float)scaleVec.x), Float.valueOf((float)scaleVec.y), Float.valueOf((float)scaleVec.z)});
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack$Pose;pose()Lorg/joml/Matrix4f;")}, method={"renderNameTag"})
    private void setShadowMatrix(T entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, float delta, CallbackInfo ci, @Share(value="textMatrix") LocalRef<Matrix4f> textMatrix) {
        textMatrix.set((Object)matrices.method_23760().method_23761());
        if (this.figura$enabled && this.figura$avatar != null && this.figura$hasCustomNameplate && this.figura$custom.shadow) {
            matrices.method_22903();
            textMatrix.set((Object)matrices.method_23760().method_23761());
            matrices.method_22909();
        }
    }

    @WrapOperation(method={"renderNameTag"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;drawInBatch(Lnet/minecraft/network/chat/Component;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/gui/Font$DisplayMode;II)I", ordinal=0)})
    private int drawWithColor(class_327 font, class_2561 component, float x, float y, int color, boolean shadow, Matrix4f matrix4f, class_4597 multiBufferSource, class_327.class_6415 displayMode, int backgroundColor, int light, Operation<Integer> original) {
        if (this.figura$enabled && this.figura$avatar != null && this.figura$hasCustomNameplate) {
            light = this.figura$custom.light != null ? this.figura$custom.light : light;
            backgroundColor = this.figura$custom.background != null ? this.figura$custom.background : backgroundColor;
            boolean deadmau = component.getString().equals("deadmau5");
            if (this.figura$isRenderingName()) {
                int ret = 0;
                for (int i = 0; i < this.figura$textList.size(); ++i) {
                    class_2561 text1 = this.figura$textList.get(i);
                    if (text1.getString().isEmpty()) continue;
                    int line = i - this.figura$textList.size() + 1;
                    x = (float)(-font.method_27525((class_5348)text1)) / 2.0f;
                    float f = deadmau ? -10.0f : 0.0f;
                    Objects.requireNonNull(font);
                    y = f + (float)((9 + 1) * line);
                    ret = (Integer)original.call(new Object[]{font, text1, Float.valueOf(x), Float.valueOf(y), color, shadow, matrix4f, multiBufferSource, displayMode, backgroundColor, light});
                }
                return ret;
            }
            return (Integer)original.call(new Object[]{font, component, Float.valueOf(x), Float.valueOf(y), color, shadow, matrix4f, multiBufferSource, displayMode, backgroundColor, light});
        }
        return (Integer)original.call(new Object[]{font, component, Float.valueOf(x), Float.valueOf(y), color, shadow, matrix4f, multiBufferSource, displayMode, backgroundColor, light});
    }

    @WrapOperation(method={"renderNameTag"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;drawInBatch(Lnet/minecraft/network/chat/Component;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/gui/Font$DisplayMode;II)I", ordinal=1)})
    private int drawWithOutline(class_327 font, class_2561 component, float x, float y, int color, boolean shadow, Matrix4f matrix4f, class_4597 multiBufferSource, class_327.class_6415 displayMode, int backgroundColor, int light, Operation<Integer> original, @Share(value="textMatrix") LocalRef<Matrix4f> textMatrix) {
        light = this.figura$enabled && this.figura$avatar != null && this.figura$hasCustomNameplate && this.figura$custom.light != null ? this.figura$custom.light : light;
        shadow = this.figura$enabled && this.figura$avatar != null && this.figura$hasCustomNameplate ? this.figura$custom.shadow : shadow;
        boolean deadmau = component.getString().equals("deadmau5");
        if (this.figura$enabled && this.figura$avatar != null && this.figura$hasCustomNameplate && this.figura$custom.outline) {
            int outlineColor;
            int n = outlineColor = this.figura$custom.outlineColor != null ? this.figura$custom.outlineColor : 0x202020;
            if (this.figura$isRenderingName()) {
                for (int i = 0; i < this.figura$textList.size(); ++i) {
                    class_2561 text1 = this.figura$textList.get(i);
                    if (text1.getString().isEmpty()) continue;
                    int line = i - this.figura$textList.size() + 1;
                    x = (float)(-font.method_27525((class_5348)text1)) / 2.0f;
                    float f = deadmau ? -10.0f : 0.0f;
                    Objects.requireNonNull(font);
                    y = f + (float)((9 + 1) * line);
                    font.method_37296(text1.method_30937(), x, y, color, outlineColor, matrix4f, multiBufferSource, light);
                }
            } else {
                font.method_37296(component.method_30937(), x, y, color, outlineColor, matrix4f, multiBufferSource, light);
            }
            return (Integer)original.call(new Object[]{font, class_2561.method_43473(), Float.valueOf(x), Float.valueOf(y), color, shadow, textMatrix.get(), multiBufferSource, displayMode, backgroundColor, light});
        }
        if (this.figura$enabled && this.figura$avatar != null && this.figura$hasCustomNameplate && this.figura$isRenderingName()) {
            int ret = 0;
            for (int i = 0; i < this.figura$textList.size(); ++i) {
                class_2561 text1 = this.figura$textList.get(i);
                if (text1.getString().isEmpty()) continue;
                int line = i - this.figura$textList.size() + 1;
                x = (float)(-font.method_27525((class_5348)text1)) / 2.0f;
                float f = deadmau ? -10.0f : 0.0f;
                Objects.requireNonNull(font);
                y = f + (float)((9 + 1) * line);
                ret = (Integer)original.call(new Object[]{font, text1, Float.valueOf(x), Float.valueOf(y), color, shadow, textMatrix.get(), multiBufferSource, displayMode, backgroundColor, light});
            }
            return ret;
        }
        return (Integer)original.call(new Object[]{font, component, Float.valueOf(x), Float.valueOf(y), color, shadow, textMatrix.get(), multiBufferSource, displayMode, backgroundColor, light});
    }
}

