/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.gui;

import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7225;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.GuiMessageAccessor;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.TextUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class}, priority=400)
public class ChatComponentMixin {
    @Shadow
    @Final
    private class_310 field_2062;
    @Unique
    private Integer color;
    @Unique
    private int currColor;

    @ModifyVariable(index=1, at=@At(value="HEAD"), method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, argsOnly=true)
    private class_2561 modifyQueue(class_2561 value) {
        return this.modifyMessage(value);
    }

    private class_2561 modifyMessage(class_2561 message) {
        int config;
        this.color = null;
        if (AvatarManager.panic) {
            return message;
        }
        Avatar localPlayer = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (localPlayer != null) {
            TextUtils.allowScriptEvents = true;
            String json = class_2561.class_2562.method_10867((class_2561)message, (class_7225.class_7874)this.field_2062.field_1724.method_56673());
            TextUtils.allowScriptEvents = false;
            Pair<String, Integer> event = localPlayer.chatReceivedMessageEvent(message.getString(), json);
            if (event != null) {
                String newMessage = (String)event.getFirst();
                if (newMessage == null) {
                    return null;
                }
                if (!json.equals(newMessage)) {
                    TextUtils.allowScriptEvents = true;
                    message = TextUtils.tryParseJson(newMessage);
                    TextUtils.allowScriptEvents = false;
                }
                this.color = (Integer)event.getSecond();
            }
        }
        if (!FiguraMod.parseMessages) {
            return message;
        }
        if ((Integer)Configs.EMOJIS.value > 0) {
            message = Emojis.applyEmojis(message);
        }
        if ((config = ((Integer)Configs.CHAT_NAMEPLATE.value).intValue()) == 0) {
            return message;
        }
        message = TextUtils.parseLegacyFormatting((class_5348)message);
        Map<String, UUID> players = EntityUtils.getPlayerList();
        String owner = null;
        String msgString = message.getString();
        String[] split = msgString.split("\\W+");
        for (String s2 : split) {
            if (!players.containsKey(s2)) continue;
            owner = s2;
            break;
        }
        for (Map.Entry entry : players.entrySet()) {
            NameplateCustomization custom;
            String name = (String)entry.getKey();
            if (!msgString.toLowerCase(Locale.US).contains(name.toLowerCase(Locale.US))) continue;
            UUID uuid = (UUID)entry.getValue();
            boolean isOwner = name.equals(owner);
            class_5250 playerName = class_2561.method_43470((String)name);
            Avatar avatar = AvatarManager.getAvatarForPlayer(uuid);
            NameplateCustomization nameplateCustomization = custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.CHAT;
            if (custom == null && config < 2) continue;
            class_5250 replacement = custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1 ? TextUtils.replaceInText((class_5348)custom.getJson().method_27661(), "\n|\\\\n", " ") : playerName;
            replacement = TextUtils.replaceInText((class_5348)replacement, "\\$\\{name\\}", playerName);
            class_2561 emptyReplacement = Badges.appendBadges((class_2561)replacement, uuid, config > 1 && owner == null);
            emptyReplacement = TextUtils.trim((class_5348)emptyReplacement);
            String quotedName = "(?i)\\b" + Pattern.quote(name) + "\\b";
            message = TextUtils.replaceInText((class_5348)message, quotedName, emptyReplacement, (s, style) -> true, isOwner ? 1 : 0, Integer.MAX_VALUE);
            if (!isOwner) continue;
            class_2561 temp = Badges.appendBadges((class_2561)replacement, uuid, config > 1);
            temp = TextUtils.trim((class_5348)temp);
            message = TextUtils.replaceInText((class_5348)message, quotedName, temp, (s, style) -> true, 1);
        }
        return message;
    }

    @Inject(at={@At(value="HEAD")}, method={"addMessageToQueue"}, cancellable=true)
    private void addMessageQueue(class_303 guiMessage, CallbackInfo ci) {
        if (guiMessage == null || guiMessage.comp_893() == null) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addMessageToDisplayQueue"}, cancellable=true)
    private void addMessageDisplayQueue(class_303 guiMessage, CallbackInfo ci) {
        if (guiMessage == null || guiMessage.comp_893() == null) {
            ci.cancel();
        }
    }

    @ModifyArg(at=@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V"), method={"addMessageToDisplayQueue"})
    private Object addMessagesDisplayQueue(int index, Object message) {
        if (this.color != null) {
            ((GuiMessageAccessor)message).figura$setColor(this.color);
        }
        return message;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V"), method={"addMessageToQueue"})
    private Object addMessagesQueue(int index, Object message) {
        if (this.color != null) {
            ((GuiMessageAccessor)message).figura$setColor(this.color);
        }
        return message;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"render"})
    private class_303.class_7590 grabColor(class_303.class_7590 line) {
        this.currColor = ((GuiMessageAccessor)line).figura$getColor();
        return line;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0), method={"render"}, index=4)
    private int textBackgroundOnRender(int color) {
        return color + this.currColor;
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;addMessageToDisplayQueue(Lnet/minecraft/client/GuiMessage;)V"), method={"refreshTrimmedMessages"})
    private class_303 refreshMessages(class_303 message) {
        this.color = ((GuiMessageAccessor)message).figura$getColor();
        return message;
    }
}

