/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="ItemStack", value="itemstack")
public class ItemStackAPI {
    public final class_1799 itemStack;
    @LuaWhitelist
    @LuaFieldDoc(value="itemstack.id")
    public final String id;
    @LuaWhitelist
    @LuaFieldDoc(value="itemstack.tag")
    public final LuaTable tag;

    public static ItemStackAPI verify(class_1799 itemStack) {
        if (itemStack == null || itemStack == class_1799.field_8037) {
            itemStack = class_1802.field_8162.method_7854();
        }
        return new ItemStackAPI(itemStack);
    }

    public ItemStackAPI(class_1799 itemStack, LuaTable tag) {
        this.itemStack = itemStack;
        this.id = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        this.tag = tag;
    }

    public ItemStackAPI(class_1799 itemStack) {
        this.itemStack = itemStack;
        this.id = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        LuaTable tag = itemStack.method_57353() != class_9323.field_49584 ? (LuaTable)NbtToLua.convert((class_2520)NbtToLua.convertToNbt(itemStack.method_57353())) : new LuaTable();
        LuaUtils.addLegacyNbtNames(tag, tag);
        this.tag = new ReadOnlyLuaTable((LuaValue)tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_id")
    public String getID() {
        return this.id;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_tag")
    public LuaTable getTag() {
        return this.tag;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_count")
    public int getCount() {
        return this.itemStack.method_7947();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_damage")
    public int getDamage() {
        return this.itemStack.method_7919();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_pop_time")
    public int getPopTime() {
        return this.itemStack.method_7965();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.has_glint")
    public boolean hasGlint() {
        return this.itemStack.method_7958();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        class_2378 registry = WorldAPI.getCurrentWorld().method_30349().method_30530(class_7924.field_41197);
        Optional key = registry.method_29113((Object)this.itemStack.method_7909());
        if (key.isEmpty()) {
            return list;
        }
        for (class_6862 itemTagKey : registry.method_40290((class_5321)key.get()).method_40228().toList()) {
            list.add(itemTagKey.comp_327().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_block_item")
    public boolean isBlockItem() {
        return this.itemStack.method_7909() instanceof class_1747;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_food")
    public boolean isFood() {
        return this.itemStack.method_57353().method_57832(class_9334.field_50075);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_use_action")
    public String getUseAction() {
        return this.itemStack.method_7976().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_name")
    public String getName() {
        return this.itemStack.method_7964().getString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_max_count")
    public int getMaxCount() {
        return this.itemStack.method_7914();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_rarity")
    public String getRarity() {
        return this.itemStack.method_7932().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_enchantable")
    public boolean isEnchantable() {
        return this.itemStack.method_7923();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_max_damage")
    public int getMaxDamage() {
        return this.itemStack.method_7936();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_damageable")
    public boolean isDamageable() {
        return this.itemStack.method_7963();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_stackable")
    public boolean isStackable() {
        return this.itemStack.method_7946();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_repair_cost")
    public int getRepairCost() {
        return this.itemStack != null && this.itemStack != class_1799.field_8037 && this.itemStack.method_57353().method_57832(class_9334.field_49639) ? (Integer)this.itemStack.method_57824(class_9334.field_49639) : 0;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_use_duration")
    public int getUseDuration() {
        return this.itemStack.method_7935((class_1309)class_310.method_1551().field_1724);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.to_stack_string")
    public String toStackString() {
        class_1799 stack = this.itemStack;
        Object ret = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        class_2487 nbt = NbtToLua.convertToNbt(stack.method_57353());
        if (nbt != null) {
            ret = (String)ret + nbt.toString();
        }
        return ret;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_armor")
    public boolean isArmor() {
        return this.itemStack.method_7909() instanceof class_1738;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.is_tool")
    public boolean isTool() {
        return this.itemStack.method_7909() instanceof class_1766;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_equipment_slot")
    public String getEquipmentSlot() {
        return class_310.method_1551().field_1724.method_32326(this.itemStack).name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.copy")
    public ItemStackAPI copy() {
        return new ItemStackAPI(this.itemStack.method_7972(), this.tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="itemstack.get_blockstate")
    public BlockStateAPI getBlockstate() {
        BlockStateAPI blockStateAPI;
        class_1792 class_17922 = this.itemStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            blockStateAPI = new BlockStateAPI(blockItem.method_7711().method_9564(), null);
        } else {
            blockStateAPI = null;
        }
        return blockStateAPI;
    }

    @LuaWhitelist
    public boolean __eq(ItemStackAPI other) {
        if (this == other) {
            return true;
        }
        class_1799 t = this.itemStack;
        class_1799 o = other.itemStack;
        if (t.method_7947() != o.method_7947()) {
            return false;
        }
        if (!t.method_31574(o.method_7909())) {
            return false;
        }
        class_9323 tag1 = t.method_57353();
        class_9323 tag2 = o.method_57353();
        if (tag1 == null && tag2 != null) {
            return false;
        }
        return tag1 == null || tag1.equals((Object)tag2);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        if (arg == null) {
            return null;
        }
        return switch (arg) {
            case "id" -> this.id;
            case "tag" -> this.tag;
            default -> null;
        };
    }

    public String toString() {
        return this.id + " x" + this.getCount() + " (ItemStack)";
    }
}

