/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.vanilla_model;

import java.util.function.Function;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.ParentType;

@LuaWhitelist
@LuaTypeDoc(name="VanillaModelPart", value="vanilla_model_part")
public class VanillaModelPart
extends VanillaPart {
    private final ParentType parentType;
    private final Function<class_583<?>, class_630> provider;
    private float backupPosX;
    private float backupPosY;
    private float backupPosZ;
    private float backupRotX;
    private float backupRotY;
    private float backupRotZ;
    private float backupScaleX;
    private float backupScaleY;
    private float backupScaleZ;
    private boolean originVisible;
    private boolean saved;
    private final FiguraVec3 originRot = FiguraVec3.of();
    private final FiguraVec3 originPos = FiguraVec3.of();
    private final FiguraVec3 originScale = FiguraVec3.of();

    public VanillaModelPart(Avatar owner, String name, ParentType parentType, Function<class_583<?>, class_630> provider) {
        super(owner, name);
        this.parentType = parentType;
        this.provider = provider;
    }

    private class_630 getPart(class_583<?> model) {
        return this.provider == null ? null : this.provider.apply(model);
    }

    @Override
    public void save(class_583<?> model) {
        this.saved = false;
        class_630 part = this.getPart(model);
        if (part == null) {
            return;
        }
        this.originRot.set(-part.field_3654, (double)(-part.field_3675), (double)part.field_3674);
        this.originRot.scale(57.29577951308232);
        FiguraVec3 pivot = this.parentType.offset.copy();
        pivot.subtract(part.field_3657, part.field_3656, part.field_3655);
        pivot.multiply(1.0, -1.0, -1.0);
        this.originPos.set(pivot);
        this.originScale.set(part.field_37938, (double)part.field_37939, (double)part.field_37940);
        this.originVisible = part.field_3665;
        this.backupPosX = part.field_3657;
        this.backupPosY = part.field_3656;
        this.backupPosZ = part.field_3655;
        this.backupRotX = part.field_3654;
        this.backupRotY = part.field_3675;
        this.backupRotZ = part.field_3674;
        this.backupScaleX = part.field_37938;
        this.backupScaleY = part.field_37939;
        this.backupScaleZ = part.field_37940;
        this.saved = true;
    }

    @Override
    public void preTransform(class_583<?> model) {
        if (!this.saved) {
            return;
        }
        class_630 part = this.getPart(model);
        if (part == null) {
            return;
        }
        if (this.pos != null) {
            part.field_3657 += (float)(-this.pos.x);
            part.field_3656 += (float)(-this.pos.y);
            part.field_3655 += (float)this.pos.z;
        }
        if (this.rot != null) {
            FiguraVec3 rot = this.rot.toRad();
            part.method_33425((float)(-rot.x), (float)(-rot.y), (float)rot.z);
        }
        if (this.offsetRot != null) {
            part.method_41922(this.offsetRot.toRad().mul(-1, -1.0, 1.0).asVec3f());
        }
        if (this.scale != null) {
            part.field_37938 = (float)this.scale.x;
            part.field_37939 = (float)this.scale.y;
            part.field_37940 = (float)this.scale.z;
        }
        if (this.offsetScale != null) {
            part.method_41924(this.offsetScale.asVec3f());
        }
    }

    @Override
    public void posTransform(class_583<?> model) {
        if (this.visible == null) {
            return;
        }
        class_630 part = this.getPart(model);
        if (part != null) {
            part.field_3665 = this.visible;
        }
    }

    @Override
    public void restore(class_583<?> model) {
        class_630 part = this.getPart(model);
        if (part == null) {
            return;
        }
        part.field_3665 = this.originVisible;
        if (!this.saved) {
            return;
        }
        part.field_3657 = this.backupPosX;
        part.field_3656 = this.backupPosY;
        part.field_3655 = this.backupPosZ;
        part.field_3654 = this.backupRotX;
        part.field_3675 = this.backupRotY;
        part.field_3674 = this.backupRotZ;
        part.field_37938 = this.backupScaleX;
        part.field_37939 = this.backupScaleY;
        part.field_37940 = this.backupScaleZ;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_visible")
    public boolean getOriginVisible() {
        return this.originVisible;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_rot")
    public FiguraVec3 getOriginRot() {
        return this.originRot.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_pos")
    public FiguraVec3 getOriginPos() {
        return this.originPos.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_scale")
    public FiguraVec3 getOriginScale() {
        return this.originScale.copy();
    }

    @Override
    public String toString() {
        return "VanillaModelPart";
    }
}

