/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1934;
import net.minecraft.class_2520;
import net.minecraft.class_268;
import net.minecraft.class_640;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.utils.EntityUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;

@LuaWhitelist
@LuaTypeDoc(name="PlayerAPI", value="player")
public class PlayerAPI
extends LivingEntityAPI<class_1657> {
    private class_640 playerInfo;

    public PlayerAPI(class_1657 entity) {
        super(entity);
    }

    private boolean checkPlayerInfo() {
        if (this.playerInfo != null) {
            return true;
        }
        class_640 info = EntityUtils.getPlayerInfo(((class_1657)this.entity).method_5667());
        if (info == null) {
            return false;
        }
        this.playerInfo = info;
        return true;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_food")
    public int getFood() {
        this.checkEntity();
        return ((class_1657)this.entity).method_7344().method_7586();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_saturation")
    public float getSaturation() {
        this.checkEntity();
        return ((class_1657)this.entity).method_7344().method_7589();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_exhaustion")
    public float getExhaustion() {
        this.checkEntity();
        return ((class_1657)this.entity).method_7344().method_35219();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_experience_progress")
    public float getExperienceProgress() {
        this.checkEntity();
        return ((class_1657)this.entity).field_7510;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_experience_level")
    public int getExperienceLevel() {
        this.checkEntity();
        return ((class_1657)this.entity).field_7520;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_model_type")
    public String getModelType() {
        this.checkEntity();
        return (this.checkPlayerInfo() ? this.playerInfo.method_52810().comp_1629().method_52856().toUpperCase() : class_1068.method_4648((UUID)((class_1657)this.entity).method_5667()).comp_1629().method_52856()).toUpperCase(Locale.US);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_gamemode")
    public String getGamemode() {
        this.checkEntity();
        if (!this.checkPlayerInfo()) {
            return null;
        }
        class_1934 gamemode = this.playerInfo.method_2958();
        return gamemode == null ? null : gamemode.method_8381().toUpperCase(Locale.US);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.has_cape")
    public boolean hasCape() {
        this.checkEntity();
        return this.checkPlayerInfo() && this.playerInfo.method_52810().comp_1627() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.has_skin")
    public boolean hasSkin() {
        this.checkEntity();
        return this.checkPlayerInfo() && this.playerInfo.method_52810().comp_1626() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"part"})}, value="player.is_skin_layer_visible")
    public boolean isSkinLayerVisible(@LuaNotNil String part) {
        this.checkEntity();
        try {
            if (((String)part).equalsIgnoreCase("left_pants") || ((String)part).equalsIgnoreCase("right_pants")) {
                part = (String)part + "_leg";
            }
            return ((class_1657)this.entity).method_7348(class_1664.valueOf((String)((String)part).toUpperCase(Locale.US)));
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid player model part: " + (String)part);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.is_fishing")
    public boolean isFishing() {
        this.checkEntity();
        return ((class_1657)this.entity).field_7513 != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_charged_attack_delay")
    public float getChargedAttackDelay() {
        this.checkEntity();
        return ((class_1657)this.entity).method_7279();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"right"})}, value="player.get_shoulder_entity")
    public LuaTable getShoulderEntity(boolean right) {
        this.checkEntity();
        return new ReadOnlyLuaTable(NbtToLua.convert((class_2520)(right ? ((class_1657)this.entity).method_7308() : ((class_1657)this.entity).method_7356())));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_team_info")
    public Map<String, Object> getTeamInfo() {
        this.checkEntity();
        if (!this.checkPlayerInfo()) {
            return null;
        }
        class_268 team = this.playerInfo.method_2955();
        if (team == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", team.method_1197());
        map.put("display_name", team.method_1140().getString());
        map.put("color", team.method_1202().method_537());
        map.put("prefix", team.method_1144().getString());
        map.put("suffix", team.method_1136().getString());
        map.put("friendly_fire", team.method_1205());
        map.put("see_friendly_invisibles", team.method_1199());
        map.put("nametag_visibility", team.method_1201().field_1445);
        map.put("death_message_visibility", team.method_1200().field_1445);
        map.put("collision_rule", team.method_1203().field_1436);
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={ItemStackAPI.class, Float.class}, argumentNames={"stack", "delta"})}, value="player.get_cooldown_percent")
    public float getCooldownPercent(@LuaNotNil ItemStackAPI stack, Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(0.0f);
        }
        return ((class_1657)this.entity).method_7357().method_7905(stack.itemStack.method_7909(), delta.floatValue());
    }

    @Override
    public String toString() {
        this.checkEntity();
        return ((class_1657)this.entity).method_5477().getString() + " (Player)";
    }
}

