/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.mixin.LivingEntityAccessor;

@LuaWhitelist
@LuaTypeDoc(name="LivingEntityAPI", value="living_entity")
public class LivingEntityAPI<T extends class_1309>
extends EntityAPI<T> {
    public LivingEntityAPI(T entity) {
        super(entity);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="living_entity.get_body_yaw")
    public double getBodyYaw(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return class_3532.method_16439((float)delta.floatValue(), (float)((class_1309)this.entity).field_6220, (float)((class_1309)this.entity).field_6283);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"offhand"})}, value="living_entity.get_held_item")
    public ItemStackAPI getHeldItem(boolean offhand) {
        this.checkEntity();
        return ItemStackAPI.verify(offhand ? ((class_1309)this.entity).method_6079() : ((class_1309)this.entity).method_6047());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_item")
    public ItemStackAPI getActiveItem() {
        this.checkEntity();
        return ItemStackAPI.verify(((class_1309)this.entity).method_6030());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_item_time")
    public int getActiveItemTime() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6048();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_health")
    public float getHealth() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6032();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_max_health")
    public float getMaxHealth() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6063();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_armor")
    public float getArmor() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6096();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_death_time")
    public float getDeathTime() {
        this.checkEntity();
        return ((class_1309)this.entity).field_6213;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_arrow_count")
    public int getArrowCount() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6022();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_stinger_count")
    public int getStingerCount() {
        this.checkEntity();
        return ((class_1309)this.entity).method_21753();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_left_handed")
    public boolean isLeftHanded() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6068() == class_1306.field_6182;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_using_item")
    public boolean isUsingItem() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6115();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_hand")
    public String getActiveHand() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6058().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_climbing")
    public boolean isClimbing() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6101();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_time")
    public int getSwingTime() {
        this.checkEntity();
        return ((class_1309)this.entity).field_6279;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_swinging_arm")
    public boolean isSwingingArm() {
        this.checkEntity();
        return ((class_1309)this.entity).field_6252;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_arm")
    public String getSwingArm() {
        this.checkEntity();
        return ((class_1309)this.entity).field_6252 ? ((class_1309)this.entity).field_6266.name() : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_duration")
    public int getSwingDuration() {
        this.checkEntity();
        return ((LivingEntityAccessor)this.entity).getSwingDuration();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_absorption_amount")
    public float getAbsorptionAmount() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6067();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_sensitive_to_water")
    public boolean isSensitiveToWater() {
        this.checkEntity();
        return ((class_1309)this.entity).method_29503();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_entity_category")
    public String getEntityCategory() {
        this.checkEntity();
        class_1299 mobType = ((class_1309)this.entity).method_5864();
        if (mobType.method_20210(class_3483.field_48289)) {
            return "ARTHROPOD";
        }
        if (mobType.method_20210(class_3483.field_46232)) {
            return "UNDEAD";
        }
        if (mobType.method_20210(class_3483.field_48288)) {
            return "WATER";
        }
        if (mobType.method_20210(class_3483.field_48287)) {
            return "ILLAGER";
        }
        return "UNDEFINED";
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_gliding")
    public boolean isGliding() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6128();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_blocking")
    public boolean isBlocking() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6039();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_visually_swimming")
    public boolean isVisuallySwimming() {
        this.checkEntity();
        return ((class_1309)this.entity).method_20232();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.riptide_spinning")
    public boolean riptideSpinning() {
        this.checkEntity();
        return ((class_1309)this.entity).method_6123();
    }

    @Override
    public String toString() {
        this.checkEntity();
        return (String)(((class_1309)this.entity).method_16914() ? ((class_1309)this.entity).method_5797().getString() + " (" + this.getType() + ")" : this.getType()) + " (LivingEntity)";
    }
}

