/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1675;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6335;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.AABBInvoker;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="RaycastAPI", value="raycast")
public class RaycastAPI {
    private final Avatar owner;

    public RaycastAPI(Avatar owner) {
        this.owner = owner;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class, String.class, String.class}, argumentNames={"start", "end", "blockCastType", "fluidCastType"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class, String.class, String.class}, argumentNames={"startX", "startY", "startZ", "end", "blockCastType", "fluidCastType"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class, String.class, String.class}, argumentNames={"start", "endX", "endY", "endZ", "blockCastType", "fluidCastType"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class, String.class}, argumentNames={"startX", "startY", "startZ", "endX", "endY", "endZ", "blockCastType", "fluidCastType"})}, value="raycast.block")
    public Object[] block(Object x, Object y, Object z, Object w, Object t, Object h, String blockCastType, String fluidCastType) {
        class_3959.class_242 fluidContext;
        class_3959.class_3960 blockContext;
        Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> parseResult = LuaUtils.parse2Vec3("block", new Class[]{String.class, String.class}, x, y, z, w, t, h, blockCastType, fluidCastType);
        FiguraVec3 start = (FiguraVec3)((Pair)parseResult.getFirst()).getFirst();
        FiguraVec3 end = (FiguraVec3)((Pair)parseResult.getFirst()).getSecond();
        blockCastType = (String)((Object[])parseResult.getSecond())[0];
        fluidCastType = (String)((Object[])parseResult.getSecond())[1];
        try {
            blockContext = blockCastType != null ? class_3959.class_3960.valueOf((String)blockCastType.toUpperCase(Locale.US)) : class_3959.class_3960.field_17558;
        }
        catch (IllegalArgumentException e) {
            throw new LuaError("Invalid blockRaycastType provided");
        }
        try {
            fluidContext = fluidCastType != null ? class_3959.class_242.valueOf((String)fluidCastType.toUpperCase(Locale.US)) : class_3959.class_242.field_1348;
        }
        catch (IllegalArgumentException e) {
            throw new LuaError("Invalid fluidRaycastType provided");
        }
        class_3965 result = WorldAPI.getCurrentWorld().method_17742(new class_3959(start.asVec3(), end.asVec3(), blockContext, fluidContext, (class_1297)new class_6335(class_1299.field_33456, WorldAPI.getCurrentWorld())));
        return LuaUtils.parseBlockHitResult((class_239)result);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class, LuaFunction.class}, argumentNames={"start", "end", "predicate"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class, LuaFunction.class}, argumentNames={"startX", "startY", "startZ", "end", "predicate"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class, LuaFunction.class}, argumentNames={"start", "endX", "endY", "endZ", "predicate"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, LuaFunction.class}, argumentNames={"startX", "startY", "startZ", "endX", "endY", "endZ", "predicate"})}, value="raycast.entity")
    public Object[] entity(Object x, Object y, Object z, Object w, Object t, Double h, LuaFunction predicate) {
        Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> pair = LuaUtils.parse2Vec3("entity", new Class[]{LuaFunction.class}, x, y, z, w, t, h, predicate);
        FiguraVec3 start = (FiguraVec3)((Pair)pair.getFirst()).getFirst();
        FiguraVec3 end = (FiguraVec3)((Pair)pair.getFirst()).getSecond();
        LuaFunction fn = (LuaFunction)((Object[])pair.getSecond())[0];
        Predicate<class_1297> entityPredicate = entity -> {
            if (fn == null) {
                return true;
            }
            LuaValue result = fn.invoke(this.owner.luaRuntime.typeManager.javaToLua(EntityAPI.wrap(entity))).arg1();
            return (!result.isboolean() || result.checkboolean()) && !result.isnil();
        };
        class_3966 result = class_1675.method_18075((class_1297)new class_6335(class_1299.field_33456, WorldAPI.getCurrentWorld()), (class_243)start.asVec3(), (class_243)end.asVec3(), (class_238)new class_238(start.asVec3(), end.asVec3()), entityPredicate, (double)Double.MAX_VALUE);
        if (result != null) {
            return new Object[]{EntityAPI.wrap(result.method_17782()), FiguraVec3.fromVec3(result.method_17784())};
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class, LuaTable.class}, argumentNames={"start", "end", "aabbs"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class, LuaTable.class}, argumentNames={"startX", "startY", "startZ", "end", "aabbs"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class, LuaTable.class}, argumentNames={"start", "endX", "endY", "endZ", "aabbs"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, LuaTable.class}, argumentNames={"startX", "startY", "startZ", "endX", "endY", "endZ", "aabbs"})}, value="raycast.aabb")
    public Object[] aabb(Object x, Object y, Object z, Object w, Object t, Object h, LuaTable aabbs) {
        Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> pair = LuaUtils.parse2Vec3("aabb", new Class[]{LuaTable.class}, x, y, z, w, t, h, aabbs);
        class_243 start = ((FiguraVec3)((Pair)pair.getFirst()).getFirst()).asVec3();
        class_243 end = ((FiguraVec3)((Pair)pair.getFirst()).getSecond()).asVec3();
        aabbs = (LuaTable)((Object[])pair.getSecond())[0];
        if (aabbs == null) {
            throw new LuaError("Illegal argument to aabb(): Expected LuaTable, recieved nil");
        }
        ArrayList<class_238> aabbList = new ArrayList<class_238>();
        for (int i = 1; i <= aabbs.length(); ++i) {
            LuaValue arg = aabbs.get(i);
            if (!arg.istable()) {
                throw new LuaError("Illegal argument at array index " + i + ": Expected table, recieved " + arg.typename() + " (" + arg.toString() + ")");
            }
            LuaValue min = arg.get(1);
            if (!min.isuserdata(FiguraVec3.class)) {
                throw new LuaError("Illegal argument to AABB at array index " + i + " at index 1: Expected Vector3, recieved " + min.typename() + " (" + min.toString() + ")");
            }
            LuaValue max = arg.get(2);
            if (!max.isuserdata(FiguraVec3.class)) {
                throw new LuaError("Illegal argument to AABB at array index " + i + " at index 2: Expected Vector3, recieved " + max.typename() + " (" + max.toString() + ")");
            }
            aabbList.add(new class_238(((FiguraVec3)min.checkuserdata(FiguraVec3.class)).asVec3(), ((FiguraVec3)max.checkuserdata(FiguraVec3.class)).asVec3()));
        }
        double d = Double.MAX_VALUE;
        int index = -1;
        Pair<class_243, class_2350> result = null;
        for (int i = 0; i < aabbList.size(); ++i) {
            class_243 position;
            double e;
            class_238 box = (class_238)aabbList.get(i);
            Optional<Pair<class_243, class_2350>> optional = this.clipAABB(box, start, end);
            if (box.method_1006(start)) {
                if (!(d >= 0.0)) continue;
                index = i + 1;
                result = optional.orElse((Pair<class_243, class_2350>)Pair.of((Object)start, null));
                d = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((e = start.method_1025(position = (class_243)optional.get().getFirst())) < d) && d != 0.0) continue;
            index = i + 1;
            result = optional.get();
            d = e;
        }
        if (index == -1) {
            return null;
        }
        return new Object[]{aabbs.get(index), FiguraVec3.fromVec3((class_243)result.getFirst()), result.getSecond() != null ? ((class_2350)result.getSecond()).method_10151() : null, index};
    }

    public Optional<Pair<class_243, class_2350>> clipAABB(class_238 aabb, class_243 min, class_243 max) {
        double[] ds = new double[]{1.0};
        double d = max.field_1352 - min.field_1352;
        double e = max.field_1351 - min.field_1351;
        double f = max.field_1350 - min.field_1350;
        class_2350 direction = AABBInvoker.getDirection(aabb, min, ds, null, d, e, f);
        if (direction == null) {
            return Optional.empty();
        }
        double g = ds[0];
        return Optional.of(Pair.of((Object)min.method_1031(g * d, g * e, g * f), (Object)direction));
    }
}

