/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_276;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5630;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7591;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.GuiMessageAccessor;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.LivingEntityAccessor;
import org.figuramc.figura.mixin.gui.ChatComponentAccessor;
import org.figuramc.figura.mixin.gui.ChatScreenAccessor;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.figuramc.figura.utils.TextUtils;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="HostAPI", value="host")
public class HostAPI {
    private final Avatar owner;
    private final boolean isHost;
    private final class_310 minecraft;
    @LuaWhitelist
    @LuaFieldDoc(value="host.unlock_cursor")
    public boolean unlockCursor = false;
    public Integer chatColor;

    public HostAPI(Avatar owner) {
        this.owner = owner;
        this.minecraft = class_310.method_1551();
        this.isHost = owner.isHost;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_host")
    public boolean isHost() {
        return this.isHost;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_cursor_unlocked")
    public boolean isCursorUnlocked() {
        return this.unlockCursor;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"boolean"})}, value="host.set_unlock_cursor")
    public HostAPI setUnlockCursor(boolean bool) {
        this.unlockCursor = bool;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"timesData"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class}, argumentNames={"fadeInTime", "stayTime", "fadeOutTime"})}, aliases={"titleTimes"}, value="host.set_title_times")
    public HostAPI setTitleTimes(Object x, Double y, Double z) {
        if (!this.isHost()) {
            return this;
        }
        FiguraVec3 times = LuaUtils.parseVec3("setTitleTimes", x, y, z);
        this.minecraft.field_1705.method_34001((int)times.x, (int)times.y, (int)times.z);
        return this;
    }

    @LuaWhitelist
    public HostAPI titleTimes(Object x, Double y, Double z) {
        return this.setTitleTimes(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.clear_title")
    public HostAPI clearTitle() {
        if (this.isHost()) {
            this.minecraft.field_1705.method_34003();
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"title"}, value="host.set_title")
    public HostAPI setTitle(@LuaNotNil String text) {
        if (this.isHost()) {
            this.minecraft.field_1705.method_34004(TextUtils.tryParseJson(text));
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI title(@LuaNotNil String text) {
        return this.setTitle(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"subtitle"}, value="host.set_subtitle")
    public HostAPI setSubtitle(@LuaNotNil String text) {
        if (this.isHost()) {
            this.minecraft.field_1705.method_34002(TextUtils.tryParseJson(text));
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI subtitle(@LuaNotNil String text) {
        return this.setSubtitle(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"}), @LuaMethodOverload(argumentTypes={String.class, boolean.class}, argumentNames={"text", "animated"})}, aliases={"actionbar"}, value="host.set_actionbar")
    public HostAPI setActionbar(@LuaNotNil String text, boolean animated) {
        if (this.isHost()) {
            this.minecraft.field_1705.method_1758(TextUtils.tryParseJson(text), animated);
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI actionbar(@LuaNotNil String text, boolean animated) {
        return this.setActionbar(text, animated);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"message"})}, value="host.send_chat_message")
    public HostAPI sendChatMessage(@LuaNotNil String message) {
        if (!this.isHost() || !((Boolean)Configs.CHAT_MESSAGES.value).booleanValue()) {
            return this;
        }
        class_634 connection = this.minecraft.method_1562();
        if (connection != null) {
            connection.method_45729(message);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"command"})}, value="host.send_chat_command")
    public HostAPI sendChatCommand(@LuaNotNil String command) {
        if (!this.isHost() || !((Boolean)Configs.CHAT_MESSAGES.value).booleanValue()) {
            return this;
        }
        class_634 connection = this.minecraft.method_1562();
        if (connection != null) {
            connection.method_45730(command.startsWith("/") ? command.substring(1) : command);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"message"})}, value="host.append_chat_history")
    public HostAPI appendChatHistory(@LuaNotNil String message) {
        if (this.isHost()) {
            this.minecraft.field_1705.method_1743().method_1803(message);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"index"})}, value="host.get_chat_message")
    public Map<String, Object> getChatMessage(int index) {
        if (!this.isHost()) {
            return null;
        }
        List<class_303> messages = ((ChatComponentAccessor)this.minecraft.field_1705.method_1743()).getAllMessages();
        if (--index < 0 || index >= messages.size()) {
            return null;
        }
        class_303 message = messages.get(index);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addedTime", message.comp_892());
        TextUtils.allowScriptEvents = true;
        map.put("message", message.comp_893().getString());
        map.put("json", message.comp_893());
        TextUtils.allowScriptEvents = false;
        map.put("backgroundColor", ((GuiMessageAccessor)message).figura$getColor());
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"index"}), @LuaMethodOverload(argumentTypes={Integer.class, String.class}, argumentNames={"index", "newMessage"}), @LuaMethodOverload(argumentTypes={Integer.class, String.class, FiguraVec3.class}, argumentNames={"index", "newMessage", "backgroundColor"})}, value="host.set_chat_message")
    public HostAPI setChatMessage(int index, String newMessage, FiguraVec3 backgroundColor) {
        if (!this.isHost()) {
            return this;
        }
        List<class_303> messages = ((ChatComponentAccessor)this.minecraft.field_1705.method_1743()).getAllMessages();
        if (--index < 0 || index >= messages.size()) {
            return this;
        }
        if (newMessage == null) {
            messages.remove(index);
        } else {
            class_303 old = messages.get(index);
            class_303 neww = new class_303(this.minecraft.field_1705.method_1738(), TextUtils.tryParseJson(newMessage), null, class_7591.method_44710((String)old.comp_893().getString()));
            messages.set(index, neww);
            ((GuiMessageAccessor)neww).figura$setColor(backgroundColor != null ? ColorUtils.rgbToInt(backgroundColor) : ((GuiMessageAccessor)old).figura$getColor());
        }
        this.minecraft.field_1705.method_1743().method_1817();
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"offhand"})}, value="host.swing_arm")
    public HostAPI swingArm(boolean offhand) {
        if (this.isHost() && this.minecraft.field_1724 != null) {
            this.minecraft.field_1724.method_6104(offhand ? class_1268.field_5810 : class_1268.field_5808);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"slot"})}, value="host.get_slot")
    public ItemStackAPI getSlot(@LuaNotNil Object slot) {
        if (!this.isHost()) {
            return null;
        }
        class_1297 e = this.owner.luaRuntime.getUser();
        if (e == null || !e.method_5805()) {
            return ItemStackAPI.verify(class_1799.field_8037);
        }
        class_5630 slotAccess = e.method_32318(LuaUtils.parseSlot(slot, null));
        return ItemStackAPI.verify(slotAccess.method_32327());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"slot", "item"}), @LuaMethodOverload(argumentTypes={Integer.class, ItemStackAPI.class}, argumentNames={"slot", "item"})}, value="host.set_slot")
    public HostAPI setSlot(@LuaNotNil Object slot, Object item) {
        if (!this.isHost() || slot == null && item == null || this.minecraft.field_1761 == null || this.minecraft.field_1724 == null || !this.minecraft.field_1761.method_2920().method_8386()) {
            return this;
        }
        class_1661 inventory = this.minecraft.field_1724.method_31548();
        int index = LuaUtils.parseSlot(slot, inventory);
        class_1799 stack = LuaUtils.parseItemStack("setSlot", item);
        inventory.method_5447(index, stack);
        this.minecraft.field_1761.method_2909(stack, index + 36);
        return this;
    }

    @LuaWhitelist
    public HostAPI setBadge(int index, boolean value, boolean pride) {
        if (!this.isHost()) {
            return this;
        }
        if (!FiguraMod.debugModeEnabled()) {
            throw new LuaError("Congrats, you found this debug easter egg!");
        }
        Pair<BitSet, BitSet> badges = AvatarManager.getBadges(this.owner.owner);
        if (badges == null) {
            return this;
        }
        BitSet set = pride ? (BitSet)badges.getFirst() : (BitSet)badges.getSecond();
        set.set(index, value);
        return this;
    }

    @LuaWhitelist
    public HostAPI badge(int index, boolean value, boolean pride) {
        return this.setBadge(index, value, pride);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_chat_color")
    public Integer getChatColor() {
        return this.isHost() ? this.chatColor : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"color"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b"})}, aliases={"chatColor"}, value="host.set_chat_color")
    public HostAPI setChatColor(Object x, Double y, Double z) {
        if (this.isHost()) {
            this.chatColor = x == null ? null : Integer.valueOf(ColorUtils.rgbToInt(LuaUtils.parseVec3("setChatColor", x, y, z)));
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI chatColor(Object x, Double y, Double z) {
        return this.setChatColor(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_chat_text")
    public String getChatText() {
        class_437 class_4372;
        if (this.isHost() && (class_4372 = this.minecraft.field_1755) instanceof class_408) {
            class_408 chat = (class_408)class_4372;
            return ((ChatScreenAccessor)chat).getInput().method_1882();
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"chatText"}, value="host.set_chat_text")
    public HostAPI setChatText(@LuaNotNil String text) {
        class_437 class_4372;
        if (this.isHost() && ((Boolean)Configs.CHAT_MESSAGES.value).booleanValue() && (class_4372 = this.minecraft.field_1755) instanceof class_408) {
            class_408 chat = (class_408)class_4372;
            ((ChatScreenAccessor)chat).getInput().method_1852(text);
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI chatText(@LuaNotNil String text) {
        return this.setChatText(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_screen")
    public String getScreen() {
        if (!this.isHost() || this.minecraft.field_1755 == null) {
            return null;
        }
        return this.minecraft.field_1755.getClass().getName();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_screen_slot_count")
    public Integer getScreenSlotCount() {
        class_437 class_4372;
        if (this.isHost() && (class_4372 = this.minecraft.field_1755) instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            return screen.method_17577().field_7761.size();
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"slot"})}, value="host.get_screen_slot")
    public ItemStackAPI getScreenSlot(@LuaNotNil Object slot) {
        class_437 class_4372;
        if (!this.isHost() || !((class_4372 = this.minecraft.field_1755) instanceof class_465)) {
            return null;
        }
        class_465 screen = (class_465)class_4372;
        class_2371 slots = screen.method_17577().field_7761;
        int index = LuaUtils.parseSlot(slot, null);
        if (index < 0 || index >= slots.size()) {
            return null;
        }
        return ItemStackAPI.verify(((class_1735)slots.get(index)).method_7677());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_chat_open")
    public boolean isChatOpen() {
        return this.isHost() && this.minecraft.field_1755 instanceof class_408;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_container_open")
    public boolean isContainerOpen() {
        return this.isHost() && this.minecraft.field_1755 instanceof class_465;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"})}, value="host.screenshot")
    public FiguraTexture screenshot(@LuaNotNil String name) {
        if (!this.isHost()) {
            return null;
        }
        class_1011 img = class_318.method_1663((class_276)this.minecraft.method_1522());
        return this.owner.luaRuntime.texture.register(name, img, true);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_avatar_uploaded")
    public boolean isAvatarUploaded() {
        return this.isHost() && AvatarManager.localUploaded;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_status_effects")
    public List<Map<String, Object>> getStatusEffects() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        class_746 player = this.minecraft.field_1724;
        if (!this.isHost() || player == null) {
            return list;
        }
        for (class_1293 effect : player.method_6026()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", effect.method_5579().method_55840());
            map.put("amplifier", effect.method_5578());
            map.put("duration", effect.method_5584());
            map.put("visible", effect.method_5581());
            list.add(map);
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_clipboard")
    public String getClipboard() {
        return this.isHost() ? this.minecraft.field_1774.method_1460() : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"clipboard"}, value="host.set_clipboard")
    public HostAPI setClipboard(@LuaNotNil String text) {
        if (this.isHost()) {
            this.minecraft.field_1774.method_1455(text);
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI clipboard(@LuaNotNil String text) {
        return this.setClipboard(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_attack_charge")
    public float getAttackCharge() {
        class_746 player = this.minecraft.field_1724;
        if (this.isHost() && player != null) {
            return player.method_7261(0.0f);
        }
        return 0.0f;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_jumping")
    public boolean isJumping() {
        class_746 player = this.minecraft.field_1724;
        if (this.isHost() && player != null) {
            return ((LivingEntityAccessor)player).isJumping();
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_flying")
    public boolean isFlying() {
        class_746 player = this.minecraft.field_1724;
        if (this.isHost() && player != null) {
            return player.method_31549().field_7479;
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_reach_distance")
    public double getReachDistance() {
        return this.minecraft.field_1761 == null ? 0.0 : this.minecraft.field_1724.method_55754();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_air")
    public int getAir() {
        class_746 player = this.minecraft.field_1724;
        if (this.isHost() && player != null) {
            return player.method_5669();
        }
        return 0;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_pick_block")
    public Object[] getPickBlock() {
        return this.isHost() ? LuaUtils.parseBlockHitResult(this.minecraft.field_1765) : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_pick_entity")
    public EntityAPI<?> getPickEntity() {
        return this.isHost() && this.minecraft.field_1692 != null ? EntityAPI.wrap(this.minecraft.field_1692) : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_chat_verified")
    public boolean isChatVerified() {
        if (!this.isHost()) {
            return false;
        }
        class_634 connection = this.minecraft.method_1562();
        class_640 playerInfo = connection != null ? connection.method_2871(this.owner.owner) : null;
        return playerInfo != null && playerInfo.method_45742();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"string"})}, value="host.write_to_log")
    public void writeToLog(@LuaNotNil String string) {
        if (!this.isHost()) {
            return;
        }
        FiguraMod.LOGGER.info("[FIGURA/LUA] -- " + string);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"string"})}, value="host.warn_to_log")
    public void warnToLog(@LuaNotNil String string) {
        if (!this.isHost()) {
            return;
        }
        FiguraMod.LOGGER.warn("[FIGURA/LUA] -- " + string);
    }

    public Object __index(String arg) {
        if ("unlockCursor".equals(arg)) {
            return this.unlockCursor;
        }
        return null;
    }

    @LuaWhitelist
    public void __newindex(@LuaNotNil String key, Object value) {
        if (!"unlockCursor".equals(key)) {
            throw new LuaError("Cannot assign value on key \"" + key + "\"");
        }
        this.unlockCursor = (Boolean)value;
    }

    public String toString() {
        return "HostAPI";
    }
}

