/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.permissions;

import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.gui.widgets.StatusWidget;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;

public class PlayerStatusWidget
extends StatusWidget {
    private static final List<Function<Avatar, class_5250>> HOVER_TEXT = List.of(avatar -> FiguraText.of("gui.permissions.size").method_27693("\n\u2022 ").method_27693(MathUtils.asFileSize(avatar.fileSize)), avatar -> FiguraText.of("gui.permissions.complexity").method_27693("\n\u2022 ").method_27693(String.valueOf(avatar.complexity.pre)), avatar -> FiguraText.of("gui.permissions.init").method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.init.root", avatar.init.pre)).method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.init.entity", avatar.init.post)), avatar -> FiguraText.of("gui.permissions.tick").method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.tick.world", avatar.worldTick.pre)).method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.tick.entity", avatar.tick.pre)), avatar -> FiguraText.of("gui.permissions.render").method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.render.world", avatar.worldRender.pre)).method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.render.entity", avatar.render.pre)).method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.render.post_entity", avatar.render.post)).method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.render.post_world", avatar.worldRender.post)).method_27693("\n\u2022 ").method_10852((class_2561)FiguraText.of("gui.permissions.render.animations", avatar.animation.pre)));
    private final UUID owner;
    private Avatar avatar;

    public PlayerStatusWidget(int x, int y, int width, UUID owner) {
        super(x, y, width, HOVER_TEXT.size());
        this.setBackground(false);
        this.owner = owner;
    }

    @Override
    public void tick() {
        this.avatar = AvatarManager.getAvatarForPlayer(this.owner);
        if (this.avatar == null || this.avatar.nbt == null) {
            this.status = 0;
            return;
        }
        int n = !FiguraMod.isLocal(this.owner) ? 3 : (this.avatar.fileSize > NetworkStuff.getSizeLimit() ? 1 : (this.status = (double)this.avatar.fileSize > (double)NetworkStuff.getSizeLimit() * 0.75 ? 2 : 3));
        int complexity = this.avatar.renderer == null ? 0 : (this.avatar.complexity.pre >= this.avatar.permissions.get(Permissions.COMPLEXITY) ? 1 : 3);
        this.status += complexity << 2;
        int init = this.avatar.scriptError ? 1 : (this.avatar.luaRuntime == null ? 0 : ((double)this.avatar.init.getTotal() >= (double)this.avatar.permissions.get(Permissions.INIT_INST) * 0.75 ? 2 : 3));
        this.status += init << 4;
        int tick = this.avatar.scriptError ? 1 : (this.avatar.luaRuntime == null ? 0 : ((double)this.avatar.tick.getTotal() >= (double)this.avatar.permissions.get(Permissions.TICK_INST) * 0.75 || (double)this.avatar.worldTick.getTotal() >= (double)this.avatar.permissions.get(Permissions.WORLD_TICK_INST) * 0.75 ? 2 : 3));
        this.status += tick << 6;
        int render = this.avatar.scriptError ? 1 : (this.avatar.luaRuntime == null ? 0 : ((double)this.avatar.render.getTotal() >= (double)this.avatar.permissions.get(Permissions.RENDER_INST) * 0.75 || (double)this.avatar.worldRender.getTotal() >= (double)this.avatar.permissions.get(Permissions.WORLD_RENDER_INST) * 0.75 ? 2 : 3));
        this.status += render << 8;
    }

    @Override
    public class_2561 getTooltipFor(int i) {
        return this.avatar == null ? null : HOVER_TEXT.get(i).apply(this.avatar).method_10862((class_2583)TEXT_COLORS.get(this.status >> i * 2 & 3));
    }
}

