/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.permissions;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_922;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.lists.PlayerList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerStatusWidget;
import org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PlayerPermPackElement
extends AbstractPermPackElement {
    public static final class_2960 UNKNOWN = new FiguraIdentifier("textures/gui/unknown_portrait.png");
    private static final class_2960 BACKGROUND = new FiguraIdentifier("textures/gui/player_permissions.png");
    private static final class_2561 DC_TEXT = FiguraText.of("gui.permissions.disconnected").method_27692(class_124.field_1061);
    private final String name;
    private final class_2960 skin;
    private final UUID owner;
    private final ContextMenu context;
    private final Label nameLabel;
    private final PlayerStatusWidget status;
    public boolean disconnected = false;
    public boolean dragged = false;
    public int anchorX;
    public int anchorY;
    public int initialY;
    public int index;

    public PlayerPermPackElement(int width, String name, PermissionPack pack, class_2960 skin, UUID owner, PlayerList parent) {
        super(width, 40, pack, parent);
        this.name = name;
        this.skin = skin;
        this.owner = owner;
        this.context = new ContextMenu((class_364)this);
        this.nameLabel = new Label((Object)name, 0, 0, 0);
        this.status = new PlayerStatusWidget(0, 0, 70, owner);
        this.generateContext();
    }

    private void generateContext() {
        this.context.addAction((class_2561)FiguraText.of("gui.context.copy_name"), null, button -> {
            class_310.method_1551().field_1774.method_1455(this.getName());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
        this.context.addAction((class_2561)FiguraText.of("gui.context.copy_uuid"), null, button -> {
            class_310.method_1551().field_1774.method_1455(this.getOwner().toString());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
        this.context.addAction((class_2561)FiguraText.of("gui.context.reload"), null, button -> {
            AvatarManager.reloadAvatar(this.owner);
            FiguraToast.sendToast(FiguraText.of("toast.reload"));
        });
        ContextMenu permissionsContext = new ContextMenu();
        for (Permissions.Category category : Permissions.Category.values()) {
            PermissionPack.CategoryPermissionPack categoryPack = PermissionManager.CATEGORIES.get((Object)category);
            permissionsContext.addAction((class_2561)categoryPack.getCategoryName(), null, button -> {
                this.pack.setCategory(categoryPack);
                if (this.parent.selectedEntry == this) {
                    this.parent.parent.updatePermissions(this.pack);
                }
            });
        }
        this.context.addTab((class_2561)FiguraText.of("gui.context.set_permissions"), null, permissionsContext);
    }

    public void renderDragged(class_332 gui, int mouseX, int mouseY, float delta) {
        int oX = this.method_46426();
        int oY = this.method_46427();
        this.method_46421(mouseX - (this.anchorX - oX));
        this.method_46419(mouseY - (this.anchorY - oY) + (this.initialY - oY));
        super.method_25394(gui, mouseX, mouseY, delta);
        this.method_46421(oX);
        this.method_46419(oY);
    }

    @Override
    public void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        if (this.dragged) {
            UIHelper.fillRounded(gui, this.method_46426() - 1, this.method_46427() - 1, this.method_25368() + 2, this.method_25364() + 2, 0x40FFFFFF);
        } else {
            class_4587 pose = gui.method_51448();
            int width = this.method_25368();
            int height = this.method_25364();
            pose.method_22903();
            float tx = (float)this.method_46426() + (float)width / 2.0f;
            float ty = (float)this.method_46427() + (float)height / 2.0f;
            pose.method_46416(tx, ty, 100.0f);
            pose.method_22905(this.scale, this.scale, 1.0f);
            this.animate(delta, UIHelper.getContext() == this.context && this.context.isVisible() || this.method_25405(mouseX, mouseY) || this.method_25370());
            int x = -width / 2;
            int y = -height / 2;
            mouseX = (int)(((float)mouseX - tx) / this.scale);
            mouseY = (int)(((float)mouseY - ty) / this.scale);
            if (this.parent.selectedEntry == this) {
                ArrayList<PermissionPack.CategoryPermissionPack> list = new ArrayList<PermissionPack.CategoryPermissionPack>(PermissionManager.CATEGORIES.values());
                int color = (this.dragged ? (PermissionPack)list.get(Math.min(this.index, list.size() - 1)) : this.pack).getColor();
                UIHelper.fillRounded(gui, x - 1, y - 1, width + 2, height + 2, color + -16777216);
            }
            UIHelper.renderHalfTexture(gui, x, y, width, height, 174, BACKGROUND);
            class_5250 name = null;
            boolean head = false;
            Avatar avatar = AvatarManager.getAvatarForPlayer(this.owner);
            if (avatar != null) {
                class_1309 entity;
                class_1297 e;
                NameplateCustomization custom;
                NameplateCustomization nameplateCustomization = custom = avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.LIST;
                if (custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1) {
                    name = custom.getJson().method_27661();
                }
                boolean upsideDown = (e = EntityUtils.getEntityByUUID(this.owner)) instanceof class_1309 && class_922.method_38563((class_1309)(entity = (class_1309)e));
                head = avatar.renderPortrait(gui, x + 4, y + 4, Math.round(32.0f * this.scale), 64.0f, upsideDown);
            }
            if (!head) {
                if (this.skin != null) {
                    UIHelper.enableBlend();
                    gui.method_25293(this.skin, x + 4, y + 4, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                    RenderSystem.enableBlend();
                    gui.method_25293(this.skin, x + 4, y + 4, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
                    RenderSystem.disableBlend();
                } else {
                    UIHelper.blit(gui, x + 4, y + 4, 32, 32, UNKNOWN);
                }
            }
            class_327 font = class_310.method_1551().field_1772;
            class_5250 ogName = class_2561.method_43470((String)this.name);
            if (name == null) {
                name = ogName;
            }
            name = TextUtils.replaceInText((class_5348)name, "\\$\\{name\\}", ogName);
            name = TextUtils.splitText((class_5348)name, "\n").get(0);
            name = class_2561.method_43473().method_10852((class_2561)name.method_27661().method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(this.name + "\n" + String.valueOf(this.owner)))))));
            name = Badges.appendBadges((class_2561)name, this.owner, false);
            class_2561 badges = Badges.fetchBadges(this.owner);
            if (!badges.getString().isEmpty()) {
                badges = class_2561.method_43470((String)" ").method_10852(badges);
            }
            this.nameLabel.setText((class_2561)TextUtils.trimToWidthEllipsis(font, (class_2561)name, width - 44 - font.method_27525((class_5348)badges), TextUtils.ELLIPSIS).method_27661().method_10852(badges));
            this.nameLabel.method_46421(x + 40);
            this.nameLabel.method_46419(y + 4);
            this.nameLabel.method_25394(gui, mouseX, mouseY, delta);
            if (avatar != null && avatar.nbt != null) {
                this.status.tick();
                this.status.method_46421(x + 40);
                Objects.requireNonNull(font);
                this.status.method_46419(y + 6 + 9);
                this.status.method_25394(gui, mouseX, mouseY, delta);
            }
            Objects.requireNonNull(font);
            int textY = y + height - 9 - 4;
            gui.method_27535(font, (class_2561)this.pack.getCategoryName().method_27693(this.pack.hasChanges() ? "*" : ""), x + 40, textY, 0xFFFFFF);
            if (this.disconnected) {
                gui.method_27535(font, DC_TEXT, x + width - font.method_27525((class_5348)DC_TEXT) - 4, textY, 0xFFFFFF);
            }
            pose.method_22909();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (button == 1) {
            this.context.method_46421((int)mouseX);
            this.context.method_46419((int)mouseY);
            this.context.setVisible(true);
            UIHelper.setContext(this.context);
            return true;
        }
        if (UIHelper.getContext() == this.context) {
            this.context.setVisible(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return !this.dragged && super.method_25405(mouseX, mouseY);
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.pack.isVisible();
    }
}

