/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.config;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.config.InputType;
import org.figuramc.figura.gui.widgets.ParentedButton;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import org.figuramc.figura.gui.widgets.config.CategoryWidget;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class InputElement
extends AbstractConfigElement {
    private final TextField textField;
    private final InputType inputType;

    public InputElement(int width, ConfigType.InputConfig<?> config, ConfigList parentList, CategoryWidget parentCategory) {
        super(width, config, parentList, parentCategory);
        this.inputType = config.inputType;
        this.textField = new InputField(0, 0, 90, 20, this.inputType.hint, this, text -> {
            if (this.inputType.validator.test((String)text)) {
                config.setTempValue((String)text);
            }
        });
        this.updateTextFieldText(this.formatText(config.tempValue));
        this.textField.getField().method_1870(class_437.method_25442());
        this.textField.setEnabled(FiguraMod.debugModeEnabled() || !config.disabled);
        this.children.add(0, this.textField);
        this.children.remove(this.resetButton);
        this.resetButton = new ParentedButton(this.method_46426() + width - 60, this.method_46427(), 60, 20, (class_2561)class_2561.method_43471((String)"controls.reset"), this, button -> {
            config.resetTemp();
            this.updateTextFieldText(this.formatText(config.tempValue));
        });
        this.children.add(this.resetButton);
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.resetButton.setActive(!this.isDefault());
        int color = 0xFFFFFF;
        String text = this.textField.getField().method_1882();
        if (!this.inputType.validator.test(text)) {
            color = 0xFF5555;
        } else if (!text.equals(this.formatText(this.initValue))) {
            class_5251 textColor = FiguraMod.getAccentColor().method_10973();
            color = textColor == null ? ColorUtils.Colors.AWESOME_BLUE.hex : textColor.method_27716();
        }
        this.textField.setColor(color);
        this.textField.setBorderColour(-16777216 + color);
        super.method_25394(gui, mouseX, mouseY, delta);
        if (this.inputType == InputType.HEX_COLOR) {
            int x = this.method_46426() + this.method_25368() - 178;
            int y = this.method_46427();
            if (this.getTextField().method_25370()) {
                UIHelper.fillRounded(gui, x, y, 20, 20, this.getTextField().getBorderColour());
            } else {
                UIHelper.blitSliced(gui, x, y, 20, 20, UIHelper.OUTLINE);
            }
            UIHelper.fillRounded(gui, x + 1, y + 1, 18, 18, (Integer)this.config.tempValue + -16777216);
        }
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
        this.textField.method_46421(x + this.method_25368() - 154);
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
        this.textField.method_46419(y);
    }

    @Override
    public boolean isDefault() {
        return this.textField.getField().method_1882().equals(this.formatText(this.config.defaultValue));
    }

    @Override
    public boolean isChanged() {
        return !this.textField.getField().method_1882().equals(this.formatText(this.initValue));
    }

    public TextField getTextField() {
        return this.textField;
    }

    public void updateTextFieldText(String text) {
        this.textField.getField().method_1852(text);
    }

    private String formatText(Object configValue) {
        return this.inputType == InputType.HEX_COLOR ? String.format("#%06X", (int)((Integer)configValue)) : configValue.toString();
    }

    private static class InputField
    extends TextField {
        private final InputElement parent;

        public InputField(int x, int y, int width, int height, TextField.HintType hint, InputElement parent, Consumer<String> changedListener) {
            super(x, y, width, height, hint, changedListener);
            this.parent = parent;
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isHovered() && super.method_25405(mouseX, mouseY);
        }
    }
}

