/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ScrollBarWidget
extends class_339
implements FiguraWidget {
    public static final class_2960 SCROLLBAR_TEXTURE = new FiguraIdentifier("textures/gui/scrollbar.png");
    protected final int headHeight = 20;
    protected final int headWidth = 10;
    protected boolean isScrolling = false;
    protected boolean vertical = true;
    protected double scrollPos;
    protected double scrollPrecise;
    protected double scrollRatio = 1.0;
    protected OnPress onPress;

    public ScrollBarWidget(int x, int y, int width, int height, double initialValue) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.scrollPrecise = initialValue;
        this.scrollPos = initialValue;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.method_37303() && this.method_25367() && this.method_25405(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            double scrollPos = class_3532.method_16436((double)this.scrollPrecise, (double)0.0, (double)((double)(this.vertical ? this.method_25364() - 20 : this.method_25368() - 10) + 2.0));
            if (this.vertical && mouseY < (double)this.method_46427() + scrollPos || mouseY > (double)this.method_46427() + scrollPos + 20.0) {
                this.scroll(-((double)this.method_46427() + scrollPos + 10.0 - mouseY));
            } else if (!this.vertical && mouseX < (double)this.method_46426() + scrollPos || mouseX > (double)this.method_46426() + scrollPos + 10.0) {
                this.scroll(-((double)this.method_46426() + scrollPos + 5.0 - mouseX));
            }
            this.isScrolling = true;
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            if (this.vertical) {
                if (Math.signum(deltaY) == -1.0) {
                    if (mouseY <= (double)(this.method_46427() + this.method_25364())) {
                        this.scroll(deltaY);
                        return true;
                    }
                } else if (mouseY >= (double)this.method_46427()) {
                    this.scroll(deltaY);
                    return true;
                }
            } else if (Math.signum(deltaX) == -1.0) {
                if (mouseX <= (double)(this.method_46426() + this.method_25368())) {
                    this.scroll(deltaX);
                    return true;
                }
            } else if (mouseX >= (double)this.method_46426()) {
                this.scroll(deltaX);
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount, double d) {
        if (!this.method_37303()) {
            return false;
        }
        this.scroll(-amount - d * (double)(this.vertical ? this.method_25364() : this.method_25368()) * 0.05 * this.scrollRatio);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_37303()) {
            return false;
        }
        if (keyCode > 261 && keyCode < 266) {
            this.scroll((double)((keyCode % 2 == 0 ? 1 : -1) * (this.vertical ? this.method_25364() : this.method_25368())) * 0.05 * this.scrollRatio);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), mouseX, mouseY);
    }

    protected void scroll(double amount) {
        this.scrollPrecise += amount / ((double)(this.vertical ? this.method_25364() - 20 : this.method_25368() - 10) + 2.0);
        this.setScrollProgress(this.scrollPrecise);
    }

    protected void lerpPos(float delta) {
        float lerpDelta = MathUtils.magicDelta(0.2f, delta);
        this.scrollPos = class_3532.method_16436((double)lerpDelta, (double)this.scrollPos, (double)this.getScrollProgress());
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.field_22762 = this.method_25405(mouseX, mouseY);
        UIHelper.enableBlend();
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_25368();
        int height = this.method_25364();
        gui.method_25293(SCROLLBAR_TEXTURE, x, y, width, 1, 10.0f, this.isScrolling ? 20.0f : 0.0f, 10, 1, 20, 40);
        gui.method_25293(SCROLLBAR_TEXTURE, x, y + 1, width, height - 2, 10.0f, this.isScrolling ? 21.0f : 1.0f, 10, 18, 20, 40);
        gui.method_25293(SCROLLBAR_TEXTURE, x, y + height - 1, width, 1, 10.0f, this.isScrolling ? 39.0f : 19.0f, 10, 1, 20, 40);
        this.lerpPos(delta);
        gui.method_25290(SCROLLBAR_TEXTURE, x, (int)((long)y + Math.round(class_3532.method_16436((double)this.scrollPos, (double)0.0, (double)(height - 20)))), 0.0f, this.method_25367() || this.isScrolling ? 20.0f : 0.0f, 10, 20, 20, 40);
    }

    protected void method_47399(class_6382 builder) {
    }

    @Override
    public boolean isVisible() {
        return this.field_22764;
    }

    @Override
    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    @Override
    public int method_46426() {
        return super.method_46426();
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
    }

    @Override
    public int method_46427() {
        return super.method_46427();
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
    }

    @Override
    public int method_25368() {
        return super.method_25368();
    }

    @Override
    public void method_25358(int width) {
        super.method_25358(width);
    }

    @Override
    public int method_25364() {
        return super.method_25364();
    }

    @Override
    public void method_53533(int height) {
        this.field_22759 = height;
    }

    public boolean method_37303() {
        return this.field_22763;
    }

    public void setActive(boolean active) {
        this.field_22763 = active;
    }

    public double getScrollProgress() {
        return this.scrollPrecise;
    }

    public void setScrollProgress(double amount) {
        this.setScrollProgress(amount, false);
    }

    public void setScrollProgressNoAnim(double amount) {
        this.setScrollProgress(amount, false);
        this.scrollPos = this.scrollPrecise;
    }

    public void setScrollProgress(double amount, boolean force) {
        amount = Double.isNaN(amount) ? 0.0 : amount;
        double d = this.scrollPrecise = force ? amount : class_3532.method_15350((double)amount, (double)0.0, (double)1.0);
        if (this.onPress != null) {
            this.onPress.onPress(this);
        }
    }

    public void setAction(OnPress onPress) {
        this.onPress = onPress;
    }

    public void setScrollRatio(double entryHeight, double heightDiff) {
        this.scrollRatio = ((double)this.method_25364() + entryHeight) / (heightDiff / 2.0);
    }

    public static interface OnPress {
        public void onPress(ScrollBarWidget var1);
    }
}

