/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.GameScreen;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.FiguraRemovable;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.PanelSelectorWidget;
import org.figuramc.figura.lua.api.ClientAPI;
import org.figuramc.figura.mixin.gui.ScreenAccessor;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public abstract class AbstractPanelScreen
extends class_437 {
    public static final List<class_2960> BACKGROUNDS = List.of(new FiguraIdentifier("textures/gui/background/background_0.png"), new FiguraIdentifier("textures/gui/background/background_1.png"), new FiguraIdentifier("textures/gui/background/background_2.png"));
    protected final class_437 parentScreen;
    public PanelSelectorWidget panels;
    public ContextMenu contextMenu;
    public class_2561 tooltip;
    private static final String EGG = "\u0109\u0109\u0108\u0108\u0107\u0106\u0107\u0106BA\u0101";
    private String egg = "\u0109\u0109\u0108\u0108\u0107\u0106\u0107\u0106BA\u0101";

    protected AbstractPanelScreen(class_437 parentScreen, class_2561 title) {
        super(title);
        this.parentScreen = parentScreen;
    }

    public Class<? extends class_437> getSelectedPanel() {
        return ((Object)((Object)this)).getClass();
    }

    protected void method_25426() {
        super.method_25426();
        this.panels = new PanelSelectorWidget(this.parentScreen, 0, 0, this.field_22789, this.getSelectedPanel());
        this.method_37063((class_364)this.panels);
        this.contextMenu = null;
        this.tooltip = null;
    }

    public void method_25393() {
        for (class_4068 renderable : this.renderables()) {
            if (!(renderable instanceof FiguraTickable)) continue;
            FiguraTickable tickable = (FiguraTickable)renderable;
            tickable.tick();
        }
        this.renderables().removeIf(r -> {
            FiguraRemovable removable;
            return r instanceof FiguraRemovable && (removable = (FiguraRemovable)r).isRemoved();
        });
        super.method_25393();
    }

    public List<class_4068> renderables() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        this.renderBackground(gui, delta);
        super.method_25394(gui, mouseX, mouseY, delta);
        this.renderOverlays(gui, mouseX, mouseY, delta);
    }

    public void renderBackground(class_332 gui, float delta) {
        float speed = ((Float)Configs.BACKGROUND_SCROLL_SPEED.tempValue).floatValue() * 0.125f;
        for (class_2960 background : BACKGROUNDS) {
            UIHelper.renderAnimatedBackground(gui, background, 0.0f, 0.0f, this.field_22789, this.field_22790, 64.0f, 64.0f, speed, delta);
            speed = (float)((double)speed / 0.5);
        }
    }

    public void renderOverlays(class_332 gui, int mouseX, int mouseY, float delta) {
        if (((Boolean)Configs.GUI_FPS.value).booleanValue()) {
            gui.method_25303(class_310.method_1551().field_1772, ClientAPI.getFPS() + " fps", 1, 1, 0xFFFFFF);
        }
        if (this.contextMenu != null && this.contextMenu.isVisible()) {
            class_4587 pose = gui.method_51448();
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, 500.0f);
            this.contextMenu.method_25394(gui, mouseX, mouseY, delta);
            pose.method_22909();
        }
        if (this.tooltip != null) {
            UIHelper.renderTooltip(gui, this.tooltip, mouseX, mouseY, true);
        }
        this.tooltip = null;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.contextMenuClick(mouseX, mouseY, button)) {
            return true;
        }
        class_364 widget = null;
        for (class_364 children : List.copyOf(this.method_25396())) {
            boolean clicked = children.method_25402(mouseX, mouseY, button);
            children.method_25365(clicked);
            if (!clicked) continue;
            widget = children;
        }
        if (this.method_25399() != widget) {
            this.method_25395(widget);
        }
        if (widget != null) {
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    public boolean contextMenuClick(double mouseX, double mouseY, int button) {
        if (this.contextMenu != null && this.contextMenu.isVisible()) {
            boolean clicked = this.contextMenu.method_25402(mouseX, mouseY, button);
            if (!clicked && this.contextMenu.parent != null && this.contextMenu.parent.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            this.contextMenu.setVisible(false);
            return clicked;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.method_25399() != null && this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean bool;
        boolean bl = bool = this.method_25399() != null && this.method_25399().method_25406(mouseX, mouseY, button);
        if (bool) {
            this.method_25395(null);
        }
        this.method_25398(false);
        return bool;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount, double d) {
        if (this.contextMenu != null) {
            this.contextMenu.setVisible(false);
        }
        boolean ret = false;
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY)) continue;
            ret = ret || child.method_25401(mouseX, mouseY, amount, d);
        }
        return ret;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.egg = this.egg + (char)keyCode;
        this.egg = this.egg.substring(1);
        if (EGG.equals(this.egg)) {
            class_310.method_1551().method_1507((class_437)new GameScreen(this));
            return true;
        }
        if (this.method_25396().contains(this.panels) && this.panels.cycleTab(keyCode)) {
            return true;
        }
        if (keyCode == 256 && this.contextMenu != null && this.contextMenu.isVisible()) {
            this.contextMenu.setVisible(false);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_57734(float tickDelta) {
    }
}

