/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PopupMenu {
    private static final FiguraIdentifier BACKGROUND = new FiguraIdentifier("textures/gui/popup.png");
    private static final FiguraIdentifier ICONS = new FiguraIdentifier("textures/gui/popup_icons.png");
    private static final class_5250 VERSION_WARN = class_2561.method_43473().method_10852((class_2561)Badges.System.WARNING.badge.method_27661().method_27696(class_2583.field_24360.method_27704(Badges.FONT))).method_27693(" ").method_10852((class_2561)Badges.System.WARNING.desc.method_27661().method_27692(class_124.field_1054));
    private static final class_5250 ERROR_WARN = class_2561.method_43473().method_10852((class_2561)Badges.System.ERROR.badge.method_27661().method_27696(class_2583.field_24360.method_27704(Badges.FONT))).method_27693(" ").method_10852((class_2561)Badges.System.ERROR.desc.method_27661().method_27692(class_124.field_1061));
    private static final class_5250 PERMISSION_WARN = class_2561.method_43473().method_10852((class_2561)Badges.System.PERMISSIONS.badge.method_27661().method_27696(class_2583.field_24360.method_27704(Badges.FONT))).method_27693(" ").method_10852((class_2561)Badges.System.PERMISSIONS.desc.method_27661().method_27692(class_124.field_1078));
    private static final List<Pair<class_2561, Consumer<UUID>>> BUTTONS = List.of(Pair.of((Object)FiguraText.of("popup_menu.cancel"), id -> {}), Pair.of((Object)FiguraText.of("popup_menu.reload"), id -> {
        AvatarManager.reloadAvatar(id);
        FiguraToast.sendToast(FiguraText.of("toast.reload"));
    }), Pair.of((Object)FiguraText.of("popup_menu.increase_permissions"), id -> {
        PermissionPack.PlayerPermissionPack pack = PermissionManager.get(id);
        if (PermissionManager.increaseCategory(pack)) {
            FiguraToast.sendToast((Object)FiguraText.of("toast.permission_change"), ((PermissionPack)pack).getCategoryName());
        }
    }), Pair.of((Object)FiguraText.of("popup_menu.decrease_permissions"), id -> {
        PermissionPack.PlayerPermissionPack pack = PermissionManager.get(id);
        if (PermissionManager.decreaseCategory(pack)) {
            FiguraToast.sendToast((Object)FiguraText.of("toast.permission_change"), ((PermissionPack)pack).getCategoryName());
        }
    }));
    private static final int LENGTH = BUTTONS.size();
    private static int index = 0;
    private static boolean enabled = false;
    private static class_1297 entity;
    private static UUID id;

    public static void render(class_332 gui) {
        Avatar avatar;
        if (!PopupMenu.isEnabled()) {
            return;
        }
        if (entity == null) {
            id = null;
            return;
        }
        id = entity.method_5667();
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || entity.method_5756((class_1657)minecraft.field_1724) && entity != minecraft.field_1724) {
            entity = null;
            id = null;
            return;
        }
        RenderSystem.disableDepthTest();
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        FiguraVec3 worldPos = FiguraVec3.fromVec3(entity.method_30950(minecraft.method_60646().method_60637(false)));
        worldPos.add(0.0, (double)(entity.method_17682() + 0.1f), 0.0);
        FiguraVec4 vec = MathUtils.worldToScreenSpace(worldPos);
        if (vec.z < 1.0) {
            return;
        }
        class_1041 window = minecraft.method_22683();
        double w = window.method_4486();
        double h = window.method_4502();
        double s = (double)((Float)Configs.POPUP_SCALE.value).floatValue() * Math.max(Math.min((double)window.method_4506() * 0.035 / vec.w * (1.0 / window.method_4495()), (double)((Float)Configs.POPUP_MAX_SIZE.value).floatValue()), (double)((Float)Configs.POPUP_MIN_SIZE.value).floatValue());
        pose.method_22904((vec.x + 1.0) / 2.0 * w, (vec.y + 1.0) / 2.0 * h, -100.0);
        pose.method_22905((float)(s * 0.5), (float)(s * 0.5), 1.0f);
        int width = LENGTH * 18;
        UIHelper.enableBlend();
        int frame = (Boolean)Configs.REDUCED_MOTION.value != false ? 0 : (int)((float)FiguraMod.ticks / 5.0f % 4.0f);
        gui.method_25293((class_2960)BACKGROUND, width / -2, -24, width, 26, 0.0f, (float)(frame * 26), width, 26, width, 104);
        pose.method_46416(0.0f, 0.0f, -2.0f);
        UIHelper.enableBlend();
        for (int i = 0; i < LENGTH; ++i) {
            gui.method_25293((class_2960)ICONS, width / -2 + 18 * i, -24, 18, 18, (float)(18 * i), i == index ? 18.0f : 0.0f, 18, 18, width, 36);
        }
        class_327 font = minecraft.field_1772;
        class_2561 title = (class_2561)BUTTONS.get(index).getFirst();
        PermissionPack.PlayerPermissionPack tc = PermissionManager.get(id);
        class_5250 permissionName = ((PermissionPack)tc).getCategoryName().method_27693(tc.hasChanges() ? "*" : "");
        class_5250 name = entity.method_5477().method_27661();
        boolean error = false;
        boolean version = false;
        boolean noPermissions = false;
        class_2561 badges = Badges.fetchBadges(id);
        if (!badges.getString().isEmpty()) {
            name.method_27693(" ").method_10852(badges);
        }
        if ((avatar = AvatarManager.getAvatarForPlayer(id)) != null) {
            error = avatar.scriptError;
            version = avatar.versionStatus > 0;
            noPermissions = !avatar.noPermissions.isEmpty();
        }
        UIHelper.renderOutlineText(gui, font, (class_2561)name, -font.method_27525((class_5348)name) / 2, -36, 0xFFFFFF, 0x202020);
        pose.method_22905(0.5f, 0.5f, 0.5f);
        pose.method_46416(0.0f, 0.0f, -1.0f);
        UIHelper.renderOutlineText(gui, font, (class_2561)permissionName, -font.method_27525((class_5348)permissionName) / 2, -54, 0xFFFFFF, 0x202020);
        gui.method_27535(font, title, -width + 4, -12, 0xFFFFFF);
        if (error) {
            UIHelper.renderOutlineText(gui, font, (class_2561)ERROR_WARN, -font.method_27525((class_5348)ERROR_WARN) / 2, 0, 0xFFFFFF, 0x202020);
        }
        if (version) {
            int n;
            int n2 = -font.method_27525((class_5348)VERSION_WARN) / 2;
            if (error) {
                Objects.requireNonNull(font);
                n = 9;
            } else {
                n = 0;
            }
            UIHelper.renderOutlineText(gui, font, (class_2561)VERSION_WARN, n2, n, 0xFFFFFF, 0x202020);
        }
        if (noPermissions) {
            int n;
            int n3;
            int n4 = -font.method_27525((class_5348)PERMISSION_WARN) / 2;
            if (error) {
                Objects.requireNonNull(font);
                n3 = 9;
            } else {
                n3 = 0;
            }
            if (version) {
                Objects.requireNonNull(font);
                n = 9;
            } else {
                n = 0;
            }
            UIHelper.renderOutlineText(gui, font, (class_2561)PERMISSION_WARN, n4, n3 + n, 0xFFFFFF, 0x202020);
        }
        pose.method_22909();
    }

    public static void scroll(double d) {
        index = (int)((double)index - d + (double)LENGTH) % LENGTH;
    }

    public static void hotbarKeyPressed(int i) {
        if (i < LENGTH && i >= 0) {
            index = i;
        }
    }

    public static void run() {
        if (id != null) {
            ((Consumer)BUTTONS.get(index).getSecond()).accept(id);
        }
        enabled = false;
        entity = null;
        id = null;
        index = 0;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        PopupMenu.enabled = enabled;
    }

    public static boolean hasEntity() {
        return entity != null;
    }

    public static void setEntity(class_1297 entity) {
        PopupMenu.entity = entity;
    }

    public static UUID getEntityId() {
        return id;
    }
}

